/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.execution.internal.TaskInputsListener;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.Cast;

public class SkipEmptySourceFilesTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = Logging.getLogger(SkipEmptySourceFilesTaskExecuter.class);
    private final TaskInputsListener taskInputsListener;
    private final TaskExecuter executer;

    public SkipEmptySourceFilesTaskExecuter(TaskInputsListener taskInputsListener, TaskExecuter executer) {
        this.taskInputsListener = taskInputsListener;
        this.executer = executer;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        FileCollection sourceFiles = task.getInputs().getSourceFiles();
        if (task.getInputs().getHasSourceFiles() && sourceFiles.isEmpty()) {
            LOGGER.info("Skipping {} as it has no source files.", (Object)task);
            state.upToDate();
            this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)sourceFiles));
            return;
        }
        this.taskInputsListener.onExecute(task, (FileCollectionInternal)Cast.cast(FileCollectionInternal.class, (Object)task.getInputs().getFiles()));
        this.executer.execute(task, state, context);
    }
}

