/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IPermissionController;
import android.os.IServiceManager;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManagerProxy;

public abstract class ServiceManagerNative
extends Binder
implements IServiceManager {
    public static IServiceManager asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IServiceManager in = (IServiceManager)obj.queryLocalInterface("android.os.IServiceManager");
        if (in != null) {
            return in;
        }
        return new ServiceManagerProxy(obj);
    }

    public ServiceManagerNative() {
        this.attachInterface(this, "android.os.IServiceManager");
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) {
        try {
            switch (code) {
                case 1: {
                    data.enforceInterface("android.os.IServiceManager");
                    String name = data.readString();
                    IBinder service = this.getService(name);
                    reply.writeStrongBinder(service);
                    return true;
                }
                case 2: {
                    data.enforceInterface("android.os.IServiceManager");
                    String name = data.readString();
                    IBinder service = this.checkService(name);
                    reply.writeStrongBinder(service);
                    return true;
                }
                case 3: {
                    data.enforceInterface("android.os.IServiceManager");
                    String name = data.readString();
                    IBinder service = data.readStrongBinder();
                    boolean allowIsolated = data.readInt() != 0;
                    this.addService(name, service, allowIsolated);
                    return true;
                }
                case 4: {
                    data.enforceInterface("android.os.IServiceManager");
                    String[] list = this.listServices();
                    reply.writeStringArray(list);
                    return true;
                }
                case 6: {
                    data.enforceInterface("android.os.IServiceManager");
                    IPermissionController controller = IPermissionController.Stub.asInterface(data.readStrongBinder());
                    this.setPermissionController(controller);
                    return true;
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public IBinder asBinder() {
        return this;
    }
}

