/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import android.util.Slog;
import com.android.internal.util.AsyncService;
import java.util.Stack;

public class AsyncChannel {
    private static final String TAG = "AsyncChannel";
    private static final boolean DBG = false;
    private static final int BASE = 69632;
    public static final int CMD_CHANNEL_HALF_CONNECTED = 69632;
    public static final int CMD_CHANNEL_FULL_CONNECTION = 69633;
    public static final int CMD_CHANNEL_FULLY_CONNECTED = 69634;
    public static final int CMD_CHANNEL_DISCONNECT = 69635;
    public static final int CMD_CHANNEL_DISCONNECTED = 69636;
    private static final int CMD_TO_STRING_COUNT = 5;
    private static String[] sCmdToString = new String[5];
    public static final int STATUS_SUCCESSFUL = 0;
    public static final int STATUS_BINDING_UNSUCCESSFUL = 1;
    public static final int STATUS_SEND_UNSUCCESSFUL = 2;
    public static final int STATUS_FULL_CONNECTION_REFUSED_ALREADY_CONNECTED = 3;
    public static final int STATUS_REMOTE_DISCONNECTION = 4;
    private AsyncChannelConnection mConnection;
    private Context mSrcContext;
    private Handler mSrcHandler;
    private Messenger mSrcMessenger;
    private Messenger mDstMessenger;
    private DeathMonitor mDeathMonitor;

    protected static String cmdToString(int cmd) {
        if ((cmd -= 69632) >= 0 && cmd < sCmdToString.length) {
            return sCmdToString[cmd];
        }
        return null;
    }

    public int connectSrcHandlerToPackageSync(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
        this.mConnection = new AsyncChannelConnection();
        this.mSrcContext = srcContext;
        this.mSrcHandler = srcHandler;
        this.mSrcMessenger = new Messenger(srcHandler);
        this.mDstMessenger = null;
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.setClassName(dstPackageName, dstClassName);
        boolean result = srcContext.bindService(intent, this.mConnection, 1);
        return result ? 0 : 1;
    }

    public int connectSync(Context srcContext, Handler srcHandler, Messenger dstMessenger) {
        this.connected(srcContext, srcHandler, dstMessenger);
        return 0;
    }

    public int connectSync(Context srcContext, Handler srcHandler, Handler dstHandler) {
        return this.connectSync(srcContext, srcHandler, new Messenger(dstHandler));
    }

    public int fullyConnectSync(Context srcContext, Handler srcHandler, Handler dstHandler) {
        int status = this.connectSync(srcContext, srcHandler, dstHandler);
        if (status == 0) {
            Message response = this.sendMessageSynchronously(69633);
            status = response.arg1;
        }
        return status;
    }

    public void connect(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
        class ConnectAsync
        implements Runnable {
            Context mSrcCtx;
            Handler mSrcHdlr;
            String mDstPackageName;
            String mDstClassName;

            ConnectAsync(Context srcContext, Handler srcHandler, String dstPackageName, String dstClassName) {
                this.mSrcCtx = srcContext;
                this.mSrcHdlr = srcHandler;
                this.mDstPackageName = dstPackageName;
                this.mDstClassName = dstClassName;
            }

            @Override
            public void run() {
                int result = AsyncChannel.this.connectSrcHandlerToPackageSync(this.mSrcCtx, this.mSrcHdlr, this.mDstPackageName, this.mDstClassName);
                AsyncChannel.this.replyHalfConnected(result);
            }
        }
        ConnectAsync ca = new ConnectAsync(srcContext, srcHandler, dstPackageName, dstClassName);
        new Thread(ca).start();
    }

    public void connect(Context srcContext, Handler srcHandler, Class<?> klass) {
        this.connect(srcContext, srcHandler, klass.getPackage().getName(), klass.getName());
    }

    public void connect(Context srcContext, Handler srcHandler, Messenger dstMessenger) {
        this.connected(srcContext, srcHandler, dstMessenger);
        this.replyHalfConnected(0);
    }

    public void connected(Context srcContext, Handler srcHandler, Messenger dstMessenger) {
        this.mSrcContext = srcContext;
        this.mSrcHandler = srcHandler;
        this.mSrcMessenger = new Messenger(this.mSrcHandler);
        this.mDstMessenger = dstMessenger;
        this.linkToDeathMonitor();
    }

    public void connect(Context srcContext, Handler srcHandler, Handler dstHandler) {
        this.connect(srcContext, srcHandler, new Messenger(dstHandler));
    }

    public void connect(AsyncService srcAsyncService, Messenger dstMessenger) {
        this.connect((Context)srcAsyncService, srcAsyncService.getHandler(), dstMessenger);
    }

    public void disconnected() {
        this.mSrcContext = null;
        this.mSrcHandler = null;
        this.mSrcMessenger = null;
        this.mDstMessenger = null;
        this.mDeathMonitor = null;
        this.mConnection = null;
    }

    public void disconnect() {
        if (this.mConnection != null && this.mSrcContext != null) {
            this.mSrcContext.unbindService(this.mConnection);
            this.mConnection = null;
        }
        try {
            Message msg = Message.obtain();
            msg.what = 69636;
            msg.replyTo = this.mSrcMessenger;
            this.mDstMessenger.send(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.replyDisconnected(0);
        this.mSrcHandler = null;
        if (this.mConnection == null && this.mDstMessenger != null && this.mDeathMonitor != null) {
            this.mDstMessenger.getBinder().unlinkToDeath(this.mDeathMonitor, 0);
            this.mDeathMonitor = null;
        }
    }

    public void sendMessage(Message msg) {
        msg.replyTo = this.mSrcMessenger;
        try {
            this.mDstMessenger.send(msg);
        }
        catch (RemoteException e) {
            this.replyDisconnected(2);
        }
    }

    public void sendMessage(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.sendMessage(msg);
    }

    public void sendMessage(int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        this.sendMessage(msg);
    }

    public void replyToMessage(Message srcMsg, Message dstMsg) {
        try {
            dstMsg.replyTo = this.mSrcMessenger;
            srcMsg.replyTo.send(dstMsg);
        }
        catch (RemoteException e) {
            AsyncChannel.log("TODO: handle replyToMessage RemoteException" + e);
            e.printStackTrace();
        }
    }

    public void replyToMessage(Message srcMsg, int what) {
        Message msg = Message.obtain();
        msg.what = what;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        this.replyToMessage(srcMsg, msg);
    }

    public void replyToMessage(Message srcMsg, int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        this.replyToMessage(srcMsg, msg);
    }

    public Message sendMessageSynchronously(Message msg) {
        Message resultMsg = SyncMessenger.sendMessageSynchronously(this.mDstMessenger, msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what) {
        Message msg = Message.obtain();
        msg.what = what;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, int arg1) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, int arg1, int arg2) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, int arg1, int arg2, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.arg1 = arg1;
        msg.arg2 = arg2;
        msg.obj = obj;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    public Message sendMessageSynchronously(int what, Object obj) {
        Message msg = Message.obtain();
        msg.what = what;
        msg.obj = obj;
        Message resultMsg = this.sendMessageSynchronously(msg);
        return resultMsg;
    }

    private void replyHalfConnected(int status) {
        Message msg = this.mSrcHandler.obtainMessage(69632);
        msg.arg1 = status;
        msg.obj = this;
        msg.replyTo = this.mDstMessenger;
        if (!this.linkToDeathMonitor()) {
            msg.arg1 = 1;
        }
        this.mSrcHandler.sendMessage(msg);
    }

    private boolean linkToDeathMonitor() {
        if (this.mConnection == null && this.mDeathMonitor == null) {
            this.mDeathMonitor = new DeathMonitor();
            try {
                this.mDstMessenger.getBinder().linkToDeath(this.mDeathMonitor, 0);
            }
            catch (RemoteException e) {
                this.mDeathMonitor = null;
                return false;
            }
        }
        return true;
    }

    private void replyDisconnected(int status) {
        if (this.mSrcHandler == null) {
            return;
        }
        Message msg = this.mSrcHandler.obtainMessage(69636);
        msg.arg1 = status;
        msg.obj = this;
        msg.replyTo = this.mDstMessenger;
        this.mSrcHandler.sendMessage(msg);
    }

    private static void log(String s) {
        Slog.d(TAG, s);
    }

    static {
        AsyncChannel.sCmdToString[0] = "CMD_CHANNEL_HALF_CONNECTED";
        AsyncChannel.sCmdToString[1] = "CMD_CHANNEL_FULL_CONNECTION";
        AsyncChannel.sCmdToString[2] = "CMD_CHANNEL_FULLY_CONNECTED";
        AsyncChannel.sCmdToString[3] = "CMD_CHANNEL_DISCONNECT";
        AsyncChannel.sCmdToString[4] = "CMD_CHANNEL_DISCONNECTED";
    }

    private class DeathMonitor
    implements IBinder.DeathRecipient {
        DeathMonitor() {
        }

        @Override
        public void binderDied() {
            AsyncChannel.this.replyDisconnected(4);
        }
    }

    class AsyncChannelConnection
    implements ServiceConnection {
        AsyncChannelConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName className, IBinder service) {
            AsyncChannel.this.mDstMessenger = new Messenger(service);
            AsyncChannel.this.replyHalfConnected(0);
        }

        @Override
        public void onServiceDisconnected(ComponentName className) {
            AsyncChannel.this.replyDisconnected(0);
        }
    }

    private static class SyncMessenger {
        private static Stack<SyncMessenger> sStack = new Stack();
        private static int sCount = 0;
        private HandlerThread mHandlerThread;
        private SyncHandler mHandler;
        private Messenger mMessenger;

        private SyncMessenger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static SyncMessenger obtain() {
            SyncMessenger sm;
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                if (sStack.isEmpty()) {
                    sm = new SyncMessenger();
                    sm.mHandlerThread = new HandlerThread("SyncHandler-" + sCount++);
                    sm.mHandlerThread.start();
                    SyncMessenger syncMessenger = sm;
                    syncMessenger.getClass();
                    sm.mHandler = syncMessenger.new SyncHandler(sm.mHandlerThread.getLooper());
                    sm.mMessenger = new Messenger(sm.mHandler);
                } else {
                    sm = sStack.pop();
                }
            }
            return sm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recycle() {
            Stack<SyncMessenger> stack = sStack;
            synchronized (stack) {
                sStack.push(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Message sendMessageSynchronously(Messenger dstMessenger, Message msg) {
            SyncMessenger sm;
            block7: {
                sm = SyncMessenger.obtain();
                try {
                    if (dstMessenger != null && msg != null) {
                        msg.replyTo = sm.mMessenger;
                        Object object = sm.mHandler.mLockObject;
                        synchronized (object) {
                            dstMessenger.send(msg);
                            sm.mHandler.mLockObject.wait();
                            break block7;
                        }
                    }
                    sm.mHandler.mResultMsg = null;
                }
                catch (InterruptedException e) {
                    sm.mHandler.mResultMsg = null;
                }
                catch (RemoteException e) {
                    sm.mHandler.mResultMsg = null;
                }
            }
            Message resultMsg = sm.mHandler.mResultMsg;
            sm.recycle();
            return resultMsg;
        }

        private class SyncHandler
        extends Handler {
            private Object mLockObject;
            private Message mResultMsg;

            private SyncHandler(Looper looper) {
                super(looper);
                this.mLockObject = new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(Message msg) {
                this.mResultMsg = Message.obtain();
                this.mResultMsg.copyFrom(msg);
                Object object = this.mLockObject;
                synchronized (object) {
                    this.mLockObject.notify();
                }
            }
        }
    }
}

