/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android.support;

import android.content.Context;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.util.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SupportPreferencesUtil {
    private static final String PREFERENCE_PKG = "android.support.v7.preference";
    private static final String PREFERENCE_MANAGER = "android.support.v7.preference.PreferenceManager";
    private static final String PREFERENCE_GROUP = "android.support.v7.preference.PreferenceGroup";
    private static final String PREFERENCE_GROUP_ADAPTER = "android.support.v7.preference.PreferenceGroupAdapter";
    private static final String PREFERENCE_INFLATER = "android.support.v7.preference.PreferenceInflater";

    private SupportPreferencesUtil() {
    }

    private static Object instantiateClass(LayoutlibCallback callback, String className, Class[] constructorSignature, Object[] constructorArgs) throws ReflectionUtils.ReflectionException {
        try {
            Object instance = callback.loadClass(className, constructorSignature, constructorArgs);
            if (instance == null) {
                throw new ClassNotFoundException(className + " class not found");
            }
            return instance;
        }
        catch (ClassNotFoundException e) {
            throw new ReflectionUtils.ReflectionException(e);
        }
    }

    private static Object createPreferenceGroupAdapter(LayoutlibCallback callback, Object preferenceScreen) throws ReflectionUtils.ReflectionException {
        Class<?> preferenceGroupClass = ReflectionUtils.getClassInstance(preferenceScreen, PREFERENCE_GROUP);
        return SupportPreferencesUtil.instantiateClass(callback, PREFERENCE_GROUP_ADAPTER, new Class[]{preferenceGroupClass}, new Object[]{preferenceScreen});
    }

    private static Object createInflatedPreference(LayoutlibCallback callback, Context context, XmlPullParser parser, Object preferenceScreen, Object preferenceManager) throws ReflectionUtils.ReflectionException {
        Class<?> preferenceGroupClass = ReflectionUtils.getClassInstance(preferenceScreen, PREFERENCE_GROUP);
        Object preferenceInflater = SupportPreferencesUtil.instantiateClass(callback, PREFERENCE_INFLATER, new Class[]{Context.class, preferenceManager.getClass()}, new Object[]{context, preferenceManager});
        Object inflatedPreference = ReflectionUtils.invoke(ReflectionUtils.getAccessibleMethod(preferenceInflater.getClass(), "inflate", XmlPullParser.class, preferenceGroupClass), preferenceInflater, parser, null);
        if (inflatedPreference == null) {
            throw new ReflectionUtils.ReflectionException("inflate method returned null");
        }
        return inflatedPreference;
    }

    private static Context getThemedContext(BridgeContext bridgeContext) {
        int styleId;
        RenderResources resources = bridgeContext.getRenderResources();
        ResourceValue preferenceTheme = resources.findItemInTheme("preferenceTheme", false);
        if (preferenceTheme != null) {
            preferenceTheme = resources.resolveResValue(preferenceTheme);
        }
        if (preferenceTheme instanceof StyleResourceValue && (styleId = bridgeContext.getDynamicIdByStyle((StyleResourceValue)preferenceTheme)) != 0) {
            return new ContextThemeWrapper((Context)bridgeContext, styleId);
        }
        return null;
    }

    private static LinearLayout setUpPreferencesListView(BridgeContext bridgeContext, Context themedContext, ArrayList<Object> viewCookie, Object preferenceGroupAdapter) throws ReflectionUtils.ReflectionException {
        Integer preferencesCount;
        LinearLayout listView = new LinearLayout(themedContext);
        listView.setOrientation(1);
        listView.setLayoutParams(new LinearLayout.LayoutParams(-1, -1));
        if (!viewCookie.isEmpty()) {
            bridgeContext.addViewKey(listView, viewCookie.get(0));
        }
        if ((preferencesCount = (Integer)ReflectionUtils.invoke(ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "getItemCount", new Class[0]), preferenceGroupAdapter, new Object[0])) == null) {
            return listView;
        }
        Method getItemId = ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "getItemId", Integer.TYPE);
        Method getItemViewType = ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "getItemViewType", Integer.TYPE);
        Method onCreateViewHolder = ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "onCreateViewHolder", ViewGroup.class, Integer.TYPE);
        for (int i = 0; i < preferencesCount; ++i) {
            Long id2 = (Long)ReflectionUtils.invoke(getItemId, preferenceGroupAdapter, i);
            if (id2 == null) continue;
            Integer type = (Integer)ReflectionUtils.invoke(getItemViewType, preferenceGroupAdapter, i);
            Object viewHolder = ReflectionUtils.invoke(onCreateViewHolder, preferenceGroupAdapter, listView, type);
            if (viewHolder == null) continue;
            ReflectionUtils.invoke(ReflectionUtils.getMethod(preferenceGroupAdapter.getClass(), "onBindViewHolder", viewHolder.getClass(), Integer.TYPE), preferenceGroupAdapter, viewHolder, i);
            try {
                View itemView = (View)viewHolder.getClass().getField("itemView").get(viewHolder);
                int arrayPosition = id2.intValue() - 1;
                if (arrayPosition >= 0 && arrayPosition < viewCookie.size()) {
                    bridgeContext.addViewKey(itemView, viewCookie.get(arrayPosition));
                }
                listView.addView(itemView);
                continue;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return listView;
    }

    public static View inflatePreference(BridgeContext bridgeContext, XmlPullParser parser, ViewGroup root) {
        try {
            LayoutlibCallback callback = bridgeContext.getLayoutlibCallback();
            Context context = SupportPreferencesUtil.getThemedContext(bridgeContext);
            if (context == null) {
                return null;
            }
            Object preferenceManager = SupportPreferencesUtil.instantiateClass(callback, PREFERENCE_MANAGER, new Class[]{Context.class}, new Object[]{context});
            Object preferenceScreen = ReflectionUtils.invoke(ReflectionUtils.getMethod(preferenceManager.getClass(), "createPreferenceScreen", Context.class), preferenceManager, context);
            if (preferenceScreen == null) {
                return null;
            }
            final ArrayList<Object> viewCookie = new ArrayList<Object>();
            if (parser instanceof BridgeXmlBlockParser) {
                parser = new BridgeXmlBlockParser(parser, null, false){

                    @Override
                    public Object getViewCookie() {
                        return ((BridgeXmlBlockParser)this.getParser()).getViewCookie();
                    }

                    @Override
                    public int next() throws XmlPullParserException, IOException {
                        int ev = super.next();
                        if (ev == 2) {
                            viewCookie.add(this.getViewCookie());
                        }
                        return ev;
                    }
                };
            }
            Object inflatedPreference = SupportPreferencesUtil.createInflatedPreference(callback, context, parser, preferenceScreen, preferenceManager);
            Object preferenceGroupAdapter = SupportPreferencesUtil.createPreferenceGroupAdapter(callback, inflatedPreference);
            LinearLayout listView = SupportPreferencesUtil.setUpPreferencesListView(bridgeContext, context, viewCookie, preferenceGroupAdapter);
            ScrollView scrollView = new ScrollView(context);
            scrollView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            scrollView.addView(listView);
            if (root != null) {
                root.addView(scrollView);
            }
            return scrollView;
        }
        catch (ReflectionUtils.ReflectionException e) {
            return null;
        }
    }
}

