/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.ArrayRow;
import android.support.constraint.solver.Cache;
import android.support.constraint.solver.EquationCreation;
import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.Animator;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Solvable;
import android.support.constraint.solver.widgets.WidgetContainer;
import java.util.ArrayList;

public class ConstraintWidget
implements Solvable {
    private static final boolean AUTOTAG_CENTER = false;
    private Animator mAnimator = new Animator(this);
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 4;
    public static final int GONE = 8;
    int mDistToTop;
    int mDistToLeft;
    int mDistToRight;
    int mDistToBottom;
    boolean mVisited;
    ConstraintAnchor mLeft = new ConstraintAnchor(this, ConstraintAnchor.Type.LEFT);
    ConstraintAnchor mTop = new ConstraintAnchor(this, ConstraintAnchor.Type.TOP);
    ConstraintAnchor mRight = new ConstraintAnchor(this, ConstraintAnchor.Type.RIGHT);
    ConstraintAnchor mBottom = new ConstraintAnchor(this, ConstraintAnchor.Type.BOTTOM);
    ConstraintAnchor mBaseline = new ConstraintAnchor(this, ConstraintAnchor.Type.BASELINE);
    ConstraintAnchor mCenterX = new ConstraintAnchor(this, ConstraintAnchor.Type.CENTER_X);
    ConstraintAnchor mCenterY = new ConstraintAnchor(this, ConstraintAnchor.Type.CENTER_Y);
    ConstraintAnchor mCenter = new ConstraintAnchor(this, ConstraintAnchor.Type.CENTER);
    protected ArrayList<ConstraintAnchor> mAnchors = new ArrayList();
    ConstraintWidget mParent = null;
    private int mWidth = 0;
    private int mHeight = 0;
    private float mDimensionRatio = 0.0f;
    private int mSolverLeft = 0;
    private int mSolverTop = 0;
    private int mSolverRight = 0;
    private int mSolverBottom = 0;
    protected int mX = 0;
    protected int mY = 0;
    private int mDrawX = 0;
    private int mDrawY = 0;
    private int mDrawWidth = 0;
    private int mDrawHeight = 0;
    protected int mOffsetX = 0;
    protected int mOffsetY = 0;
    private int mBaselineDistance = 0;
    private int mMinWidth;
    private int mMinHeight;
    private int mWrapWidth;
    private int mWrapHeight;
    public static float DEFAULT_BIAS = 0.5f;
    private float mHorizontalBiasPercent = DEFAULT_BIAS;
    private float mVerticalBiasPercent = DEFAULT_BIAS;
    private DimensionBehaviour mHorizontalDimensionBehaviour = DimensionBehaviour.FIXED;
    private DimensionBehaviour mVerticalDimensionBehaviour = DimensionBehaviour.FIXED;
    private Object mCompanionWidget;
    private int mContainerItemSkip = 0;
    private int mVisibility = 0;
    private String mDebugName = null;
    private String mType = null;

    public void reset() {
        this.mLeft.reset();
        this.mTop.reset();
        this.mRight.reset();
        this.mBottom.reset();
        this.mBaseline.reset();
        this.mCenterX.reset();
        this.mCenterY.reset();
        this.mCenter.reset();
        this.mParent = null;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mDimensionRatio = 0.0f;
        this.mX = 0;
        this.mY = 0;
        this.mDrawX = 0;
        this.mDrawY = 0;
        this.mDrawWidth = 0;
        this.mDrawHeight = 0;
        this.mOffsetX = 0;
        this.mOffsetY = 0;
        this.mBaselineDistance = 0;
        this.mMinWidth = 0;
        this.mMinHeight = 0;
        this.mWrapWidth = 0;
        this.mWrapHeight = 0;
        this.mHorizontalBiasPercent = DEFAULT_BIAS;
        this.mVerticalBiasPercent = DEFAULT_BIAS;
        this.mHorizontalDimensionBehaviour = DimensionBehaviour.FIXED;
        this.mVerticalDimensionBehaviour = DimensionBehaviour.FIXED;
        this.mCompanionWidget = null;
        this.mContainerItemSkip = 0;
        this.mVisibility = 0;
        this.mDebugName = null;
        this.mType = null;
    }

    public ConstraintWidget() {
        this.addAnchors();
    }

    public ConstraintWidget(int x, int y, int width, int height) {
        this.mX = x;
        this.mY = y;
        this.mWidth = width;
        this.mHeight = height;
        this.addAnchors();
        this.forceUpdateDrawPosition();
    }

    public ConstraintWidget(int width, int height) {
        this(0, 0, width, height);
    }

    public void resetSolverVariables(Cache cache) {
        this.mLeft.resetSolverVariable(cache);
        this.mTop.resetSolverVariable(cache);
        this.mRight.resetSolverVariable(cache);
        this.mBottom.resetSolverVariable(cache);
        this.mBaseline.resetSolverVariable(cache);
        this.mCenter.resetSolverVariable(cache);
        this.mCenterX.resetSolverVariable(cache);
        this.mCenterY.resetSolverVariable(cache);
    }

    public void resetGroups() {
        int numAnchors = this.mAnchors.size();
        for (int i = 0; i < numAnchors; ++i) {
            this.mAnchors.get((int)i).mGroup = Integer.MAX_VALUE;
        }
    }

    private void addAnchors() {
        this.mAnchors.add(this.mLeft);
        this.mAnchors.add(this.mTop);
        this.mAnchors.add(this.mRight);
        this.mAnchors.add(this.mBottom);
        this.mAnchors.add(this.mCenterX);
        this.mAnchors.add(this.mCenterY);
        this.mAnchors.add(this.mBaseline);
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public boolean isRootContainer() {
        return this instanceof ConstraintWidgetContainer && (this.mParent == null || !(this.mParent instanceof ConstraintWidgetContainer));
    }

    public boolean isInsideConstraintLayout() {
        ConstraintWidget widget = this.getParent();
        if (widget == null) {
            return false;
        }
        while (widget != null) {
            if (widget instanceof ConstraintWidgetContainer) {
                return true;
            }
            widget = widget.getParent();
        }
        return false;
    }

    public boolean hasAncestor(ConstraintWidget widget) {
        ConstraintWidget parent = this.getParent();
        if (parent == widget) {
            return true;
        }
        if (parent == widget.getParent()) {
            return false;
        }
        while (parent != null) {
            if (parent == widget) {
                return true;
            }
            if (parent == widget.getParent()) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public WidgetContainer getRootWidgetContainer() {
        ConstraintWidget root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (root instanceof WidgetContainer) {
            return (WidgetContainer)root;
        }
        return null;
    }

    public ConstraintWidget getParent() {
        return this.mParent;
    }

    public void setParent(ConstraintWidget widget) {
        this.mParent = widget;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public void setVisibility(int visibility) {
        this.mVisibility = visibility;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public String getDebugName() {
        return this.mDebugName;
    }

    public void setDebugName(String name) {
        this.mDebugName = name;
    }

    @Override
    public void setDebugSolverName(LinearSystem system, String name) {
        this.mDebugName = name;
        SolverVariable left = system.createObjectVariable(this.mLeft);
        SolverVariable top = system.createObjectVariable(this.mTop);
        SolverVariable right = system.createObjectVariable(this.mRight);
        SolverVariable bottom = system.createObjectVariable(this.mBottom);
        left.setName(name + ".left");
        top.setName(name + ".top");
        right.setName(name + ".right");
        bottom.setName(name + ".bottom");
        if (this.mBaselineDistance > 0) {
            SolverVariable baseline = system.createObjectVariable(this.mBaseline);
            baseline.setName(name + ".baseline");
        }
    }

    public boolean isAnimating() {
        if (Animator.doAnimation()) {
            return this.mAnimator.isAnimating();
        }
        return false;
    }

    public String toString() {
        return (this.mType != null ? "type: " + this.mType + " " : "") + (this.mDebugName != null ? "id: " + this.mDebugName + " " : "") + "(" + this.mX + ", " + this.mY + ") - (" + this.mWidth + " x " + this.mHeight + ")";
    }

    int getInternalDrawX() {
        return this.mDrawX;
    }

    int getInternalDrawY() {
        return this.mDrawY;
    }

    public int getInternalDrawRight() {
        return this.mDrawX + this.mDrawWidth;
    }

    public int getInternalDrawBottom() {
        return this.mDrawY + this.mDrawHeight;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public int getWidth() {
        if (this.mVisibility == 8) {
            return 0;
        }
        return this.mWidth;
    }

    public int getWrapWidth() {
        return this.mWrapWidth;
    }

    public int getHeight() {
        if (this.mVisibility == 8) {
            return 0;
        }
        return this.mHeight;
    }

    public int getWrapHeight() {
        return this.mWrapHeight;
    }

    public int getDrawX() {
        return this.mDrawX + this.mOffsetX;
    }

    public int getDrawY() {
        return this.mDrawY + this.mOffsetY;
    }

    public int getDrawWidth() {
        return this.mDrawWidth;
    }

    public int getDrawHeight() {
        return this.mDrawHeight;
    }

    public int getDrawBottom() {
        return this.getDrawY() + this.mDrawHeight;
    }

    public int getDrawRight() {
        return this.getDrawX() + this.mDrawWidth;
    }

    protected int getRootX() {
        return this.mX + this.mOffsetX;
    }

    protected int getRootY() {
        return this.mY + this.mOffsetY;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public int getLeft() {
        return this.getX();
    }

    public int getTop() {
        return this.getY();
    }

    public int getRight() {
        return this.getX() + this.mWidth;
    }

    public int getBottom() {
        return this.getY() + this.mHeight;
    }

    public float getHorizontalBiasPercent() {
        return this.mHorizontalBiasPercent;
    }

    public float getVerticalBiasPercent() {
        return this.mVerticalBiasPercent;
    }

    public boolean hasBaseline() {
        return this.mBaselineDistance > 0;
    }

    public int getBaselineDistance() {
        return this.mBaselineDistance;
    }

    public Object getCompanionWidget() {
        return this.mCompanionWidget;
    }

    public ArrayList<ConstraintAnchor> getAnchors() {
        return this.mAnchors;
    }

    public void setX(int x) {
        this.mX = x;
    }

    public void setY(int y) {
        this.mY = y;
    }

    public void setOrigin(int x, int y) {
        this.mX = x;
        this.mY = y;
    }

    public void setOffset(int x, int y) {
        this.mOffsetX = x;
        this.mOffsetY = y;
    }

    public void updateDrawPosition() {
        int left = this.mX;
        int top = this.mY;
        int right = this.mX + this.mWidth;
        int bottom = this.mY + this.mHeight;
        if (Animator.doAnimation()) {
            this.mAnimator.animate(left, top, right, bottom);
            left = this.mAnimator.getCurrentLeft();
            top = this.mAnimator.getCurrentTop();
            right = this.mAnimator.getCurrentRight();
            bottom = this.mAnimator.getCurrentBottom();
        }
        this.mDrawX = left;
        this.mDrawY = top;
        this.mDrawWidth = right - left;
        this.mDrawHeight = bottom - top;
    }

    public void forceUpdateDrawPosition() {
        int left = this.mX;
        int top = this.mY;
        int right = this.mX + this.mWidth;
        int bottom = this.mY + this.mHeight;
        this.mDrawX = left;
        this.mDrawY = top;
        this.mDrawWidth = right - left;
        this.mDrawHeight = bottom - top;
    }

    public void setDrawOrigin(int x, int y) {
        this.mDrawX = x - this.mOffsetX;
        this.mDrawY = y - this.mOffsetY;
        this.mX = this.mDrawX;
        this.mY = this.mDrawY;
    }

    public void setDrawX(int x) {
        this.mX = this.mDrawX = x - this.mOffsetX;
    }

    public void setDrawY(int y) {
        this.mY = this.mDrawY = y - this.mOffsetY;
    }

    public void setDrawWidth(int drawWidth) {
        this.mDrawWidth = drawWidth;
    }

    public void setDrawHeight(int drawHeight) {
        this.mDrawHeight = drawHeight;
    }

    public void setWidth(int w) {
        this.mWidth = w;
        if (this.mWidth < this.mMinWidth) {
            this.mWidth = this.mMinWidth;
        }
    }

    public void setHeight(int h) {
        this.mHeight = h;
        if (this.mHeight < this.mMinHeight) {
            this.mHeight = this.mMinHeight;
        }
    }

    public void setDimensionRatio(float ratio) {
        this.mDimensionRatio = ratio;
    }

    public float getDimensionRatio() {
        return this.mDimensionRatio;
    }

    public void setHorizontalBiasPercent(float horizontalBiasPercent) {
        this.mHorizontalBiasPercent = horizontalBiasPercent;
    }

    public void setVerticalBiasPercent(float verticalBiasPercent) {
        this.mVerticalBiasPercent = verticalBiasPercent;
    }

    public void setMinWidth(int w) {
        this.mMinWidth = w;
    }

    public void setMinHeight(int h) {
        this.mMinHeight = h;
    }

    public void setWrapWidth(int w) {
        this.mWrapWidth = w;
    }

    public void setWrapHeight(int h) {
        this.mWrapHeight = h;
    }

    public void setDimension(int w, int h) {
        this.mWidth = w;
        if (this.mWidth < this.mMinWidth) {
            this.mWidth = this.mMinWidth;
        }
        this.mHeight = h;
        if (this.mHeight < this.mMinHeight) {
            this.mHeight = this.mMinHeight;
        }
    }

    public void setFrame(int left, int top, int right, int bottom) {
        int w = right - left;
        int h = bottom - top;
        if (this.getHorizontalDimensionBehaviour() == DimensionBehaviour.FIXED && w < this.getWidth()) {
            w = this.getWidth();
        }
        if (this.getVerticalDimensionBehaviour() == DimensionBehaviour.FIXED && h < this.getHeight()) {
            h = this.getHeight();
        }
        this.mX = left;
        this.mY = top;
        this.setDimension(w, h);
    }

    public void setBaselineDistance(int baseline) {
        this.mBaselineDistance = baseline;
    }

    public void setCompanionWidget(Object companion) {
        this.mCompanionWidget = companion;
    }

    public void setContainerItemSkip(int skip) {
        this.mContainerItemSkip = skip >= 0 ? skip : 0;
    }

    public int getContainerItemSkip() {
        return this.mContainerItemSkip;
    }

    public void connectedTo(ConstraintWidget source) {
    }

    public void immediateConnect(ConstraintAnchor.Type startType, ConstraintWidget target, ConstraintAnchor.Type endType, int margin) {
        ConstraintAnchor startAnchor = this.getAnchor(startType);
        ConstraintAnchor endAnchor = target.getAnchor(endType);
        startAnchor.connect(endAnchor, margin, ConstraintAnchor.Strength.STRONG, 0, true);
    }

    public void connect(ConstraintAnchor from, ConstraintAnchor to, int margin, int creator) {
        this.connect(from, to, margin, ConstraintAnchor.Strength.STRONG, creator);
    }

    public void connect(ConstraintAnchor from, ConstraintAnchor to, int margin) {
        this.connect(from, to, margin, ConstraintAnchor.Strength.STRONG, 0);
    }

    public void connect(ConstraintAnchor from, ConstraintAnchor to, int margin, ConstraintAnchor.Strength strength, int creator) {
        if (from.getOwner() == this) {
            this.connect(from.getType(), to.getOwner(), to.getType(), margin, strength, creator);
        }
    }

    public void connect(ConstraintAnchor.Type constraintFrom, ConstraintWidget target, ConstraintAnchor.Type constraintTo, int margin) {
        this.connect(constraintFrom, target, constraintTo, margin, ConstraintAnchor.Strength.STRONG);
    }

    public void connect(ConstraintAnchor.Type constraintFrom, ConstraintWidget target, ConstraintAnchor.Type constraintTo) {
        this.connect(constraintFrom, target, constraintTo, 0, ConstraintAnchor.Strength.STRONG);
    }

    public void connect(ConstraintAnchor.Type constraintFrom, ConstraintWidget target, ConstraintAnchor.Type constraintTo, int margin, ConstraintAnchor.Strength strength) {
        this.connect(constraintFrom, target, constraintTo, margin, strength, 0);
    }

    public void connect(ConstraintAnchor.Type constraintFrom, ConstraintWidget target, ConstraintAnchor.Type constraintTo, int margin, ConstraintAnchor.Strength strength, int creator) {
        if (constraintFrom == ConstraintAnchor.Type.CENTER) {
            if (constraintTo == ConstraintAnchor.Type.CENTER) {
                ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
                ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
                ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
                ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
                boolean centerX = false;
                boolean centerY = false;
                if (!(left != null && left.isConnected() || right != null && right.isConnected())) {
                    this.connect(ConstraintAnchor.Type.LEFT, target, ConstraintAnchor.Type.LEFT, 0, strength, creator);
                    this.connect(ConstraintAnchor.Type.RIGHT, target, ConstraintAnchor.Type.RIGHT, 0, strength, creator);
                    centerX = true;
                }
                if (!(top != null && top.isConnected() || bottom != null && bottom.isConnected())) {
                    this.connect(ConstraintAnchor.Type.TOP, target, ConstraintAnchor.Type.TOP, 0, strength, creator);
                    this.connect(ConstraintAnchor.Type.BOTTOM, target, ConstraintAnchor.Type.BOTTOM, 0, strength, creator);
                    centerY = true;
                }
                if (centerX && centerY) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                    center.connect(target.getAnchor(ConstraintAnchor.Type.CENTER), 0, creator);
                } else if (centerX) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
                    center.connect(target.getAnchor(ConstraintAnchor.Type.CENTER_X), 0, creator);
                } else if (centerY) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
                    center.connect(target.getAnchor(ConstraintAnchor.Type.CENTER_Y), 0, creator);
                }
            } else if (constraintTo == ConstraintAnchor.Type.LEFT || constraintTo == ConstraintAnchor.Type.RIGHT) {
                this.connect(ConstraintAnchor.Type.LEFT, target, constraintTo, 0, strength, creator);
                this.connect(ConstraintAnchor.Type.RIGHT, target, constraintTo, 0, strength, creator);
                ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                center.connect(target.getAnchor(constraintTo), 0, creator);
            } else if (constraintTo == ConstraintAnchor.Type.TOP || constraintTo == ConstraintAnchor.Type.BOTTOM) {
                this.connect(ConstraintAnchor.Type.TOP, target, constraintTo, 0, strength, creator);
                this.connect(ConstraintAnchor.Type.BOTTOM, target, constraintTo, 0, strength, creator);
                ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                center.connect(target.getAnchor(constraintTo), 0, creator);
            }
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_X && (constraintTo == ConstraintAnchor.Type.LEFT || constraintTo == ConstraintAnchor.Type.RIGHT)) {
            ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
            ConstraintAnchor targetAnchor = target.getAnchor(constraintTo);
            ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
            left.connect(targetAnchor, 0, creator);
            right.connect(targetAnchor, 0, creator);
            ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
            centerX.connect(targetAnchor, 0, creator);
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_Y && (constraintTo == ConstraintAnchor.Type.TOP || constraintTo == ConstraintAnchor.Type.BOTTOM)) {
            ConstraintAnchor targetAnchor = target.getAnchor(constraintTo);
            ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
            top.connect(targetAnchor, 0, creator);
            ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
            bottom.connect(targetAnchor, 0, creator);
            ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
            centerY.connect(targetAnchor, 0, creator);
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_X && constraintTo == ConstraintAnchor.Type.CENTER_X) {
            ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
            ConstraintAnchor leftTarget = target.getAnchor(ConstraintAnchor.Type.LEFT);
            left.connect(leftTarget, 0, creator);
            ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
            ConstraintAnchor rightTarget = target.getAnchor(ConstraintAnchor.Type.RIGHT);
            right.connect(rightTarget, 0, creator);
            ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
            centerX.connect(target.getAnchor(constraintTo), 0, creator);
        } else if (constraintFrom == ConstraintAnchor.Type.CENTER_Y && constraintTo == ConstraintAnchor.Type.CENTER_Y) {
            ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
            ConstraintAnchor topTarget = target.getAnchor(ConstraintAnchor.Type.TOP);
            top.connect(topTarget, 0, creator);
            ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
            ConstraintAnchor bottomTarget = target.getAnchor(ConstraintAnchor.Type.BOTTOM);
            bottom.connect(bottomTarget, 0, creator);
            ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
            centerY.connect(target.getAnchor(constraintTo), 0, creator);
        } else {
            ConstraintAnchor toAnchor;
            ConstraintAnchor fromAnchor = this.getAnchor(constraintFrom);
            if (fromAnchor.isValidConnection(toAnchor = target.getAnchor(constraintTo))) {
                if (constraintFrom == ConstraintAnchor.Type.BASELINE) {
                    ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
                    ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
                    if (top != null) {
                        top.reset();
                    }
                    if (bottom != null) {
                        bottom.reset();
                    }
                    margin = 0;
                } else if (constraintFrom == ConstraintAnchor.Type.TOP || constraintFrom == ConstraintAnchor.Type.BOTTOM) {
                    ConstraintAnchor center;
                    ConstraintAnchor baseline = this.getAnchor(ConstraintAnchor.Type.BASELINE);
                    if (baseline != null) {
                        baseline.reset();
                    }
                    if ((center = this.getAnchor(ConstraintAnchor.Type.CENTER)).getTarget() != toAnchor) {
                        center.reset();
                    }
                    ConstraintAnchor opposite = this.getAnchor(constraintFrom).getOpposite();
                    ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
                    if (centerY.isConnected()) {
                        opposite.reset();
                        centerY.reset();
                    }
                } else if (constraintFrom == ConstraintAnchor.Type.LEFT || constraintFrom == ConstraintAnchor.Type.RIGHT) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
                    if (center.getTarget() != toAnchor) {
                        center.reset();
                    }
                    ConstraintAnchor opposite = this.getAnchor(constraintFrom).getOpposite();
                    ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
                    if (centerX.isConnected()) {
                        opposite.reset();
                        centerX.reset();
                    }
                }
                fromAnchor.connect(toAnchor, margin, strength, creator);
                toAnchor.getOwner().connectedTo(fromAnchor.getOwner());
            }
        }
    }

    public void resetAllConstraints() {
        this.resetAnchors();
        this.setVerticalBiasPercent(DEFAULT_BIAS);
        this.setHorizontalBiasPercent(DEFAULT_BIAS);
        if (this instanceof ConstraintWidgetContainer) {
            return;
        }
        if (this.getHorizontalDimensionBehaviour() == DimensionBehaviour.ANY) {
            if (this.getWidth() == this.getWrapWidth()) {
                this.setHorizontalDimensionBehaviour(DimensionBehaviour.WRAP_CONTENT);
            } else if (this.getWidth() > this.getMinWidth()) {
                this.setHorizontalDimensionBehaviour(DimensionBehaviour.FIXED);
            }
        }
        if (this.getVerticalDimensionBehaviour() == DimensionBehaviour.ANY) {
            if (this.getHeight() == this.getWrapHeight()) {
                this.setVerticalDimensionBehaviour(DimensionBehaviour.WRAP_CONTENT);
            } else if (this.getHeight() > this.getMinHeight()) {
                this.setVerticalDimensionBehaviour(DimensionBehaviour.FIXED);
            }
        }
    }

    public void resetAnchor(ConstraintAnchor anchor) {
        ConstraintWidgetContainer parent;
        if (this.getParent() != null && this.getParent() instanceof ConstraintWidgetContainer && (parent = (ConstraintWidgetContainer)this.getParent()).handlesInternalConstraints()) {
            return;
        }
        ConstraintAnchor left = this.getAnchor(ConstraintAnchor.Type.LEFT);
        ConstraintAnchor right = this.getAnchor(ConstraintAnchor.Type.RIGHT);
        ConstraintAnchor top = this.getAnchor(ConstraintAnchor.Type.TOP);
        ConstraintAnchor bottom = this.getAnchor(ConstraintAnchor.Type.BOTTOM);
        ConstraintAnchor center = this.getAnchor(ConstraintAnchor.Type.CENTER);
        ConstraintAnchor centerX = this.getAnchor(ConstraintAnchor.Type.CENTER_X);
        ConstraintAnchor centerY = this.getAnchor(ConstraintAnchor.Type.CENTER_Y);
        if (anchor == center) {
            if (left.isConnected() && right.isConnected() && left.getTarget() == right.getTarget()) {
                left.reset();
                right.reset();
            }
            if (top.isConnected() && bottom.isConnected() && top.getTarget() == bottom.getTarget()) {
                top.reset();
                bottom.reset();
            }
            this.mHorizontalBiasPercent = 0.5f;
            this.mVerticalBiasPercent = 0.5f;
        } else if (anchor == centerX) {
            if (left.isConnected() && right.isConnected() && left.getTarget().getOwner() == right.getTarget().getOwner()) {
                left.reset();
                right.reset();
            }
            this.mHorizontalBiasPercent = 0.5f;
        } else if (anchor == centerY) {
            if (top.isConnected() && bottom.isConnected() && top.getTarget().getOwner() == bottom.getTarget().getOwner()) {
                top.reset();
                bottom.reset();
            }
            this.mVerticalBiasPercent = 0.5f;
        } else if (anchor == left || anchor == right) {
            if (left.isConnected() && left.getTarget() == right.getTarget()) {
                center.reset();
            }
        } else if ((anchor == top || anchor == bottom) && top.isConnected() && top.getTarget() == bottom.getTarget()) {
            center.reset();
        }
        anchor.reset();
    }

    public void resetAnchors() {
        ConstraintWidgetContainer parentContainer;
        ConstraintWidget parent = this.getParent();
        if (parent != null && parent instanceof ConstraintWidgetContainer && (parentContainer = (ConstraintWidgetContainer)this.getParent()).handlesInternalConstraints()) {
            return;
        }
        int mAnchorsSize = this.mAnchors.size();
        for (int i = 0; i < mAnchorsSize; ++i) {
            ConstraintAnchor anchor = this.mAnchors.get(i);
            anchor.reset();
        }
    }

    public void resetAnchors(int connectionCreator) {
        ConstraintWidgetContainer parentContainer;
        ConstraintWidget parent = this.getParent();
        if (parent != null && parent instanceof ConstraintWidgetContainer && (parentContainer = (ConstraintWidgetContainer)this.getParent()).handlesInternalConstraints()) {
            return;
        }
        int mAnchorsSize = this.mAnchors.size();
        for (int i = 0; i < mAnchorsSize; ++i) {
            ConstraintAnchor anchor = this.mAnchors.get(i);
            if (connectionCreator != anchor.getConnectionCreator()) continue;
            if (anchor.isVerticalAnchor()) {
                this.setVerticalBiasPercent(DEFAULT_BIAS);
            } else {
                this.setHorizontalBiasPercent(DEFAULT_BIAS);
            }
            anchor.reset();
        }
    }

    public void disconnectWidget(ConstraintWidget widget) {
        ArrayList<ConstraintAnchor> anchors = this.getAnchors();
        int anchorsSize = anchors.size();
        for (int i = 0; i < anchorsSize; ++i) {
            ConstraintAnchor anchor = anchors.get(i);
            if (!anchor.isConnected() || anchor.getTarget().getOwner() != widget) continue;
            anchor.reset();
        }
    }

    public void disconnectUnlockedWidget(ConstraintWidget widget) {
        ArrayList<ConstraintAnchor> anchors = this.getAnchors();
        int anchorsSize = anchors.size();
        for (int i = 0; i < anchorsSize; ++i) {
            ConstraintAnchor anchor = anchors.get(i);
            if (!anchor.isConnected() || anchor.getTarget().getOwner() != widget || anchor.getConnectionCreator() != 2) continue;
            anchor.reset();
        }
    }

    public ConstraintAnchor getAnchor(ConstraintAnchor.Type anchorType) {
        switch (anchorType) {
            case LEFT: {
                return this.mLeft;
            }
            case TOP: {
                return this.mTop;
            }
            case RIGHT: {
                return this.mRight;
            }
            case BOTTOM: {
                return this.mBottom;
            }
            case BASELINE: {
                return this.mBaseline;
            }
            case CENTER_X: {
                return this.mCenterX;
            }
            case CENTER_Y: {
                return this.mCenterY;
            }
            case CENTER: {
                return this.mCenter;
            }
        }
        return null;
    }

    public DimensionBehaviour getHorizontalDimensionBehaviour() {
        return this.mHorizontalDimensionBehaviour;
    }

    public DimensionBehaviour getVerticalDimensionBehaviour() {
        return this.mVerticalDimensionBehaviour;
    }

    public void setHorizontalDimensionBehaviour(DimensionBehaviour behaviour) {
        this.mHorizontalDimensionBehaviour = behaviour;
        if (this.mHorizontalDimensionBehaviour == DimensionBehaviour.WRAP_CONTENT) {
            this.setWidth(this.mWrapWidth);
        }
    }

    public void setVerticalDimensionBehaviour(DimensionBehaviour behaviour) {
        this.mVerticalDimensionBehaviour = behaviour;
        if (this.mVerticalDimensionBehaviour == DimensionBehaviour.WRAP_CONTENT) {
            this.setHeight(this.mWrapHeight);
        }
    }

    public void addToSolver(LinearSystem system) {
        this.addToSolver(system, Integer.MAX_VALUE);
    }

    @Override
    public void addToSolver(LinearSystem system, int group) {
        boolean wrapContent;
        boolean verticalDimensionLocked;
        int height;
        int width;
        SolverVariable left = null;
        SolverVariable right = null;
        SolverVariable top = null;
        SolverVariable bottom = null;
        SolverVariable baseline = null;
        if (group == Integer.MAX_VALUE || this.mLeft.mGroup == group) {
            left = system.createObjectVariable(this.mLeft);
        }
        if (group == Integer.MAX_VALUE || this.mRight.mGroup == group) {
            right = system.createObjectVariable(this.mRight);
        }
        if (group == Integer.MAX_VALUE || this.mTop.mGroup == group) {
            top = system.createObjectVariable(this.mTop);
        }
        if (group == Integer.MAX_VALUE || this.mBottom.mGroup == group) {
            bottom = system.createObjectVariable(this.mBottom);
        }
        if (group == Integer.MAX_VALUE || this.mBaseline.mGroup == group) {
            baseline = system.createObjectVariable(this.mBaseline);
        }
        if (this.mParent != null) {
            ArrayRow row;
            if (this.mParent.getHorizontalDimensionBehaviour() == DimensionBehaviour.WRAP_CONTENT) {
                if (this.mLeft.mTarget == null || this.mLeft.mTarget.mOwner != this.mParent) {
                    SolverVariable parentLeft = system.createObjectVariable(this.mParent.mLeft);
                    row = system.createRow();
                    row.createRowGreaterThan(left, parentLeft, system.createSlackVariable(), 0);
                    system.addConstraint(row);
                } else if (this.mLeft.mTarget != null && this.mLeft.mTarget.mOwner == this.mParent) {
                    this.mLeft.setConnectionType(ConstraintAnchor.ConnectionType.STRICT);
                }
                if (this.mRight.mTarget == null || this.mRight.mTarget.mOwner != this.mParent) {
                    SolverVariable parentRight = system.createObjectVariable(this.mParent.mRight);
                    row = system.createRow();
                    row.createRowGreaterThan(parentRight, right, system.createSlackVariable(), 0);
                    system.addConstraint(row);
                } else if (this.mRight.mTarget != null && this.mRight.mTarget.mOwner == this.mParent) {
                    this.mRight.setConnectionType(ConstraintAnchor.ConnectionType.STRICT);
                }
            }
            if (this.mParent.getVerticalDimensionBehaviour() == DimensionBehaviour.WRAP_CONTENT) {
                if (this.mTop.mTarget == null || this.mTop.mTarget.mOwner != this.mParent) {
                    SolverVariable parentTop = system.createObjectVariable(this.mParent.mTop);
                    row = system.createRow();
                    row.createRowGreaterThan(top, parentTop, system.createSlackVariable(), 0);
                    system.addConstraint(row);
                } else if (this.mTop.mTarget != null && this.mTop.mTarget.mOwner == this.mParent) {
                    this.mTop.setConnectionType(ConstraintAnchor.ConnectionType.STRICT);
                }
                if (this.mBottom.mTarget == null || this.mBottom.mTarget.mOwner != this.mParent) {
                    SolverVariable parentBottom = system.createObjectVariable(this.getParent().mBottom);
                    row = system.createRow();
                    row.createRowGreaterThan(parentBottom, bottom, system.createSlackVariable(), 0);
                    system.addConstraint(row);
                } else if (this.mBottom.mTarget != null && this.mBottom.mTarget.mOwner == this.mParent) {
                    this.mBottom.setConnectionType(ConstraintAnchor.ConnectionType.STRICT);
                }
            }
        }
        if ((width = this.mWidth) < this.mMinWidth) {
            width = this.mMinWidth;
        }
        if ((height = this.mHeight) < this.mMinHeight) {
            height = this.mMinHeight;
        }
        boolean horizontalDimensionLocked = this.mHorizontalDimensionBehaviour != DimensionBehaviour.ANY;
        boolean bl = verticalDimensionLocked = this.mVerticalDimensionBehaviour != DimensionBehaviour.ANY;
        if (!(horizontalDimensionLocked || this.mLeft == null || this.mRight == null || this.mLeft.mTarget != null && this.mRight.mTarget != null)) {
            horizontalDimensionLocked = true;
        }
        if (!(verticalDimensionLocked || this.mTop == null || this.mBottom == null || this.mTop.mTarget != null && this.mBottom.mTarget != null || this.mBaselineDistance != 0 && (this.mBaseline == null || this.mTop.mTarget != null && this.mBaseline.mTarget != null))) {
            verticalDimensionLocked = true;
        }
        boolean useRatio = false;
        if (this.mDimensionRatio > 0.0f) {
            if (!horizontalDimensionLocked && !verticalDimensionLocked) {
                useRatio = true;
                ArrayRow row = system.createRow();
                if (group == Integer.MAX_VALUE || this.mLeft.mGroup == group && this.mRight.mGroup == group) {
                    system.addConstraint(row.createRowDimensionRatio(right, left, bottom, top, this.mDimensionRatio));
                }
            } else if (!horizontalDimensionLocked && verticalDimensionLocked) {
                width = (int)(this.mDimensionRatio * (float)this.mHeight);
                horizontalDimensionLocked = true;
            } else if (horizontalDimensionLocked && !verticalDimensionLocked) {
                height = (int)(this.mDimensionRatio * (float)this.mWidth);
                verticalDimensionLocked = true;
            }
        }
        boolean bl2 = wrapContent = this.mHorizontalDimensionBehaviour == DimensionBehaviour.WRAP_CONTENT && this instanceof ConstraintWidgetContainer;
        if (group == Integer.MAX_VALUE || this.mLeft.mGroup == group && this.mRight.mGroup == group) {
            this.applyConstraints(system, wrapContent, horizontalDimensionLocked, this.mLeft, this.mRight, this.mX, this.mX + width, width, this.mHorizontalBiasPercent, useRatio);
        }
        boolean bl3 = wrapContent = this.mVerticalDimensionBehaviour == DimensionBehaviour.WRAP_CONTENT && this instanceof ConstraintWidgetContainer;
        if (this.mBaselineDistance > 0) {
            ConstraintAnchor end = this.mBottom;
            if (group == Integer.MAX_VALUE || this.mBottom.mGroup == group && this.mBaseline.mGroup == group) {
                system.addConstraint(EquationCreation.createRowEquals(system, bottom, baseline, height - this.getBaselineDistance(), false));
            }
            if (this.mBaseline.mTarget != null) {
                height = this.mBaselineDistance;
                end = this.mBaseline;
            }
            if (group == Integer.MAX_VALUE || this.mTop.mGroup == group && end.mGroup == group) {
                this.applyConstraints(system, wrapContent, verticalDimensionLocked, this.mTop, end, this.mY, this.mY + height, height, this.mVerticalBiasPercent, useRatio);
            }
        } else if (group == Integer.MAX_VALUE || this.mTop.mGroup == group && this.mBottom.mGroup == group) {
            this.applyConstraints(system, wrapContent, verticalDimensionLocked, this.mTop, this.mBottom, this.mY, this.mY + height, height, this.mVerticalBiasPercent, useRatio);
        }
    }

    private void applyConstraints(LinearSystem system, boolean wrapContent, boolean dimensionLocked, ConstraintAnchor beginAnchor, ConstraintAnchor endAnchor, int beginPosition, int endPosition, int dimension, float bias, boolean useRatio) {
        SolverVariable begin = system.createObjectVariable(beginAnchor);
        SolverVariable end = system.createObjectVariable(endAnchor);
        SolverVariable beginTarget = system.createObjectVariable(beginAnchor.getTarget());
        SolverVariable endTarget = system.createObjectVariable(endAnchor.getTarget());
        if (this.mVisibility == 8) {
            dimension = 0;
        }
        if (beginTarget == null && endTarget == null) {
            system.addConstraint(system.createRow().createRowEquals(begin, beginPosition));
            if (wrapContent) {
                system.addConstraint(EquationCreation.createRowEquals(system, end, begin, 0, true));
            } else if (dimensionLocked) {
                system.addConstraint(EquationCreation.createRowEquals(system, end, begin, dimension, false));
            } else {
                system.addConstraint(system.createRow().createRowEquals(end, endPosition));
            }
        } else if (beginTarget != null && endTarget == null) {
            system.addConstraint(system.createRow().createRowEquals(begin, beginTarget, beginAnchor.mMargin));
            if (wrapContent) {
                system.addConstraint(EquationCreation.createRowEquals(system, end, begin, 0, true));
            } else if (dimensionLocked) {
                system.addConstraint(system.createRow().createRowEquals(end, begin, dimension));
            } else {
                system.addConstraint(system.createRow().createRowEquals(end, endPosition));
            }
        } else if (beginTarget == null && endTarget != null) {
            system.addConstraint(system.createRow().createRowEquals(end, endTarget, -1 * endAnchor.mMargin));
            if (wrapContent) {
                system.addConstraint(EquationCreation.createRowEquals(system, end, begin, 0, true));
            } else if (dimensionLocked) {
                system.addConstraint(system.createRow().createRowEquals(end, begin, dimension));
            } else {
                system.addConstraint(system.createRow().createRowEquals(begin, beginPosition));
            }
        } else if (dimensionLocked) {
            if (wrapContent) {
                system.addConstraint(EquationCreation.createRowEquals(system, end, begin, 0, true));
            } else {
                system.addConstraint(system.createRow().createRowEquals(end, begin, dimension));
            }
            if (beginAnchor.getStrength() != endAnchor.getStrength()) {
                if (beginAnchor.getStrength() == ConstraintAnchor.Strength.STRONG) {
                    system.addConstraint(system.createRow().createRowEquals(begin, beginTarget, beginAnchor.mMargin));
                    SolverVariable slack = system.createSlackVariable();
                    ArrayRow row = system.createRow();
                    row.createRowLowerThan(end, endTarget, slack, -1 * endAnchor.mMargin);
                    system.addConstraint(row);
                } else {
                    SolverVariable slack = system.createSlackVariable();
                    ArrayRow row = system.createRow();
                    row.createRowGreaterThan(begin, beginTarget, slack, beginAnchor.mMargin);
                    system.addConstraint(row);
                    system.addConstraint(system.createRow().createRowEquals(end, endTarget, -1 * endAnchor.mMargin));
                }
            } else if (beginTarget == endTarget) {
                system.addConstraint(EquationCreation.createRowCentering(system, begin, beginTarget, 0, 0.5f, endTarget, end, 0, true));
            } else {
                boolean useBidirectionalError = beginAnchor.getConnectionType() != ConstraintAnchor.ConnectionType.STRICT;
                system.addConstraint(EquationCreation.createRowGreaterThan(system, begin, beginTarget, beginAnchor.getMargin(), useBidirectionalError));
                useBidirectionalError = endAnchor.getConnectionType() != ConstraintAnchor.ConnectionType.STRICT;
                system.addConstraint(EquationCreation.createRowLowerThan(system, end, endTarget, -1 * endAnchor.getMargin(), useBidirectionalError));
                system.addConstraint(EquationCreation.createRowCentering(system, begin, beginTarget, beginAnchor.getMargin(), bias, endTarget, end, endAnchor.getMargin(), false));
            }
        } else if (useRatio) {
            system.addConstraint(EquationCreation.createRowEquals(system, begin, beginTarget, beginAnchor.getMargin(), true));
            system.addConstraint(EquationCreation.createRowEquals(system, end, endTarget, -1 * endAnchor.getMargin(), true));
            system.addConstraint(EquationCreation.createRowCentering(system, begin, beginTarget, 0, 0.5f, endTarget, end, 0, true));
        } else {
            system.addConstraint(system.createRow().createRowEquals(begin, beginTarget, beginAnchor.mMargin));
            system.addConstraint(system.createRow().createRowEquals(end, endTarget, -1 * endAnchor.mMargin));
        }
    }

    @Override
    public void updateFromSolver(LinearSystem system, int group) {
        if (group == Integer.MAX_VALUE) {
            int left = system.getObjectVariableValue(this.mLeft);
            int top = system.getObjectVariableValue(this.mTop);
            int right = system.getObjectVariableValue(this.mRight);
            int bottom = system.getObjectVariableValue(this.mBottom);
            this.setFrame(left, top, right, bottom);
        } else if (group == -2) {
            this.setFrame(this.mSolverLeft, this.mSolverTop, this.mSolverRight, this.mSolverBottom);
        } else {
            if (this.mLeft.mGroup == group) {
                this.mSolverLeft = system.getObjectVariableValue(this.mLeft);
            }
            if (this.mTop.mGroup == group) {
                this.mSolverTop = system.getObjectVariableValue(this.mTop);
            }
            if (this.mRight.mGroup == group) {
                this.mSolverRight = system.getObjectVariableValue(this.mRight);
            }
            if (this.mBottom.mGroup == group) {
                this.mSolverBottom = system.getObjectVariableValue(this.mBottom);
            }
        }
    }

    public void updateFromSolver(LinearSystem system) {
        this.updateFromSolver(system, Integer.MAX_VALUE);
    }

    public static enum DimensionBehaviour {
        FIXED,
        WRAP_CONTENT,
        ANY;

    }

    public static enum ContentAlignment {
        BEGIN,
        MIDDLE,
        END,
        TOP,
        VERTICAL_MIDDLE,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

