/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ElementColorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.IntFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFxColorProvider
implements ElementColorProvider {
    private static final String COLOR = "color";
    private static final String RGB = "rgb";
    private static final String GRAY = "gray";
    private static final String GRAY_RGB = "grayRgb";
    private static final String HSB = "hsb";
    private static final Set<String> FACTORY_METHODS = ContainerUtil.immutableSet((Object[])new String[]{"color", "rgb", "gray", "grayRgb", "hsb"});

    public Color getColorFrom(@NotNull PsiElement element) {
        PsiMethod method;
        PsiElement resolved;
        PsiMethodCallExpression methodCall;
        PsiReferenceExpression methodExpression;
        String methodName;
        PsiExpression[] args;
        PsiExpressionList argumentList;
        PsiNewExpression newExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getColorFrom"));
        }
        if (element instanceof PsiNewExpression && JavaFxColorProvider.isColorClass(PsiTypesUtil.getPsiClass((PsiType)(newExpression = (PsiNewExpression)element).getType())) && (argumentList = newExpression.getArgumentList()) != null && (args = argumentList.getExpressions()).length == 4) {
            Object[] values = JavaFxColorProvider.getArgumentValues(args);
            return JavaFxColorProvider.getScaledRgbColor(values[0], values[1], values[2], values[3]);
        }
        if (element instanceof PsiMethodCallExpression && FACTORY_METHODS.contains(methodName = (methodExpression = (methodCall = (PsiMethodCallExpression)element).getMethodExpression()).getReferenceName()) && (resolved = methodExpression.resolve()) instanceof PsiMethod && (method = (PsiMethod)resolved).hasModifierProperty("static") && JavaFxColorProvider.isColorClass(method.getContainingClass())) {
            return JavaFxColorProvider.getColor(methodName, methodCall.getArgumentList());
        }
        return null;
    }

    private static boolean isColorClass(@Nullable PsiClass aClass) {
        return aClass != null && "javafx.scene.paint.Color".equals(aClass.getQualifiedName());
    }

    @Nullable
    private static Color getColor(@Nullable String methodName, @NotNull PsiExpressionList argumentList) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getColor"));
        }
        Object[] values = JavaFxColorProvider.getArgumentValues(argumentList.getExpressions());
        if (COLOR.equals(methodName)) {
            switch (values.length) {
                case 4: {
                    return JavaFxColorProvider.getScaledRgbColor(values[0], values[1], values[2], values[3]);
                }
                case 3: {
                    return JavaFxColorProvider.getScaledRgbColor(values[0], values[1], values[2], 1.0);
                }
            }
        } else if (RGB.equals(methodName)) {
            switch (values.length) {
                case 4: {
                    return JavaFxColorProvider.getRgbColor(values[0], values[1], values[2], values[3]);
                }
                case 3: {
                    return JavaFxColorProvider.getRgbColor(values[0], values[1], values[2], 1.0);
                }
            }
        } else if (GRAY.equals(methodName)) {
            switch (values.length) {
                case 2: {
                    return JavaFxColorProvider.getScaledRgbColor(values[0], values[0], values[0], values[1]);
                }
                case 1: {
                    return JavaFxColorProvider.getScaledRgbColor(values[0], values[0], values[0], 1.0);
                }
            }
        } else if (GRAY_RGB.equals(methodName)) {
            switch (values.length) {
                case 2: {
                    return JavaFxColorProvider.getRgbColor(values[0], values[0], values[0], values[1]);
                }
                case 1: {
                    return JavaFxColorProvider.getRgbColor(values[0], values[0], values[0], 1.0);
                }
            }
        } else if (HSB.equals(methodName)) {
            switch (values.length) {
                case 4: {
                    return JavaFxColorProvider.getHsbColor(values[0], values[1], values[2], values[3]);
                }
                case 3: {
                    return JavaFxColorProvider.getHsbColor(values[0], values[1], values[2], 1.0);
                }
            }
        }
        return null;
    }

    @NotNull
    private static Object[] getArgumentValues(@NotNull PsiExpression[] argumentExpressions) {
        if (argumentExpressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentExpressions", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getArgumentValues"));
        }
        Object[] objectArray = ContainerUtil.map((Object[])argumentExpressions, expression -> JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)expression, (boolean)true), (Object[])ArrayUtil.EMPTY_OBJECT_ARRAY);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getArgumentValues"));
        }
        return objectArray;
    }

    @Nullable
    private static Color getScaledRgbColor(@Nullable Object redValue, @Nullable Object greenValue, @Nullable Object blueValue, @Nullable Object alphaValue) {
        Integer red = JavaFxColorProvider.getScaledComponent(redValue);
        Integer green = JavaFxColorProvider.getScaledComponent(greenValue);
        Integer blue = JavaFxColorProvider.getScaledComponent(blueValue);
        Integer alpha = JavaFxColorProvider.getScaledComponent(alphaValue);
        if (red != null && green != null && blue != null && alpha != null) {
            return new Color(red, green, blue, alpha);
        }
        return null;
    }

    @Nullable
    private static Color getRgbColor(@Nullable Object redValue, @Nullable Object greenValue, @Nullable Object blueValue, @Nullable Object alphaValue) {
        Integer red = JavaFxColorProvider.getComponent(redValue);
        Integer green = JavaFxColorProvider.getComponent(greenValue);
        Integer blue = JavaFxColorProvider.getComponent(blueValue);
        Integer alpha = JavaFxColorProvider.getScaledComponent(alphaValue);
        if (red != null && green != null && blue != null && alpha != null) {
            return new Color(red, green, blue, alpha);
        }
        return null;
    }

    private static Integer getComponent(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return null;
    }

    private static Integer getScaledComponent(Object value) {
        if (value instanceof Number) {
            double doubleValue = ((Number)value).doubleValue();
            return (int)(doubleValue * 255.0 + 0.5);
        }
        return null;
    }

    private static Float getHsbComponent(Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return null;
    }

    public void setColorTo(@NotNull PsiElement element, @NotNull Color color) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "setColorTo"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "setColorTo"));
        }
        Runnable command = null;
        if (element instanceof PsiNewExpression) {
            PsiNewExpression expr = (PsiNewExpression)element;
            PsiExpressionList argumentList = expr.getArgumentList();
            assert (argumentList != null);
            command = () -> {
                if (color == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "lambda$setColorTo$1"));
                }
                JavaFxColorProvider.replaceConstructorArgs(color, argumentList);
            };
        }
        if (element instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)element;
            PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (COLOR.equals(methodName) || GRAY.equals(methodName)) {
                command = () -> {
                    if (color == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "lambda$setColorTo$2"));
                    }
                    JavaFxColorProvider.replaceColor(methodCall, JavaFxColorProvider.getScaledRgbCallText(color));
                };
            } else if (RGB.equals(methodName) || GRAY_RGB.equals(methodName)) {
                command = () -> {
                    if (color == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "lambda$setColorTo$3"));
                    }
                    JavaFxColorProvider.replaceColor(methodCall, JavaFxColorProvider.getRgbCallText(color));
                };
            } else if (HSB.equals(methodName)) {
                command = () -> {
                    if (color == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "lambda$setColorTo$4"));
                    }
                    JavaFxColorProvider.replaceColor(methodCall, JavaFxColorProvider.getHsbCallText(color));
                };
            }
        }
        if (command != null) {
            Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(element.getContainingFile());
            CommandProcessor.getInstance().executeCommand(element.getProject(), command, IdeBundle.message((String)"change.color.command.text", (Object[])new Object[0]), null, document);
        }
    }

    private static void replaceConstructorArgs(@NotNull Color color, PsiExpressionList argumentList) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "replaceConstructorArgs"));
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)argumentList.getProject());
        String text = "javafx.scene.paint.Color(" + JavaFxColorProvider.formatScaledComponent(color.getRed()) + "," + JavaFxColorProvider.formatScaledComponent(color.getGreen()) + "," + JavaFxColorProvider.formatScaledComponent(color.getBlue()) + "," + JavaFxColorProvider.formatScaledComponent(color.getAlpha()) + ")";
        PsiMethodCallExpression newCall = (PsiMethodCallExpression)factory.createExpressionFromText(text, (PsiElement)argumentList);
        argumentList.replace((PsiElement)newCall.getArgumentList());
    }

    private static void replaceColor(@NotNull PsiMethodCallExpression methodCall, @NotNull String callText) {
        if (methodCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCall", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "replaceColor"));
        }
        if (callText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callText", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "replaceColor"));
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)methodCall.getProject());
        PsiMethodCallExpression newCall = (PsiMethodCallExpression)factory.createExpressionFromText(callText, (PsiElement)methodCall);
        methodCall.getArgumentList().replace((PsiElement)newCall.getArgumentList());
        PsiElement nameElement = methodCall.getMethodExpression().getReferenceNameElement();
        assert (nameElement != null);
        PsiElement newNameElement = newCall.getMethodExpression().getReferenceNameElement();
        assert (newNameElement != null);
        nameElement.replace(newNameElement);
    }

    private static Color getHsbColor(Object hValue, Object sValue, Object bValue, Object alphaValue) {
        Float h = JavaFxColorProvider.getHsbComponent(hValue);
        Float s = JavaFxColorProvider.getHsbComponent(sValue);
        Float b = JavaFxColorProvider.getHsbComponent(bValue);
        Integer alpha = JavaFxColorProvider.getScaledComponent(alphaValue);
        if (h != null && s != null && b != null && alpha != null) {
            Color hsbColor = Color.getHSBColor(h.floatValue() / 360.0f, s.floatValue(), b.floatValue());
            return alpha == 255 ? hsbColor : new Color(hsbColor.getRed(), hsbColor.getGreen(), hsbColor.getBlue(), alpha);
        }
        return null;
    }

    @NotNull
    private static String getScaledRgbCallText(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getScaledRgbCallText"));
        }
        String string = JavaFxColorProvider.getCallText(color, COLOR, GRAY, JavaFxColorProvider::formatScaledComponent);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getScaledRgbCallText"));
        }
        return string;
    }

    @NotNull
    private static String getRgbCallText(@NotNull Color color) {
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getRgbCallText"));
        }
        String string = JavaFxColorProvider.getCallText(color, RGB, GRAY_RGB, String::valueOf);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getRgbCallText"));
        }
        return string;
    }

    @NotNull
    private static String getCallText(@NotNull Color color, String colorMethodName, String grayMethodName, IntFunction<String> formatter) {
        String methodName;
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COLOR, "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getCallText"));
        }
        StringJoiner args = new StringJoiner(",", "(", ")");
        if (color.getRed() == color.getGreen() && color.getRed() == color.getBlue()) {
            methodName = grayMethodName;
            args.add(formatter.apply(color.getRed()));
        } else {
            methodName = colorMethodName;
            args.add(formatter.apply(color.getRed()));
            args.add(formatter.apply(color.getGreen()));
            args.add(formatter.apply(color.getBlue()));
        }
        if (color.getAlpha() != 255) {
            args.add(JavaFxColorProvider.formatScaledComponent(color.getAlpha()));
        }
        String string = methodName + args;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "getCallText"));
        }
        return string;
    }

    @NotNull
    private static String formatScaledComponent(int colorComponent) {
        DecimalFormat df = new DecimalFormat("#.####");
        String string = df.format((double)colorComponent / 255.0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxColorProvider", "formatScaledComponent"));
        }
        return string;
    }

    private static String getHsbCallText(Color color) {
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        DecimalFormat df = new DecimalFormat("#.####");
        StringJoiner args = new StringJoiner(",", "(", ")");
        args.add(df.format(hsb[0] * 360.0f));
        args.add(df.format(hsb[1]));
        args.add(df.format(hsb[2]));
        if (color.getAlpha() != 255) {
            args.add(JavaFxColorProvider.formatScaledComponent(color.getAlpha()));
        }
        return HSB + args;
    }
}

