/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.IntelliJPlatformProduct;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;
import org.jetbrains.idea.devkit.run.IdeaLicenseHelper;
import org.jetbrains.idea.devkit.run.PluginRunConfigurationEditor;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class PluginRunConfiguration
extends RunConfigurationBase
implements ModuleRunConfiguration {
    private static final String IDEA_LOG = "idea.log";
    private Module myModule;
    private String myModuleName;
    public String VM_PARAMETERS;
    public String PROGRAM_PARAMETERS;
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String ALTERNATIVE_PATH_ELEMENT = "alternative-path";
    @NonNls
    private static final String PATH = "path";
    @NonNls
    private static final String ALTERNATIVE_PATH_ENABLED_ATTR = "alternative-path-enabled";
    private String ALTERNATIVE_JRE_PATH = null;
    private boolean ALTERNATIVE_JRE_PATH_ENABLED = false;

    public PluginRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.addPredefinedLogFile(new PredefinedLogFile(IDEA_LOG, true));
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        if (IDEA_LOG.equals(predefinedLogFile.getId())) {
            String sandboxHome;
            Sdk ideaJdk;
            Module module = this.getModule();
            Sdk sdk = ideaJdk = module != null ? IdeaJdk.findIdeaJdk(ModuleRootManager.getInstance((Module)module).getSdk()) : null;
            if (ideaJdk != null && (sandboxHome = ((Sandbox)ideaJdk.getSdkAdditionalData()).getSandboxHome()) != null) {
                return new LogFileOptions(IDEA_LOG, sandboxHome + "/system/log/" + IDEA_LOG, predefinedLogFile.isEnabled(), true, false);
            }
        }
        return super.getOptionsForPredefinedLogFile(predefinedLogFile);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new PluginRunConfigurationEditor(this));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getState"));
        }
        final Module module = this.getModule();
        if (module == null) {
            throw new ExecutionException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        Sdk jdk = rootManager.getSdk();
        if (jdk == null) {
            throw CantRunException.noJdkForModule((Module)module);
        }
        final Sdk ideaJdk = IdeaJdk.findIdeaJdk(jdk);
        if (ideaJdk == null) {
            throw new ExecutionException(DevKitBundle.message("sdk.type.incorrect.common", new Object[0]));
        }
        String sandboxHome = ((Sandbox)ideaJdk.getSdkAdditionalData()).getSandboxHome();
        if (sandboxHome == null) {
            throw new ExecutionException(DevKitBundle.message("sandbox.no.configured", new Object[0]));
        }
        try {
            sandboxHome = new File(sandboxHome).getCanonicalPath();
        }
        catch (IOException e) {
            throw new ExecutionException(DevKitBundle.message("sandbox.no.configured", new Object[0]));
        }
        final String canonicalSandbox = sandboxHome;
        IdeaLicenseHelper.copyIDEALicense(sandboxHome);
        JavaCommandLineState state = new JavaCommandLineState(env){

            protected JavaParameters createJavaParameters() throws ExecutionException {
                VirtualFile[] prefix;
                String buildNumber;
                String id;
                String ideaJdkHome;
                boolean fromIdeaProject;
                JavaParameters params = new JavaParameters();
                ParametersList vm = params.getVMParametersList();
                PluginRunConfiguration.fillParameterList(vm, PluginRunConfiguration.this.VM_PARAMETERS);
                PluginRunConfiguration.fillParameterList(params.getProgramParametersList(), PluginRunConfiguration.this.PROGRAM_PARAMETERS);
                Sdk usedIdeaJdk = ideaJdk;
                String alternativeIdePath = PluginRunConfiguration.this.getAlternativeJrePath();
                if (PluginRunConfiguration.this.isAlternativeJreEnabled() && !StringUtil.isEmptyOrSpaces((String)alternativeIdePath)) {
                    Sdk configuredJdk = ProjectJdkTable.getInstance().findJdk(alternativeIdePath);
                    if (configuredJdk != null) {
                        usedIdeaJdk = configuredJdk;
                    } else {
                        try {
                            usedIdeaJdk = (Sdk)usedIdeaJdk.clone();
                        }
                        catch (CloneNotSupportedException e) {
                            throw new ExecutionException(e.getMessage());
                        }
                        SdkModificator sdkToSetUp = usedIdeaJdk.getSdkModificator();
                        sdkToSetUp.setHomePath(alternativeIdePath);
                        sdkToSetUp.commitChanges();
                    }
                }
                if (!(fromIdeaProject = IdeaJdk.isFromIDEAProject(ideaJdkHome = usedIdeaJdk.getHomePath()))) {
                    String bootPath = "/lib/boot.jar";
                    vm.add("-Xbootclasspath/a:" + ideaJdkHome + FileUtil.toSystemDependentName((String)bootPath));
                }
                vm.defineProperty("idea.config.path", canonicalSandbox + File.separator + "config");
                vm.defineProperty("idea.system.path", canonicalSandbox + File.separator + "system");
                vm.defineProperty("idea.plugins.path", canonicalSandbox + File.separator + "plugins");
                vm.defineProperty("idea.classpath.index.enabled", "false");
                if (!vm.hasProperty("idea.required.plugins.id") && PluginModuleType.isOfType(module) && (id = DescriptorUtil.getPluginId(module)) != null) {
                    vm.defineProperty("idea.required.plugins.id", id);
                }
                if (SystemInfo.isMac) {
                    vm.defineProperty("idea.smooth.progress", "false");
                    vm.defineProperty("apple.laf.useScreenMenuBar", "true");
                    vm.defineProperty("apple.awt.fileDialogForDirectories", "true");
                }
                if (SystemInfo.isXWindow && (PluginRunConfiguration.this.VM_PARAMETERS == null || !PluginRunConfiguration.this.VM_PARAMETERS.contains("-Dsun.awt.disablegrab"))) {
                    vm.defineProperty("sun.awt.disablegrab", "true");
                }
                if (!vm.hasProperty("idea.platform.prefix") && (buildNumber = IdeaJdk.getBuildNumber(ideaJdkHome)) != null && (prefix = IntelliJPlatformProduct.fromBuildNumber(buildNumber).getPlatformPrefix()) != null) {
                    vm.defineProperty("idea.platform.prefix", (String)prefix);
                }
                params.setWorkingDirectory(ideaJdkHome + File.separator + "bin" + File.separator);
                params.setJdk(usedIdeaJdk);
                if (fromIdeaProject) {
                    OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).recursively();
                    for (VirtualFile file : enumerator.getAllLibrariesAndSdkClassesRoots()) {
                        params.getClassPath().add(file);
                    }
                } else {
                    for (String path : Arrays.asList("log4j.jar", "jdom.jar", "trove4j.jar", "openapi.jar", "util.jar", "extensions.jar", "bootstrap.jar", "idea_rt.jar", "idea.jar")) {
                        params.getClassPath().add(ideaJdkHome + FileUtil.toSystemDependentName((String)("/lib/" + path)));
                    }
                }
                params.getClassPath().addFirst(((JavaSdkType)usedIdeaJdk.getSdkType()).getToolsPath(usedIdeaJdk));
                params.setMainClass("com.intellij.idea.Main");
                return params;
            }
        };
        return state;
    }

    public String getAlternativeJrePath() {
        return this.ALTERNATIVE_JRE_PATH;
    }

    public void setAlternativeJrePath(String ALTERNATIVE_JRE_PATH) {
        this.ALTERNATIVE_JRE_PATH = ALTERNATIVE_JRE_PATH;
    }

    public boolean isAlternativeJreEnabled() {
        return this.ALTERNATIVE_JRE_PATH_ENABLED;
    }

    public void setAlternativeJreEnabled(boolean ALTERNATIVE_JRE_PATH_ENABLED) {
        this.ALTERNATIVE_JRE_PATH_ENABLED = ALTERNATIVE_JRE_PATH_ENABLED;
    }

    private static void fillParameterList(ParametersList list, @Nullable String value) {
        if (value == null) {
            return;
        }
        for (String parameter : value.split(" ")) {
            if (parameter == null || parameter.length() <= 0) continue;
            list.add(parameter);
        }
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        if (this.getModule() == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        String moduleName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return PluginRunConfiguration.this.getModule().getName();
            }
        });
        if (ModuleManager.getInstance((Project)this.getProject()).findModuleByName(moduleName) == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("run.configuration.no.module.specified", new Object[0]));
        }
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.getModule());
        Sdk sdk = rootManager.getSdk();
        if (sdk == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("sdk.no.specified", moduleName));
        }
        if (IdeaJdk.findIdeaJdk(sdk) == null) {
            throw new RuntimeConfigurationException(DevKitBundle.message("sdk.type.incorrect", moduleName));
        }
    }

    @NotNull
    public Module[] getModules() {
        Module[] moduleArray;
        Module module = this.getModule();
        if (module != null) {
            Module[] moduleArray2 = new Module[1];
            moduleArray = moduleArray2;
            moduleArray2[0] = module;
        } else {
            moduleArray = Module.EMPTY_ARRAY;
        }
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/run/PluginRunConfiguration", "getModules"));
        }
        return moduleArray;
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element module = element.getChild(MODULE);
        if (module != null) {
            this.myModuleName = module.getAttributeValue(NAME);
        }
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
        Element altElement = element.getChild(ALTERNATIVE_PATH_ELEMENT);
        if (altElement != null) {
            this.ALTERNATIVE_JRE_PATH = altElement.getAttributeValue(PATH);
            String enabledAttr = altElement.getAttributeValue(ALTERNATIVE_PATH_ENABLED_ATTR);
            this.ALTERNATIVE_JRE_PATH_ENABLED = enabledAttr != null && Boolean.parseBoolean(enabledAttr);
        }
        super.readExternal(element);
        if (this.getPredefinedLogFiles().isEmpty() && this.getLogFiles().isEmpty()) {
            this.addPredefinedLogFile(new PredefinedLogFile(IDEA_LOG, true));
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element moduleElement = new Element(MODULE);
        moduleElement.setAttribute(NAME, (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                Module module = PluginRunConfiguration.this.getModule();
                return module != null ? module.getName() : (PluginRunConfiguration.this.myModuleName != null ? PluginRunConfiguration.this.myModuleName : "");
            }
        }));
        element.addContent(moduleElement);
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        if (!StringUtil.isEmptyOrSpaces((String)this.ALTERNATIVE_JRE_PATH)) {
            Element altElement = new Element(ALTERNATIVE_PATH_ELEMENT);
            altElement.setAttribute(PATH, this.ALTERNATIVE_JRE_PATH);
            altElement.setAttribute(ALTERNATIVE_PATH_ENABLED_ATTR, String.valueOf(this.ALTERNATIVE_JRE_PATH_ENABLED));
            element.addContent(altElement);
        }
        super.writeExternal(element);
    }

    @Nullable
    public Module getModule() {
        if (this.myModule == null && this.myModuleName != null && !this.getProject().isDisposed()) {
            this.myModule = ModuleManager.getInstance((Project)this.getProject()).findModuleByName(this.myModuleName);
        }
        if (this.myModule != null && this.myModule.isDisposed()) {
            this.myModule = null;
        }
        return this.myModule;
    }

    public void setModule(Module module) {
        this.myModule = module;
    }
}

