/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

class StatementCountVisitor
extends GroovyRecursiveElementVisitor {
    private int statementCount = 0;

    StatementCountVisitor() {
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/codeInspection/metrics/StatementCountVisitor", "visitElement"));
        }
        int oldCount = 0;
        if (element instanceof GrMethod) {
            oldCount = this.statementCount;
        }
        super.visitElement(element);
        if (element instanceof GrMethod) {
            this.statementCount = oldCount;
        }
    }

    @Override
    public void visitStatement(@NotNull GrStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/metrics/StatementCountVisitor", "visitStatement"));
        }
        super.visitStatement(statement);
        if (statement instanceof GrBlockStatement) {
            return;
        }
        ++this.statementCount;
    }

    public int getStatementCount() {
        return this.statementCount;
    }
}

