/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow;

import com.intellij.openapi.progress.ProgressManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallEnvironment;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.DfaInstance;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.Semilattice;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkCounter;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.WorkList;

public class DFAEngine<E> {
    private final Instruction[] myFlow;
    private final DfaInstance<E> myDfa;
    private final Semilattice<E> mySemilattice;
    private WorkCounter myCounter;

    public DFAEngine(@NotNull Instruction[] flow, @NotNull DfaInstance<E> dfa, @NotNull Semilattice<E> semilattice) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "<init>"));
        }
        if (dfa == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dfa", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "<init>"));
        }
        if (semilattice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "semilattice", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "<init>"));
        }
        this.myCounter = null;
        this.myFlow = flow;
        this.myDfa = dfa;
        this.mySemilattice = semilattice;
    }

    @NotNull
    public List<E> performForceDFA() {
        List<E> result = this.performDFA(false);
        assert (result != null);
        List<E> list = result;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "performForceDFA"));
        }
        return list;
    }

    @Nullable
    public List<E> performDFAWithTimeout() {
        return this.performDFA(true);
    }

    @Nullable
    private List<E> performDFA(boolean timeout) {
        int n = this.myFlow.length;
        ArrayList<E> info = new ArrayList<E>(Collections.nCopies(n, this.myDfa.initial()));
        MyCallEnvironment env = new MyCallEnvironment(n);
        WorkList workList = new WorkList(this.getFlowOrder());
        while (!workList.isEmpty()) {
            ProgressManager.checkCanceled();
            if (timeout && this.checkCounter()) {
                return null;
            }
            int num = workList.next();
            Instruction curr = this.myFlow[num];
            Object oldE = info.get(num);
            E newE = this.getInboundState(curr, info, env);
            this.myDfa.fun(newE, curr);
            if (this.mySemilattice.eq(newE, oldE)) continue;
            info.set(num, newE);
            for (Instruction next : this.getNext(curr, env)) {
                workList.offer(next.num());
            }
        }
        return info;
    }

    @NotNull
    private int[] getFlowOrder() {
        if (this.myDfa.isForward()) {
            int[] nArray = ControlFlowBuilderUtil.reversePostorder(this.myFlow);
            if (nArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getFlowOrder"));
            }
            return nArray;
        }
        int[] nArray = ControlFlowBuilderUtil.postorder(this.myFlow);
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getFlowOrder"));
        }
        return nArray;
    }

    @NotNull
    private E getInboundState(@NotNull Instruction instruction, @NotNull List<E> info, @NotNull CallEnvironment env) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getInboundState"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getInboundState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getInboundState"));
        }
        ArrayList<E> prevInfos = new ArrayList<E>();
        for (Instruction i : this.getPrevious(instruction, env)) {
            prevInfos.add(info.get(i.num()));
        }
        E e = this.mySemilattice.join(prevInfos);
        if (e == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getInboundState"));
        }
        return e;
    }

    @NotNull
    private Iterable<Instruction> getPrevious(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getPrevious"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getPrevious"));
        }
        Iterable<Instruction> iterable = this.myDfa.isForward() ? instruction.predecessors(env) : instruction.successors(env);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getPrevious"));
        }
        return iterable;
    }

    @NotNull
    private Iterable<Instruction> getNext(@NotNull Instruction instruction, @NotNull CallEnvironment env) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getNext"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getNext"));
        }
        Iterable<Instruction> iterable = this.myDfa.isForward() ? instruction.successors(env) : instruction.predecessors(env);
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine", "getNext"));
        }
        return iterable;
    }

    private boolean checkCounter() {
        if (this.myCounter == null) {
            this.myCounter = new WorkCounter();
            return false;
        }
        return this.myCounter.isTimeOver();
    }

    private static class MyCallEnvironment
    implements CallEnvironment {
        ArrayList<Deque<CallInstruction>> myEnv;

        private MyCallEnvironment(int instructionNum) {
            this.myEnv = new ArrayList(instructionNum);
            for (int i = 0; i < instructionNum; ++i) {
                this.myEnv.add(new ArrayDeque());
            }
        }

        @Override
        @NotNull
        public Deque<CallInstruction> callStack(@NotNull Instruction instruction) {
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine$MyCallEnvironment", "callStack"));
            }
            Deque<CallInstruction> deque = this.myEnv.get(instruction.num());
            if (deque == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine$MyCallEnvironment", "callStack"));
            }
            return deque;
        }

        @Override
        public void update(@NotNull Deque<CallInstruction> callStack, @NotNull Instruction instruction) {
            if (callStack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callStack", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine$MyCallEnvironment", "update"));
            }
            if (instruction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/plugins/groovy/lang/psi/dataFlow/DFAEngine$MyCallEnvironment", "update"));
            }
            this.myEnv.set(instruction.num(), callStack);
        }
    }
}

