/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.projectView;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcModuleStructureUtil;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectViewPane;
import org.jetbrains.plugins.groovy.mvc.projectView.MvcProjectViewState;

public abstract class MvcToolWindowDescriptor
implements ToolWindowFactory,
Condition<Project>,
DumbAware {
    private final MvcFramework myFramework;

    public MvcToolWindowDescriptor(MvcFramework framework) {
        this.myFramework = framework;
    }

    public MvcFramework getFramework() {
        return this.myFramework;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/mvc/projectView/MvcToolWindowDescriptor", "createToolWindowContent"));
        }
        if (toolWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "org/jetbrains/plugins/groovy/mvc/projectView/MvcToolWindowDescriptor", "createToolWindowContent"));
        }
        toolWindow.setAvailable(true, null);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setTitle(this.myFramework.getDisplayName());
        MvcProjectViewPane view = new MvcProjectViewPane(project, this);
        view.setup((ToolWindowEx)toolWindow);
    }

    public boolean value(Project project) {
        return MvcModuleStructureUtil.hasModulesWithSupport(project, this.myFramework);
    }

    public String getToolWindowId() {
        return MvcToolWindowDescriptor.getToolWindowId(this.myFramework);
    }

    public static String getToolWindowId(MvcFramework framework) {
        return framework.getFrameworkName() + " View";
    }

    public abstract void fillModuleChildren(List<AbstractTreeNode> var1, Module var2, ViewSettings var3, VirtualFile var4);

    public abstract Icon getModuleNodeIcon();

    @NotNull
    public abstract MvcProjectViewState getProjectViewState(Project var1);

    @Nullable
    protected static PsiDirectory findDirectory(Project project, VirtualFile root, @NotNull String relativePath) {
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "org/jetbrains/plugins/groovy/mvc/projectView/MvcToolWindowDescriptor", "findDirectory"));
        }
        VirtualFile file = root.findFileByRelativePath(relativePath);
        return file == null ? null : PsiManager.getInstance((Project)project).findDirectory(file);
    }
}

