/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.vfs.VirtualFile;
import icons.MavenIcons;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryAttachHandler;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryWithDescriptionEditor;

public class RepositoryLibraryType
extends LibraryType<RepositoryLibraryProperties> {
    public static final PersistentLibraryKind<RepositoryLibraryProperties> REPOSITORY_LIBRARY_KIND = new PersistentLibraryKind<RepositoryLibraryProperties>("repository"){

        @NotNull
        public RepositoryLibraryProperties createDefaultProperties() {
            RepositoryLibraryProperties repositoryLibraryProperties = new RepositoryLibraryProperties();
            if (repositoryLibraryProperties == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType$1", "createDefaultProperties"));
            }
            return repositoryLibraryProperties;
        }
    };

    protected RepositoryLibraryType() {
        super(REPOSITORY_LIBRARY_KIND);
    }

    public static RepositoryLibraryType getInstance() {
        return (RepositoryLibraryType)((Object)EP_NAME.findExtension(RepositoryLibraryType.class));
    }

    @Nullable
    public String getCreateActionName() {
        return "From Maven...";
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project) {
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "createNewLibrary"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "createNewLibrary"));
        }
        return RepositoryAttachHandler.chooseLibraryAndDownload(project, null, parentComponent);
    }

    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<RepositoryLibraryProperties> component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "createPropertiesEditor"));
        }
        return new RepositoryLibraryWithDescriptionEditor(component);
    }

    @Nullable
    public Icon getIcon(@Nullable RepositoryLibraryProperties properties) {
        if (properties == null) {
            return MavenIcons.MavenLogo;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = properties;
        if (repositoryLibraryProperties.getGroupId() == null || repositoryLibraryProperties.getArtifactId() == null) {
            return MavenIcons.MavenLogo;
        }
        return RepositoryLibraryDescription.findDescription(repositoryLibraryProperties).getIcon();
    }

    @NotNull
    public String getDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "getDescription"));
        }
        RepositoryLibraryDescription description = RepositoryLibraryDescription.findDescription(properties);
        String string = description.getDisplayName(properties.getVersion());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/utils/library/RepositoryLibraryType", "getDescription"));
        }
        return string;
    }
}

