/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.GradleExtensions;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;

@Order(value=1000)
public class GradleExtensionsDataService
extends AbstractProjectDataService<GradleExtensions, Module> {
    @NotNull
    public static final Key<GradleExtensions> KEY = Key.create(GradleExtensions.class, (int)(BuildScriptClasspathData.KEY.getProcessingWeight() + 1));

    @NotNull
    public Key<GradleExtensions> getTargetDataKey() {
        Key<GradleExtensions> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/data/GradleExtensionsDataService", "getTargetDataKey"));
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<GradleExtensions>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "org/jetbrains/plugins/gradle/service/project/data/GradleExtensionsDataService", "importData"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/service/project/data/GradleExtensionsDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/gradle/service/project/data/GradleExtensionsDataService", "importData"));
        }
        if (projectData == null || toImport.isEmpty()) {
            return;
        }
        HashMap extensionMap = ContainerUtil.newHashMap();
        for (DataNode<GradleExtensions> node : toImport) {
            DataNode parent = node.getParent();
            if (parent == null || !(parent.getData() instanceof ModuleData)) continue;
            String projectPath = ((ModuleData)parent.getData()).getLinkedExternalProjectPath();
            extensionMap.put(projectPath, node.getData());
        }
        GradleExtensionsSettings.getInstance(project).add(projectData.getLinkedExternalProjectPath(), extensionMap);
    }
}

