/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiMember;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.UastVisitor;

public class MathDetector
extends Detector
implements Detector.UastScanner {
    public static final Issue ISSUE = Issue.create("FloatMath", "Using `FloatMath` instead of `Math`", "In older versions of Android, using `android.util.FloatMath` was recommended for performance reasons when operating on floats. However, on modern hardware doubles are just as fast as float (though they take more memory), and in recent versions of Android, `FloatMath` is actually slower than using `java.lang.Math` due to the way the JIT optimizes `java.lang.Math`. Therefore, you should use `Math` instead of `FloatMath` if you are only targeting Froyo and above.", Category.PERFORMANCE, 3, Severity.WARNING, new Implementation(MathDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/design/performance.html#avoidfloat");

    @Override
    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("sin", "cos", "ceil", "sqrt", "floor");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression call, @NonNull UMethod method) {
        context.getEvaluator();
        if (JavaEvaluator.isMemberInClass((PsiMember)method, "android.util.FloatMath") && context.getProject().getMinSdk() >= 8) {
            String message2 = String.format("Use `java.lang.Math#%1$s` instead of `android.util.FloatMath#%1$s()` since it is faster as of API 8", method.getName());
            Location location = context.getUastLocation(call.getMethodIdentifier());
            context.report(ISSUE, call, location, message2);
        }
    }
}

