/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides;

import com.oracle.javafx.scenebuilder.kit.editor.panel.content.guides.AbstractSegment;
import com.oracle.javafx.scenebuilder.kit.util.MathUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SegmentIndex {
    private final List<AbstractSegment> segments = new ArrayList<AbstractSegment>();
    private boolean sorted;

    public void addSegment(AbstractSegment s) {
        this.segments.add(s);
        this.sorted = false;
    }

    public void clear() {
        this.segments.clear();
    }

    public List<AbstractSegment> match(double targetLength, double threshold) {
        assert (targetLength >= 0.0);
        assert (threshold >= 0.0);
        if (!this.sorted) {
            Collections.sort(this.segments);
        }
        double bestDelta = Double.MAX_VALUE;
        ArrayList<AbstractSegment> result = new ArrayList<AbstractSegment>();
        for (AbstractSegment s : this.segments) {
            double delta = Math.abs(s.getLength() - targetLength);
            if (!(delta < threshold)) continue;
            if (MathUtils.equals(delta, bestDelta)) {
                result.add(s);
                continue;
            }
            if (!(delta < bestDelta)) continue;
            bestDelta = delta;
            result.clear();
            result.add(s);
        }
        return result;
    }
}

