/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.ManualVariance;
import org.jetbrains.kotlin.resolve.VarianceCheckerCore;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddVarianceModifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "AddVarianceFix", "idea"})
public final class AddVarianceModifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        return new KtVisitorVoid(holder){
            final /* synthetic */ ProblemsHolder $holder;

            private final boolean variancePossible(KtClassOrObject klass2, TypeParameterDescriptor parameterDescriptor, Variance variance, BindingContext context) {
                DiagnosticSink diagnosticSink = DiagnosticSink.DO_NOTHING;
                Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink, (String)"DiagnosticSink.DO_NOTHING");
                return new VarianceCheckerCore(context, diagnosticSink, new ManualVariance(parameterDescriptor, variance)).checkClassOrObject(klass2);
            }

            /*
             * WARNING - void declaration
             */
            public void visitClassOrObject(@NotNull KtClassOrObject klass2) {
                Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
                BindingContext context = ResolutionUtils.analyzeFully(klass2);
                for (KtTypeParameter typeParameter : klass2.getTypeParameters()) {
                    AddVarianceFix addVarianceFix;
                    ProblemsHolder problemsHolder;
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    Collection $receiver$iv;
                    Iterable destination$iv$iv2;
                    Object element$iv$iv2;
                    void $receiver$iv$iv2;
                    void $receiver$iv2;
                    if (Intrinsics.areEqual((Object)((Object)typeParameter.getVariance()), (Object)((Object)Variance.INVARIANT)) ^ true) continue;
                    DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, typeParameter);
                    if (!(declarationDescriptor instanceof TypeParameterDescriptor)) {
                        declarationDescriptor = null;
                    }
                    if ((TypeParameterDescriptor)declarationDescriptor == null) {
                        continue;
                    }
                    Iterable iterable = CollectionsKt.listOf((Object[])new Variance[]{Variance.IN_VARIANCE, Variance.OUT_VARIANCE});
                    void var8_8 = $receiver$iv2;
                    Collection collection = new ArrayList<E>();
                    for (Object element$iv$iv2 : $receiver$iv$iv2) {
                        TypeParameterDescriptor parameterDescriptor;
                        Variance it = (Variance)((Object)element$iv$iv2);
                        if (!this.variancePossible(klass2, parameterDescriptor, it, context)) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    List variances = (List)destination$iv$iv2;
                    if (variances.size() != 1) continue;
                    Variance suggested = (Variance)((Object)CollectionsKt.first((List)variances));
                    destination$iv$iv2 = variances;
                    Iterator<T> iterator2 = $receiver$iv;
                    element$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it;
                        Variance $i$f$filterTo = (Variance)((Object)item$iv$iv);
                        problemsHolder = destination$iv$iv;
                        addVarianceFix = new AddVarianceFix((Variance)it);
                        problemsHolder.add(addVarianceFix);
                    }
                    List fixes2 = (List)destination$iv$iv;
                    $receiver$iv = fixes2;
                    ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
                    String string = "Type parameter can have " + (Object)((Object)suggested) + " variance";
                    addVarianceFix = typeParameter;
                    problemsHolder = this.$holder;
                    Collection thisCollection$iv = $receiver$iv;
                    AddVarianceFix[] addVarianceFixArray = thisCollection$iv.toArray(new AddVarianceFix[thisCollection$iv.size()]);
                    if (addVarianceFixArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Object[] objectArray = addVarianceFixArray;
                    LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])objectArray;
                    problemsHolder.registerProblem((PsiElement)addVarianceFix, string, problemHighlightType, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                }
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/AddVarianceModifierInspection$AddVarianceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "variance", "Lorg/jetbrains/kotlin/types/Variance;", "(Lorg/jetbrains/kotlin/types/Variance;)V", "getVariance", "()Lorg/jetbrains/kotlin/types/Variance;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class AddVarianceFix
    implements LocalQuickFix {
        @NotNull
        private final Variance variance;

        @NotNull
        public String getName() {
            return "Add '" + (Object)((Object)this.variance) + "' variance";
        }

        @NotNull
        public String getFamilyName() {
            return "Add variance";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                return;
            }
            PsiElement psiElement = descriptor2.getPsiElement();
            if (!(psiElement instanceof KtTypeParameter)) {
                psiElement = null;
            }
            KtTypeParameter ktTypeParameter = (KtTypeParameter)psiElement;
            if (ktTypeParameter == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Add variance fix is used on " + descriptor2.getPsiElement().getText())));
            }
            KtTypeParameter typeParameter = ktTypeParameter;
            KtModifierListOwner ktModifierListOwner = typeParameter;
            KtModifierKeywordToken ktModifierKeywordToken = Intrinsics.areEqual((Object)((Object)this.variance), (Object)((Object)Variance.IN_VARIANCE)) ? KtTokens.IN_KEYWORD : KtTokens.OUT_KEYWORD;
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktModifierKeywordToken), (String)"if (variance == Variance\u2026else KtTokens.OUT_KEYWORD");
            AddRemoveModifierKt.addModifier(ktModifierListOwner, ktModifierKeywordToken);
        }

        @NotNull
        public final Variance getVariance() {
            return this.variance;
        }

        public AddVarianceFix(@NotNull Variance variance) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)variance), (String)"variance");
            this.variance = variance;
        }
    }
}

