/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.IdeaLogger;
import org.jetbrains.java.decompiler.main.decompiler.BaseDecompiler;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.idea.actions.DecompileKotlinToJavaActionKt;
import org.jetbrains.kotlin.idea.internal.KotlinBytecodeToolWindow;
import org.jetbrains.kotlin.idea.internal.KotlinDecompilerService;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00042\u0006\u0010\b\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerServiceImpl;", "Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerService;", "()V", "bytecodeMapForExistingClassfile", "", "Ljava/io/File;", "Lkotlin/Function0;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "bytecodeMapForSourceFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "decompile", "", "KotlinResultSaver", "idea"})
public final class KotlinDecompilerServiceImpl
implements KotlinDecompilerService {
    @Override
    @Nullable
    public String decompile(@NotNull KtFile file2) {
        Map<File, Function0<byte[]>> map2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (DecompileKotlinToJavaActionKt.canBeDecompiledToJava(file2)) {
            VirtualFile virtualFile2 = file2.getVirtualFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file.virtualFile");
            map2 = this.bytecodeMapForExistingClassfile(virtualFile2);
        } else if (!file2.isCompiled()) {
            map2 = this.bytecodeMapForSourceFile(file2);
        } else {
            return null;
        }
        Map<File, Function0<byte[]>> bytecodeMap = map2;
        KotlinResultSaver resultSaver = new KotlinResultSaver();
        HashMap options2 = MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"rbr", (Object)"0")});
        IBytecodeProvider bytecodeProvider2 = new IBytecodeProvider(bytecodeMap){
            final /* synthetic */ Map $bytecodeMap;

            @Nullable
            public final byte[] getBytecode(String externalPath, String internalPath) {
                File path = new File(FileUtil.toSystemIndependentName((String)externalPath));
                Function0 function0 = (Function0)this.$bytecodeMap.get(path);
                return (byte[])(function0 != null ? (byte[])function0.invoke() : null);
            }
            {
                this.$bytecodeMap = map2;
            }
        };
        BaseDecompiler decompiler = new BaseDecompiler(bytecodeProvider2, (IResultSaver)resultSaver, (Map)options2, (IFernflowerLogger)new IdeaLogger());
        for (File path : bytecodeMap.keySet()) {
            decompiler.addSpace(path, true);
        }
        decompiler.decompileContext();
        return resultSaver.getResultText();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<File, Function0<byte[]>> bytecodeMapForExistingClassfile(@NotNull VirtualFile file2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable destination$iv$iv2;
        VirtualFile it;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        String mask = file2.getNameWithoutExtension() + "$";
        Object[] objectArray = file2.getParent().getChildren();
        Map map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)file2.getPath(), (Object)file2));
        void var5_5 = $receiver$iv;
        Collection collection = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv2).length; ++i) {
            void element$iv$iv = $receiver$iv$iv2[i];
            it = (VirtualFile)element$iv$iv;
            if (!(StringsKt.startsWith$default((String)it.getNameWithoutExtension(), (String)mask, (boolean)false, (int)2, null) && it.getFileType() == StdFileTypes.CLASS)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Collection<Pair> collection2 = (List)destination$iv$iv2;
        $receiver$iv = collection2;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            it = (VirtualFile)item$iv$iv;
            collection2 = destination$iv$iv2;
            Pair pair2 = TuplesKt.to((Object)it.getPath(), (Object)it);
            collection2.add(pair2);
        }
        collection2 = (List)destination$iv$iv2;
        Map files2 = MapsKt.plus((Map)map2, (Iterable)collection2);
        $receiver$iv = files2.entrySet();
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        destination$iv$iv2 = $receiver$iv;
        Map map3 = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            void var10_15 = destination$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv;
            Pair pair3 = new Pair((Object)new File((String)it2.getKey()), (Object)new Function0<byte[]>(it2){
                final /* synthetic */ Map.Entry $it;

                @NotNull
                public final byte[] invoke() {
                    return ((VirtualFile)this.$it.getValue()).contentsToByteArray();
                }
                {
                    this.$it = entry;
                    super(0);
                }
            });
            var10_15.put(pair3.getFirst(), pair3.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<File, Function0<byte[]>> bytecodeMapForSourceFile(@NotNull KtFile file2) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        GenerationState generationState = KotlinBytecodeToolWindow.compileSingleFile(file2, true, true, true);
        HashMap bytecodeMap = MapsKt.hashMapOf((Pair[])new Pair[0]);
        Iterable iterable = generationState.getFactory().asList();
        Iterator iterator2 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            OutputFile it = (OutputFile)element$iv$iv;
            if (!FileUtilRt.extensionEquals((String)it.getRelativePath(), (String)"class")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            File file3;
            OutputFile it = (OutputFile)element$iv;
            Map map2 = bytecodeMap;
            Intrinsics.checkExpressionValueIsNotNull((Object)new File("/" + it.getRelativePath()).getAbsoluteFile(), (String)"File(\"/${it.relativePath}\").absoluteFile");
            Function0<byte[]> function0 = new Function0<byte[]>(it){
                final /* synthetic */ OutputFile $it;

                @NotNull
                public final byte[] invoke() {
                    return this.$it.asByteArray();
                }
                {
                    this.$it = outputFile;
                    super(0);
                }
            };
            map2.put(file3, function0);
        }
        return bytecodeMap;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0016J0\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J&\u0010\u0010\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J&\u0010\u0012\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J:\u0010\u0015\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0016J:\u0010\u0018\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J&\u0010\u001b\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0016J\u0012\u0010\u001c\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinDecompilerServiceImpl$KotlinResultSaver;", "Lorg/jetbrains/java/decompiler/main/extern/IResultSaver;", "()V", "decompiledText", "", "", "resultText", "getResultText", "()Ljava/lang/String;", "closeArchive", "", "path", "archiveName", "copyEntry", "source", "entry", "copyFile", "entryName", "createArchive", "manifest", "Ljava/util/jar/Manifest;", "saveClassEntry", "qualifiedName", "content", "saveClassFile", "mapping", "", "saveDirEntry", "saveFolder", "idea"})
    public static final class KotlinResultSaver
    implements IResultSaver {
        private final Map<String, String> decompiledText = MapsKt.mutableMapOf((Pair[])new Pair[0]);

        @NotNull
        public final String getResultText() {
            String string = (String)CollectionsKt.singleOrNull((Iterable)this.decompiledText.values());
            if (string != null) {
                String string2 = string;
                String it = string2;
                return it;
            }
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder $receiver = stringBuilder;
            Map<String, String> $i$a$1$let = this.decompiledText;
            Iterator<Map.Entry<String, String>> iterator2 = $i$a$1$let.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, String> entry;
                Map.Entry<String, String> entry2 = entry = iterator2.next();
                String filename = entry2.getKey();
                Object object = entry;
                String content2 = object.getValue();
                object = $receiver;
                String string3 = "// " + filename;
                StringsKt.appendln((StringBuilder)((StringBuilder)object).append(string3));
                $receiver.append(content2);
            }
            String string4 = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
            return string4;
        }

        public void saveFolder(@Nullable String path) {
        }

        public void closeArchive(@Nullable String path, @Nullable String archiveName) {
        }

        public void copyEntry(@Nullable String source, @Nullable String path, @Nullable String archiveName, @Nullable String entry) {
        }

        public void createArchive(@Nullable String path, @Nullable String archiveName, @Nullable Manifest manifest) {
        }

        public void saveClassFile(@Nullable String path, @Nullable String qualifiedName, @Nullable String entryName, @Nullable String content2, @Nullable int[] mapping) {
            if (entryName != null && content2 != null) {
                Map<String, String> map2 = this.decompiledText;
                String string = content2;
                map2.put(entryName, string);
            }
        }

        public void copyFile(@Nullable String source, @Nullable String path, @Nullable String entryName) {
        }

        public void saveClassEntry(@Nullable String path, @Nullable String archiveName, @Nullable String qualifiedName, @Nullable String entryName, @Nullable String content2) {
        }

        public void saveDirEntry(@Nullable String path, @Nullable String archiveName, @Nullable String entryName) {
        }
    }
}

