/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.rules.AbstractNamedFileSnapshotTaskStateChanges;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotterRegistry;
import org.gradle.api.internal.changedetection.state.OutputFilesSnapshotter;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilesTaskStateChanges
extends AbstractNamedFileSnapshotTaskStateChanges {
    private final OutputFilesSnapshotter outputSnapshotter;

    public OutputFilesTaskStateChanges(TaskExecution previous, TaskExecution current, TaskInternal task, FileCollectionSnapshotterRegistry snapshotterRegistry, OutputFilesSnapshotter outputSnapshotter) {
        super(task.getName(), previous, current, snapshotterRegistry, "Output", task.getOutputs().getFileProperties());
        this.outputSnapshotter = outputSnapshotter;
    }

    @Override
    public Map<String, FileCollectionSnapshot> getPrevious() {
        return this.previous.getOutputFilesSnapshot();
    }

    @Override
    public void saveCurrent() {
        Map<String, FileCollectionSnapshot> outputFilesAfter = OutputFilesTaskStateChanges.buildSnapshots(this.getTaskName(), this.getSnapshotterRegistry(), this.getTitle(), this.getFileProperties());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TaskFilePropertySpec propertySpec : this.fileProperties) {
            String propertyName = propertySpec.getPropertyName();
            FileCollectionSnapshot beforeExecution = this.getCurrent().get(propertyName);
            FileCollectionSnapshot afterExecution = outputFilesAfter.get(propertyName);
            FileCollectionSnapshot afterPreviousExecution = this.getSnapshotAfterPreviousExecution(propertyName);
            FileCollectionSnapshot outputSnapshot = this.outputSnapshotter.createOutputSnapshot(afterPreviousExecution, beforeExecution, afterExecution);
            builder.put((Object)propertyName, (Object)outputSnapshot);
        }
        this.current.setOutputFilesSnapshot((Map<String, FileCollectionSnapshot>)builder.build());
    }

    private FileCollectionSnapshot getSnapshotAfterPreviousExecution(String propertyName) {
        FileCollectionSnapshot afterPreviousExecution;
        Map<String, FileCollectionSnapshot> previousSnapshots;
        if (this.previous != null && (previousSnapshots = this.previous.getOutputFilesSnapshot()) != null && (afterPreviousExecution = previousSnapshots.get(propertyName)) != null) {
            return afterPreviousExecution;
        }
        return FileCollectionSnapshot.EMPTY;
    }
}

