/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.ActionHint;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import junit.framework.ComparisonFailure;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    protected static final String BEFORE_PREFIX = "before";
    @NonNls
    protected static final String AFTER_PREFIX = "after";
    private static QuickFixTestCase myWrapper;

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    private static void doTestFor(@NotNull String testName, @NotNull QuickFixTestCase quickFixTestCase) {
        if (testName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doTestFor"));
        }
        if (quickFixTestCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixTestCase", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doTestFor"));
        }
        String relativePath = (String)ObjectUtils.notNull((Object)quickFixTestCase.getBasePath(), (Object)"") + "/" + BEFORE_PREFIX + testName;
        String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
        File testFile = new File(testFullPath);
        CommandProcessor.getInstance().executeCommand(quickFixTestCase.getProject(), () -> {
            if (quickFixTestCase == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixTestCase", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "lambda$doTestFor$0"));
            }
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "lambda$doTestFor$0"));
            }
            try {
                String contents = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)testFile, (Charset)CharsetToolkit.UTF8_CHARSET));
                quickFixTestCase.configureFromFileText(testFile.getName(), contents);
                quickFixTestCase.bringRealEditorBack();
                ActionHint actionHint = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                quickFixTestCase.beforeActionStarted(testName, contents);
                try {
                    myWrapper = quickFixTestCase;
                    quickFixTestCase.doAction(actionHint, testFullPath, testName);
                }
                finally {
                    myWrapper = null;
                    quickFixTestCase.afterActionCompleted(testName, contents);
                }
            }
            catch (ComparisonFailure e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.fail((String)(testName + " failed"));
            }
        }, "", "");
    }

    protected void afterActionCompleted(String testName, String contents) {
    }

    protected void beforeActionStarted(String testName, String contents) {
    }

    public static void doAction(@NotNull ActionHint actionHint, String testFullPath, String testName, QuickFixTestCase quickFix) throws Exception {
        if (actionHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionHint", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doAction"));
        }
        IntentionAction action = actionHint.findAndCheck(quickFix.getAvailableActions(), () -> "Test: " + testFullPath + "\nInfos: " + quickFix.doHighlighting());
        if (action != null) {
            IntentionAction afterAction;
            String text = action.getText();
            quickFix.invoke(action);
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            if (!quickFix.shouldBeAvailableAfterExecution() && (afterAction = quickFix.findActionWithText(text)) != null) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            String expectedFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/" + AFTER_PREFIX + testName;
            quickFix.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
            String familyName = action.getFamilyName();
            if (StringUtil.isEmptyOrSpaces((String)familyName)) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' provides empty family name which means that user would see action with empty presentable text in Inspection Results"));
            }
        }
    }

    protected void doAction(@NotNull ActionHint actionHint, String testFullPath, String testName) throws Exception {
        if (actionHint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionHint", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doAction"));
        }
        LightQuickFixTestCase.doAction(actionHint, testFullPath, testName, myWrapper);
    }

    protected void doAction(@NotNull String actionName) {
        if (actionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionName", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doAction"));
        }
        List<IntentionAction> available = this.getAvailableActions();
        IntentionAction action = LightQuickFixTestCase.findActionWithText(available, actionName);
        LightQuickFixTestCase.assertNotNull((String)("Action '" + actionName + "' not found among " + available), (Object)action);
        LightQuickFixTestCase.invoke(action);
    }

    protected static void invoke(@NotNull IntentionAction action) throws IncorrectOperationException {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "invoke"));
        }
        CodeInsightTestFixtureImpl.invokeIntention((IntentionAction)action, (PsiFile)LightQuickFixTestCase.getFile(), (Editor)LightQuickFixTestCase.getEditor(), (String)action.getText());
    }

    protected IntentionAction findActionAndCheck(@NotNull ActionHint hint, String testFullPath) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "findActionAndCheck"));
        }
        return hint.findAndCheck(this.getAvailableActions(), () -> "Test: " + testFullPath);
    }

    protected IntentionAction findActionWithText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "findActionWithText"));
        }
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(@NotNull List<IntentionAction> actions, @NotNull String text) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "findActionWithText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "findActionWithText"));
        }
        for (IntentionAction action : actions) {
            if (!text.equals(action.getText())) continue;
            return action;
        }
        return null;
    }

    protected void doAllTests() {
        LightQuickFixTestCase.doAllTests(this.createWrapper());
    }

    public static void doAllTests(QuickFixTestCase testCase) {
        File[] files;
        for (File file : files = LightQuickFixTestCase.getBeforeTestFiles(testCase)) {
            String testName = file.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName, testCase);
        }
    }

    @NotNull
    public static File[] getBeforeTestFiles(@NotNull QuickFixTestCase testCase) {
        if (testCase == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCase", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getBeforeTestFiles"));
        }
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase.getBasePath());
        String testDirPath = testCase.getTestDataPath().replace(File.separatorChar, '/') + testCase.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles((dir, name) -> name.startsWith(BEFORE_PREFIX));
        if (files == null || files.length == 0) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        if (files == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getBeforeTestFiles"));
        }
        return files;
    }

    protected void doSingleTest(@NotNull String fileSuffix) {
        if (fileSuffix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSuffix", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "doSingleTest"));
        }
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper());
    }

    protected void doSingleTest(String fileSuffix, String testDataPath) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper(testDataPath));
    }

    @NotNull
    protected QuickFixTestCase createWrapper() {
        QuickFixTestCase quickFixTestCase = this.createWrapper(null);
        if (quickFixTestCase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "createWrapper"));
        }
        return quickFixTestCase;
    }

    @NotNull
    protected QuickFixTestCase createWrapper(final String testDataPath) {
        QuickFixTestCase quickFixTestCase = new QuickFixTestCase(){
            public String myTestDataPath;
            {
                this.myTestDataPath = testDataPath;
            }

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            @NotNull
            public String getTestDataPath() {
                if (this.myTestDataPath == null) {
                    this.myTestDataPath = LightQuickFixTestCase.this.getTestDataPath();
                }
                String string = this.myTestDataPath;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "getTestDataPath"));
                }
                return string;
            }

            @Override
            @NotNull
            public ActionHint parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "parseActionHintImpl"));
                }
                if (contents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "parseActionHintImpl"));
                }
                ActionHint actionHint = ActionHint.parse(file, contents);
                if (actionHint == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "parseActionHintImpl"));
                }
                return actionHint;
            }

            @Override
            public void beforeActionStarted(@NotNull String testName, @NotNull String contents) {
                if (testName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "beforeActionStarted"));
                }
                if (contents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "beforeActionStarted"));
                }
                LightQuickFixTestCase.this.beforeActionStarted(testName, contents);
            }

            @Override
            public void afterActionCompleted(@NotNull String testName, @NotNull String contents) {
                if (testName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "afterActionCompleted"));
                }
                if (contents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "afterActionCompleted"));
                }
                LightQuickFixTestCase.this.afterActionCompleted(testName, contents);
            }

            @Override
            public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName) throws Exception {
                if (actionHint == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionHint", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "doAction"));
                }
                if (testFullPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFullPath", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "doAction"));
                }
                if (testName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "doAction"));
                }
                LightQuickFixTestCase.this.doAction(actionHint, testFullPath, testName);
            }

            @Override
            public void checkResultByFile(@NotNull String message, @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) throws Exception {
                if (message == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "checkResultByFile"));
                }
                if (expectedFilePath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedFilePath", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "checkResultByFile"));
                }
                LightQuickFixTestCase.this.checkResultByFile(message, expectedFilePath, ignoreTrailingSpaces);
            }

            @Override
            public IntentionAction findActionWithText(@NotNull String text) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "findActionWithText"));
                }
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(@NotNull IntentionAction action) {
                if (action == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "invoke"));
                }
                LightQuickFixTestCase.invoke(action);
            }

            @Override
            @NotNull
            public List<HighlightInfo> doHighlighting() {
                List list = LightQuickFixTestCase.this.doHighlighting();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "doHighlighting"));
                }
                return list;
            }

            @Override
            @NotNull
            public List<IntentionAction> getAvailableActions() {
                List<IntentionAction> list = LightQuickFixTestCase.this.getAvailableActions();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "getAvailableActions"));
                }
                return list;
            }

            @Override
            public void configureFromFileText(@NotNull String name, @NotNull String contents) throws IOException {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "configureFromFileText"));
                }
                if (contents == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1", "configureFromFileText"));
                }
                LightQuickFixTestCase.configureFromFileText((String)name, (String)contents, (boolean)true);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.getFile();
            }

            @Override
            public Project getProject() {
                return LightPlatformTestCase.getProject();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.bringRealEditorBack();
            }
        };
        if (quickFixTestCase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "createWrapper"));
        }
        return quickFixTestCase;
    }

    protected List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(LightQuickFixTestCase.getEditor(), LightQuickFixTestCase.getFile());
    }

    @NotNull
    public static List<IntentionAction> getAvailableActions(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getAvailableActions"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getAvailableActions"));
        }
        List list = CodeInsightTestFixtureImpl.getAvailableIntentions((Editor)editor, (PsiFile)file);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase", "getAvailableActions"));
        }
        return list;
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }
}

