/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExecutionResult
implements ExecutionResult {
    private final ExecutionConsole myConsole;
    private final ProcessHandler myProcessHandler;
    private AnAction[] myActions;
    private AnAction[] myRestartActions;

    public DefaultExecutionResult() {
        this.myRestartActions = AnAction.EMPTY_ARRAY;
        this.myConsole = null;
        this.myProcessHandler = null;
        this.myActions = AnAction.EMPTY_ARRAY;
    }

    public DefaultExecutionResult(@Nullable ExecutionConsole console, @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/DefaultExecutionResult", "<init>"));
        }
        this(console, processHandler, AnAction.EMPTY_ARRAY);
    }

    public DefaultExecutionResult(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/DefaultExecutionResult", "<init>"));
        }
        this(null, processHandler, AnAction.EMPTY_ARRAY);
    }

    public DefaultExecutionResult(ExecutionConsole console, @NotNull ProcessHandler processHandler, AnAction ... actions) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/execution/DefaultExecutionResult", "<init>"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/execution/DefaultExecutionResult", "<init>"));
        }
        this.myRestartActions = AnAction.EMPTY_ARRAY;
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myActions = actions;
    }

    @Override
    public ExecutionConsole getExecutionConsole() {
        return this.myConsole;
    }

    @Override
    @NotNull
    public AnAction[] getActions() {
        if (this.myActions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/DefaultExecutionResult", "getActions"));
        }
        return this.myActions;
    }

    public void setActions(AnAction ... actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/execution/DefaultExecutionResult", "setActions"));
        }
        this.myActions = actions;
    }

    @NotNull
    public AnAction[] getRestartActions() {
        if (this.myRestartActions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/DefaultExecutionResult", "getRestartActions"));
        }
        return this.myRestartActions;
    }

    public void setRestartActions(AnAction ... restartActions) {
        if (restartActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restartActions", "com/intellij/execution/DefaultExecutionResult", "setRestartActions"));
        }
        this.myRestartActions = restartActions;
    }

    @Deprecated
    @NotNull
    public AnAction[] getAdditionalStopActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/DefaultExecutionResult", "getAdditionalStopActions"));
        }
        return AnAction.EMPTY_ARRAY;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }
}

