/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.frameworks.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import java.net.MalformedURLException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAction {
    private static final Logger LOG = Logger.getInstance((String)AbstractAction.class.getName());
    private static final String SERVER_URL = Registry.get((String)"frameworks.download.libraries.server.url").asString();
    private final Pair<String, String>[] myParams;

    @SafeVarargs
    protected AbstractAction(Pair<String, String> ... params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/facet/frameworks/actions/AbstractAction", "<init>"));
        }
        this.myParams = params;
    }

    @NotNull
    public abstract String getActionName();

    @Nullable
    public URL getUrl() {
        String parameters = this.getParametersAsString();
        try {
            return new URL(SERVER_URL + "/" + this.getActionName() + (parameters.length() == 0 ? "" : "?" + parameters));
        }
        catch (MalformedURLException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    private String getParametersAsString() {
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < this.myParams.length; ++i2) {
            Pair<String, String> param = this.myParams[i2];
            if (i2 > 0) {
                buffer.append("&");
            }
            buffer.append((String)param.first);
            buffer.append("=");
            buffer.append((String)param.second);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/frameworks/actions/AbstractAction", "getParametersAsString"));
        }
        return string;
    }
}

