/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.util.InstanceofQuery;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class AnnotatedElementsSearch
extends ExtensibleQueryFactory<PsiModifierListOwner, Parameters> {
    public static final ExtensionPointName<QueryExecutor> EP_NAME = ExtensionPointName.create((String)"com.intellij.annotatedElementsSearch");
    public static final AnnotatedElementsSearch INSTANCE = new AnnotatedElementsSearch();

    @SafeVarargs
    public static <T extends PsiModifierListOwner> Query<T> searchElements(@NotNull PsiClass annotationClass, @NotNull SearchScope scope, Class<? extends T> ... types) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchElements"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchElements"));
        }
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchElements"));
        }
        return AnnotatedElementsSearch.searchElements(new Parameters(annotationClass, scope, types));
    }

    @NotNull
    public static Query<? extends PsiModifierListOwner> searchElements(Parameters parameters) {
        InstanceofQuery<? extends PsiModifierListOwner> instanceofQuery = new InstanceofQuery<PsiModifierListOwner>(INSTANCE.createQuery(parameters), parameters.getTypes());
        if (instanceofQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchElements"));
        }
        return instanceofQuery;
    }

    public static Query<PsiClass> searchPsiClasses(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiClasses"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiClasses"));
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiClass.class);
    }

    public static Query<PsiMethod> searchPsiMethods(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiMethods"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiMethods"));
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiMethod.class);
    }

    public static Query<PsiMember> searchPsiMembers(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiMembers"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiMembers"));
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiMember.class);
    }

    public static Query<PsiField> searchPsiFields(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiFields"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiFields"));
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiField.class);
    }

    public static Query<PsiParameter> searchPsiParameters(@NotNull PsiClass annotationClass, @NotNull SearchScope scope) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiParameters"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/search/searches/AnnotatedElementsSearch", "searchPsiParameters"));
        }
        return AnnotatedElementsSearch.searchElements(annotationClass, scope, PsiParameter.class);
    }

    public static class Parameters {
        private final PsiClass myAnnotationClass;
        private final SearchScope myScope;
        private final Class<? extends PsiModifierListOwner>[] myTypes;
        private final boolean myApproximate;

        @SafeVarargs
        public Parameters(PsiClass annotationClass, SearchScope scope, Class<? extends PsiModifierListOwner> ... types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/search/searches/AnnotatedElementsSearch$Parameters", "<init>"));
            }
            this(annotationClass, scope, false, types);
        }

        @SafeVarargs
        public Parameters(PsiClass annotationClass, SearchScope scope, boolean approximate, Class<? extends PsiModifierListOwner> ... types) {
            if (types == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/psi/search/searches/AnnotatedElementsSearch$Parameters", "<init>"));
            }
            this.myAnnotationClass = annotationClass;
            this.myScope = scope;
            this.myTypes = types;
            this.myApproximate = approximate;
        }

        public PsiClass getAnnotationClass() {
            return this.myAnnotationClass;
        }

        public SearchScope getScope() {
            return this.myScope;
        }

        public Class<? extends PsiModifierListOwner>[] getTypes() {
            return this.myTypes;
        }

        public boolean isApproximate() {
            return this.myApproximate;
        }
    }
}

