/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.AnchorableComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.border.IdeaTitledBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class OptionGroup
implements PanelWithAnchor {
    private String myTitle;
    private List myOptions;
    private List<Boolean> myIsShifted;
    private JComponent anchor;

    public OptionGroup(@Nullable String title) {
        this.myTitle = title;
        this.myOptions = new ArrayList();
        this.myIsShifted = new ArrayList<Boolean>();
    }

    public OptionGroup() {
        this(null);
    }

    public void add(JComponent component) {
        this.add(component, false);
    }

    public void add(JComponent component, boolean indented) {
        this.myOptions.add(component);
        this.myIsShifted.add(indented);
    }

    public void add(JComponent leftComponent, JComponent rightComponent) {
        this.add(leftComponent, rightComponent, false);
    }

    public void add(JComponent leftComponent, JComponent rightComponent, boolean indented) {
        this.myOptions.add(new Pair((Object)leftComponent, (Object)rightComponent));
        this.myIsShifted.add(indented);
    }

    public JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        for (int i2 = 0; i2 < this.myOptions.size(); ++i2) {
            int leftInset = Boolean.TRUE.equals(this.myIsShifted.get(i2)) ? 20 : 0;
            int topInset = i2 == 0 ? 0 : 4;
            int rightInset = 10;
            Object option = this.myOptions.get(i2);
            if (option instanceof JComponent) {
                JComponent component = (JComponent)option;
                panel.add((Component)component, new GridBagConstraints(0, i2, 0, 1, 1.0, 0.0, 17, OptionGroup.getFill(component), new Insets(topInset, leftInset, 0, 0), 0, 0));
                continue;
            }
            Pair pair = (Pair)option;
            JComponent firstComponent = (JComponent)pair.first;
            panel.add((Component)firstComponent, new GridBagConstraints(0, i2, 1, 1, 1.0, 0.0, 17, OptionGroup.getFill(firstComponent), new Insets(topInset, leftInset, 0, 0), 0, 0));
            JComponent secondComponent = (JComponent)pair.second;
            panel.add((Component)secondComponent, new GridBagConstraints(1, i2, 1, 1, 1.0, 0.0, 13, 2, new Insets(topInset, 10, 0, 0), 0, 0));
        }
        JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(0, 0));
        panel.add((Component)p, new GridBagConstraints(0, this.myOptions.size(), 0, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.myTitle != null) {
            IdeaTitledBorder titledBorder = IdeBorderFactory.createTitledBorder(this.myTitle, true);
            panel.setBorder(titledBorder);
            titledBorder.acceptMinimumSize(panel);
        }
        return panel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.anchor = anchor;
        for (Object o : this.myOptions) {
            if (!(o instanceof Pair) || !(((Pair)o).getFirst() instanceof AnchorableComponent)) continue;
            ((AnchorableComponent)((Pair)o).getFirst()).setAnchor(anchor);
        }
    }

    private static int getFill(JComponent component) {
        if (component instanceof JCheckBox) {
            return 0;
        }
        return 2;
    }

    public JComponent[] getComponents() {
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        for (Object o : this.myOptions) {
            if (o instanceof Pair) {
                components.add((JComponent)((Pair)o).first);
                components.add((JComponent)((Pair)o).second);
                continue;
            }
            components.add((JComponent)o);
        }
        return components.toArray(new JComponent[components.size()]);
    }

    @Nullable
    public JComponent findAnchor() {
        double maxWidth = -1.0;
        JComponent ans = null;
        for (Object o : this.myOptions) {
            if (!(o instanceof Pair) || !(((Pair)o).getFirst() instanceof AnchorableComponent) || !(((JComponent)((Pair)o).getFirst()).getPreferredSize().getWidth() > maxWidth)) continue;
            maxWidth = ((JComponent)((Pair)o).getFirst()).getPreferredSize().getWidth();
            ans = (JComponent)((Pair)o).getFirst();
        }
        return ans;
    }
}

