/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InnerClassConstructorCallsLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "backend.jvm"})
public final class InnerClassConstructorCallsLowering
implements BodyLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrBody irBody) {
        Intrinsics.checkParameterIsNotNull((Object)irBody, (String)"irBody");
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new IrElementTransformerVoid(this){
            final /* synthetic */ InnerClassConstructorCallsLowering this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                CallableDescriptor callableDescriptor = expression2.getDescriptor();
                if (!(callableDescriptor instanceof ClassConstructorDescriptor)) {
                    callableDescriptor = null;
                }
                ClassConstructorDescriptor classConstructorDescriptor = (ClassConstructorDescriptor)callableDescriptor;
                if (classConstructorDescriptor == null) {
                    return expression2;
                }
                ClassConstructorDescriptor callee = classConstructorDescriptor;
                if (!callee.getConstructedClass().isInner()) {
                    return expression2;
                }
                ClassConstructorDescriptor newCallee = this.this$0.getContext().getSpecialDescriptorsFactory().getInnerClassConstructorWithOuterThisParameter(callee);
                IrCallImpl newCall2 = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), newCallee, null, expression2.getOrigin(), null, 32, null);
                newCall2.putValueArgument(0, dispatchReceiver);
                int n = 1;
                int n2 = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n <= n2) {
                    while (true) {
                        void i;
                        newCall2.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n2) break;
                        ++i;
                    }
                }
                return newCall2;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public IrExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    return expression2;
                }
                IrExpression dispatchReceiver = irExpression;
                ClassConstructorDescriptor callee = expression2.getDescriptor();
                if (!callee.getConstructedClass().isInner()) {
                    return expression2;
                }
                ClassConstructorDescriptor newCallee = this.this$0.getContext().getSpecialDescriptorsFactory().getInnerClassConstructorWithOuterThisParameter(callee);
                IrDelegatingConstructorCallImpl newCall2 = new IrDelegatingConstructorCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), newCallee, null);
                newCall2.putValueArgument(0, dispatchReceiver);
                int n = 1;
                int n2 = CollectionsKt.getLastIndex(newCallee.getValueParameters());
                if (n <= n2) {
                    while (true) {
                        void i;
                        newCall2.putValueArgument((int)i, expression2.getValueArgument((int)(i - true)));
                        if (i == n2) break;
                        ++i;
                    }
                }
                return newCall2;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InnerClassConstructorCallsLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

