/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ConflictUsageInfo;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\nH\u0014J\u001b\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\f2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0013H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveFilesWithDeclarationsProcessor;", "Lcom/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "targetFileName", "", "searchInComments", "", "searchInNonJavaFiles", "moveCallback", "Lcom/intellij/refactoring/move/MoveCallback;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/psi/PsiDirectory;Ljava/lang/String;ZZLcom/intellij/refactoring/move/MoveCallback;)V", "getCommandName", "performRefactoring", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "([Lcom/intellij/usageView/UsageInfo;)V", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "renameFileTemporarily", "idea"})
public final class MoveFilesWithDeclarationsProcessor
extends MoveFilesOrDirectoriesProcessor {
    private final List<KtFile> sourceFiles;
    private final PsiDirectory targetDirectory;
    private final String targetFileName;

    @NotNull
    protected String getCommandName() {
        return this.targetFileName != null ? "Move " + ((KtFile)CollectionsKt.single(this.sourceFiles)).getName() : "Move";
    }

    /*
     * WARNING - void declaration
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        void $receiver$iv;
        void usagesToProcess;
        Object conflictUsage;
        void conflictUsages;
        Intrinsics.checkParameterIsNotNull(refUsages, (String)"refUsages");
        UsageInfo[] usages2 = (UsageInfo[])refUsages.get();
        Object $receiver$iv2 = usages2;
        ArrayList<Object> first$iv = new ArrayList<Object>();
        ArrayList<Object> second$iv = new ArrayList<Object>();
        for (int i = 0; i < ((Object[])$receiver$iv2).length; ++i) {
            Object element$iv = $receiver$iv2[i];
            UsageInfo it = (UsageInfo)element$iv;
            if (it instanceof ConflictUsageInfo) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair2 = new Pair(first$iv, second$iv);
        List list2 = (List)pair2.component1();
        List list3 = (List)pair2.component2();
        pair2 = null;
        Object object = $receiver$iv2 = (Collection)conflictUsages;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Object thisCollection$iv = object;
        UsageInfo[] usageInfoArray = thisCollection$iv.toArray(new UsageInfo[thisCollection$iv.size()]);
        if (usageInfoArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        UsageInfo[] distinctConflictUsages = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfoArray);
        MultiMap conflicts2 = new MultiMap();
        for (int $i$f$toTypedArray = 0; $i$f$toTypedArray < distinctConflictUsages.length; ++$i$f$toTypedArray) {
            Object object2 = conflictUsage = distinctConflictUsages[$i$f$toTypedArray];
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.ConflictUsageInfo");
            }
            conflicts2.putValues((Object)conflictUsage.getElement(), ((ConflictUsageInfo)((Object)object2)).getMessages());
        }
        conflictUsage = (Collection)usagesToProcess;
        Ref<UsageInfo[]> ref = refUsages;
        void v3 = $receiver$iv;
        if (v3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        void thisCollection$iv2 = v3;
        UsageInfo[] usageInfoArray2 = thisCollection$iv2.toArray(new UsageInfo[thisCollection$iv2.size()]);
        if (usageInfoArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        UsageInfo[] usageInfoArray3 = usageInfoArray2;
        ref.set((Object)usageInfoArray3);
        return this.showConflicts(conflicts2, usages2);
    }

    private final void renameFileTemporarily() {
        if (this.targetFileName == null || this.targetDirectory.findFile(this.targetFileName) == null) {
            return;
        }
        KtFile sourceFile = (KtFile)CollectionsKt.single(this.sourceFiles);
        String temporaryName2 = UniqueNameGenerator.generateUniqueName((String)"temp", (String)"", (String)".kt", (Condition)((Condition)new Condition<String>(sourceFile){
            final /* synthetic */ KtFile $sourceFile;

            public final boolean value(String it) {
                PsiDirectory psiDirectory = this.$sourceFile.getContainingDirectory();
                if (psiDirectory == null) {
                    Intrinsics.throwNpe();
                }
                return psiDirectory.findFile(it) == null;
            }
            {
                this.$sourceFile = ktFile;
            }
        }));
        sourceFile.setName(temporaryName2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        boolean needTemporaryRename;
        Intrinsics.checkParameterIsNotNull((Object)usages2, (String)"usages");
        boolean bl = needTemporaryRename = this.targetFileName != null && this.targetDirectory.findFile(this.targetFileName) != null;
        if (needTemporaryRename) {
            this.renameFileTemporarily();
        }
        try {
            super.performRefactoring(usages2);
        }
        finally {
            if (needTemporaryRename) {
                KtFile ktFile = (KtFile)CollectionsKt.single(this.sourceFiles);
                String string = this.targetFileName;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                ktFile.setName(string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public MoveFilesWithDeclarationsProcessor(@NotNull Project project, @NotNull List<? extends KtFile> sourceFiles, @NotNull PsiDirectory targetDirectory2, @Nullable String targetFileName, boolean searchInComments, boolean searchInNonJavaFiles, @Nullable MoveCallback moveCallback) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkParameterIsNotNull((Object)targetDirectory2, (String)"targetDirectory");
        Collection collection = sourceFiles;
        Project project2 = project;
        MoveFilesWithDeclarationsProcessor moveFilesWithDeclarationsProcessor = this;
        void thisCollection$iv = $receiver$iv;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[thisCollection$iv.size()]);
        if (psiElementArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PsiElement[] psiElementArray2 = psiElementArray;
        super(project2, psiElementArray2, targetDirectory2, true, searchInComments, searchInNonJavaFiles, moveCallback, EmptyRunnable.INSTANCE);
        this.sourceFiles = sourceFiles;
        this.targetDirectory = targetDirectory2;
        this.targetFileName = targetFileName;
    }
}

