/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorWithRelation;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001a\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "checkClassHeader", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkDeclarationWithVisibility", "modifierListOwner", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "checkFunction", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkMemberReceiver", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "memberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "checkParameterBounds", "checkProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkSupertypes", "checkTypeAlias", "", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "frontend"})
public final class ExposedVisibilityChecker {
    private final DiagnosticSink trace;

    public final boolean checkClassHeader(@NotNull KtClassOrObject klass2, @NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
        Intrinsics.checkParameterIsNotNull((Object)classDescriptor, (String)"classDescriptor");
        boolean result2 = this.checkSupertypes(klass2, classDescriptor);
        result2 &= this.checkParameterBounds(klass2, classDescriptor);
        KtPrimaryConstructor ktPrimaryConstructor = klass2.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return result2;
        }
        KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return result2;
        }
        ClassConstructorDescriptor constructorDescriptor = classConstructorDescriptor;
        KtFunction ktFunction = constructor2;
        ClassConstructorDescriptor classConstructorDescriptor2 = constructorDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor2, (String)"constructorDescriptor");
        return result2 & ExposedVisibilityChecker.checkFunction$default(this, ktFunction, classConstructorDescriptor2, null, 4, null);
    }

    public final boolean checkDeclarationWithVisibility(@NotNull KtModifierListOwner modifierListOwner, @NotNull DeclarationDescriptorWithVisibility descriptor2, @NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull((Object)modifierListOwner, (String)"modifierListOwner");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        return modifierListOwner instanceof KtFunction && descriptor2 instanceof FunctionDescriptor ? this.checkFunction((KtFunction)modifierListOwner, (FunctionDescriptor)descriptor2, visibility) : (modifierListOwner instanceof KtProperty && descriptor2 instanceof PropertyDescriptor ? this.checkProperty((KtProperty)modifierListOwner, (PropertyDescriptor)descriptor2, visibility) : true);
    }

    public final void checkTypeAlias(@NotNull KtTypeAlias typeAlias2, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)typeAlias2, (String)"typeAlias");
        Intrinsics.checkParameterIsNotNull((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        SimpleType expandedType = typeAliasDescriptor.getExpandedType();
        if (expandedType.isError()) {
            return;
        }
        EffectiveVisibility typeAliasVisibility = EffectiveVisibilityKt.effectiveVisibility$default(typeAliasDescriptor, null, false, 3, null);
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(expandedType, typeAliasVisibility);
        if (restricting != null) {
            PsiElement psiElement2 = typeAlias2.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = typeAlias2;
            }
            this.trace.report(Errors.EXPOSED_TYPEALIAS_EXPANDED_TYPE.on(psiElement2, typeAliasVisibility, restricting, restricting.effectiveVisibility()));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkFunction(@NotNull KtFunction function2, @NotNull FunctionDescriptor functionDescriptor2, @NotNull Visibility visibility) {
        void result2;
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        EffectiveVisibility functionVisibility = EffectiveVisibilityKt.effectiveVisibility$default(functionDescriptor2, visibility, false, 2, null);
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        if (!(function2 instanceof KtConstructor)) {
            DescriptorWithRelation restricting;
            KotlinType kotlinType = functionDescriptor2.getReturnType();
            DescriptorWithRelation descriptorWithRelation = restricting = kotlinType != null ? EffectiveVisibilityKt.leastPermissiveDescriptor(kotlinType, functionVisibility) : null;
            if (restricting != null) {
                PsiElement psiElement2 = function2.getNameIdentifier();
                if (psiElement2 == null) {
                    psiElement2 = function2;
                }
                this.trace.report(Errors.EXPOSED_FUNCTION_RETURN_TYPE.on(psiElement2, functionVisibility, restricting, restricting.effectiveVisibility()));
                result2.element = false;
            }
        }
        Iterable $receiver$iv = functionDescriptor2.getValueParameters();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void parameterDescriptor;
            int n = index$iv++;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv;
            int i = n;
            DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(parameterDescriptor.getType(), functionVisibility);
            if (restricting == null || i >= function2.getValueParameters().size()) continue;
            this.trace.report(Errors.EXPOSED_PARAMETER_TYPE.on((KtParameter)((PsiElement)function2.getValueParameters().get(i)), functionVisibility, restricting, restricting.effectiveVisibility()));
            result2.element = false;
        }
        return result2.element & this.checkMemberReceiver(function2.getReceiverTypeReference(), functionDescriptor2);
    }

    public static /* bridge */ /* synthetic */ boolean checkFunction$default(ExposedVisibilityChecker exposedVisibilityChecker, KtFunction ktFunction, FunctionDescriptor functionDescriptor2, Visibility visibility, int n, Object object) {
        if ((n & 4) != 0) {
            Visibility visibility2 = functionDescriptor2.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"functionDescriptor.visibility");
            visibility = visibility2;
        }
        return exposedVisibilityChecker.checkFunction(ktFunction, functionDescriptor2, visibility);
    }

    public final boolean checkProperty(@NotNull KtProperty property2, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Visibility visibility) {
        Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)propertyDescriptor, (String)"propertyDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)visibility, (String)"visibility");
        EffectiveVisibility propertyVisibility = EffectiveVisibilityKt.effectiveVisibility$default(propertyDescriptor, visibility, false, 2, null);
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(propertyDescriptor.getType(), propertyVisibility);
        boolean result2 = true;
        if (restricting != null) {
            PsiElement psiElement2 = property2.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = property2;
            }
            this.trace.report(Errors.EXPOSED_PROPERTY_TYPE.on(psiElement2, propertyVisibility, restricting, restricting.effectiveVisibility()));
            result2 = false;
        }
        return result2 & this.checkMemberReceiver(property2.getReceiverTypeReference(), propertyDescriptor);
    }

    public static /* bridge */ /* synthetic */ boolean checkProperty$default(ExposedVisibilityChecker exposedVisibilityChecker, KtProperty ktProperty, PropertyDescriptor propertyDescriptor, Visibility visibility, int n, Object object) {
        if ((n & 4) != 0) {
            Visibility visibility2 = propertyDescriptor.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility2, (String)"propertyDescriptor.visibility");
            visibility = visibility2;
        }
        return exposedVisibilityChecker.checkProperty(ktProperty, propertyDescriptor, visibility);
    }

    private final boolean checkMemberReceiver(KtTypeReference typeReference, CallableMemberDescriptor memberDescriptor) {
        if (typeReference == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = memberDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return true;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor2 = receiverParameterDescriptor;
        EffectiveVisibility memberVisibility = EffectiveVisibilityKt.effectiveVisibility$default(memberDescriptor, null, false, 3, null);
        DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(receiverParameterDescriptor2.getType(), memberVisibility);
        if (restricting != null) {
            this.trace.report(Errors.EXPOSED_RECEIVER_TYPE.on((KtTypeReference)((PsiElement)typeReference), memberVisibility, restricting, restricting.effectiveVisibility()));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkSupertypes(KtClassOrObject klass2, ClassDescriptor classDescriptor) {
        void result2;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility$default(classDescriptor, false, 1, null);
        boolean isInterface = Intrinsics.areEqual((Object)((Object)classDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE));
        List<KtSuperTypeListEntry> delegationList = klass2.getSuperTypeListEntries();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        Iterable $receiver$iv = classDescriptor.getTypeConstructor().getSupertypes();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            DescriptorWithRelation restricting;
            ClassDescriptor superDescriptor;
            void superType;
            int n = index$iv++;
            KotlinType kotlinType = (KotlinType)item$iv;
            int i = n;
            if (i >= delegationList.size()) {
                return result2.element;
            }
            if (TypeUtils.getClassDescriptor((KotlinType)superType) == null) {
                continue;
            }
            boolean superIsInterface = Intrinsics.areEqual((Object)((Object)superDescriptor.getKind()), (Object)((Object)ClassKind.INTERFACE));
            if (superIsInterface != isInterface || (restricting = EffectiveVisibilityKt.leastPermissiveDescriptor((KotlinType)superType, classVisibility)) == null) continue;
            if (isInterface) {
                this.trace.report(Errors.EXPOSED_SUPER_INTERFACE.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, restricting, restricting.effectiveVisibility()));
            } else {
                this.trace.report(Errors.EXPOSED_SUPER_CLASS.on((KtSuperTypeListEntry)((PsiElement)delegationList.get(i)), classVisibility, restricting, restricting.effectiveVisibility()));
            }
            result2.element = false;
        }
        return result2.element;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkParameterBounds(KtClassOrObject klass2, ClassDescriptor classDescriptor) {
        void result2;
        EffectiveVisibility classVisibility = EffectiveVisibilityKt.effectiveVisibility$default(classDescriptor, false, 1, null);
        List<KtTypeParameter> typeParameterList = klass2.getTypeParameters();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = true;
        Iterable $receiver$iv = classDescriptor.getDeclaredTypeParameters();
        int index$iv = 0;
        block0: for (Object item$iv : $receiver$iv) {
            void typeParameterDescriptor;
            int n = index$iv++;
            TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item$iv;
            int i = n;
            if (i >= typeParameterList.size()) {
                return result2.element;
            }
            for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                DescriptorWithRelation restricting = EffectiveVisibilityKt.leastPermissiveDescriptor(upperBound, classVisibility);
                if (restricting == null) continue;
                this.trace.report(Errors.EXPOSED_TYPE_PARAMETER_BOUND.on((KtTypeParameter)((PsiElement)typeParameterList.get(i)), classVisibility, restricting, restricting.effectiveVisibility()));
                result2.element = false;
                continue block0;
            }
        }
        return result2.element;
    }

    public ExposedVisibilityChecker(@NotNull DiagnosticSink trace) {
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        this.trace = trace;
    }

    public /* synthetic */ ExposedVisibilityChecker(DiagnosticSink diagnosticSink2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            DiagnosticSink diagnosticSink3 = DiagnosticSink.DO_NOTHING;
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnosticSink3, (String)"DO_NOTHING");
            diagnosticSink2 = diagnosticSink3;
        }
        this(diagnosticSink2);
    }

    public ExposedVisibilityChecker() {
        this(null, 1, null);
    }
}

