/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;

public class DataFlowInfoForArgumentsImpl
extends MutableDataFlowInfoForArguments {
    @Nullable
    private Map<ValueArgument, DataFlowInfo> infoMap;
    @Nullable
    private Map<ValueArgument, ValueArgument> nextArgument;
    @Nullable
    private DataFlowInfo resultInfo;

    public DataFlowInfoForArgumentsImpl(@NotNull DataFlowInfo initialInfo, @NotNull Call call2) {
        if (initialInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialInfo", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "<init>"));
        }
        if (call2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "<init>"));
        }
        super(initialInfo);
        this.infoMap = null;
        this.nextArgument = null;
        this.initNextArgMap(call2.getValueArguments());
    }

    private void initNextArgMap(@NotNull List<? extends ValueArgument> valueArguments2) {
        if (valueArguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArguments", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "initNextArgMap"));
        }
        Iterator<? extends ValueArgument> iterator2 = valueArguments2.iterator();
        ValueArgument prev2 = null;
        while (iterator2.hasNext()) {
            ValueArgument argument2 = iterator2.next();
            if (prev2 != null) {
                if (this.nextArgument == null) {
                    this.nextArgument = new HashMap<ValueArgument, ValueArgument>();
                }
                this.nextArgument.put(prev2, argument2);
            }
            prev2 = argument2;
        }
    }

    @Override
    @NotNull
    public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
        DataFlowInfo infoForArgument;
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
        }
        DataFlowInfo dataFlowInfo = infoForArgument = this.infoMap == null ? null : this.infoMap.get(valueArgument);
        if (infoForArgument == null) {
            DataFlowInfo dataFlowInfo2 = this.initialDataFlowInfo;
            if (dataFlowInfo2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
            }
            return dataFlowInfo2;
        }
        DataFlowInfo dataFlowInfo3 = this.initialDataFlowInfo.and(infoForArgument);
        if (dataFlowInfo3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getInfo"));
        }
        return dataFlowInfo3;
    }

    @Override
    public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
        ValueArgument next2;
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "updateInfo"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "updateInfo"));
        }
        ValueArgument valueArgument2 = next2 = this.nextArgument == null ? null : this.nextArgument.get(valueArgument);
        if (next2 != null) {
            if (this.infoMap == null) {
                this.infoMap = new HashMap<ValueArgument, DataFlowInfo>();
            }
            this.infoMap.put(next2, dataFlowInfo);
            return;
        }
        this.resultInfo = dataFlowInfo;
    }

    @Override
    @NotNull
    public DataFlowInfo getResultInfo() {
        if (this.resultInfo == null) {
            DataFlowInfo dataFlowInfo = this.initialDataFlowInfo;
            if (dataFlowInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getResultInfo"));
            }
            return dataFlowInfo;
        }
        DataFlowInfo dataFlowInfo = this.initialDataFlowInfo.and(this.resultInfo);
        if (dataFlowInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArgumentsImpl", "getResultInfo"));
        }
        return dataFlowInfo;
    }
}

