/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.common;

import java.io.File;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DaemonWithMetadata;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001c\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\n\u001a\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00012\b\b\u0002\u0010\u0013\u001a\u00020\u0001\u001a-\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u00032\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017H\u0082\b\u001a\\\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u001a\b\u0002\u0010!\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\"0\u00172\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00190\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u0003X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE", "", "MAX_PORT_NUMBER", "", "getMAX_PORT_NUMBER", "()I", "ORPHANED_RUN_FILE_AGE_THRESHOLD_MS", "", "validFlagFileKeywordChars", "makeAutodeletingFlagFile", "Ljava/io/File;", "keyword", "baseDir", "makePortFromRunFilenameExtractor", "Lkotlin/Function1;", "digest", "makeRunFilenameString", "timestamp", "port", "escapeSequence", "tryConnectToDaemon", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "report", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "", "walkDaemons", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/daemon/common/DaemonWithMetadata;", "registryDir", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "fileToCompareTimestamp", "filter", "", "compiler-deps"})
public final class ClientUtilsKt {
    private static final int MAX_PORT_NUMBER = 65535;
    private static final long ORPHANED_RUN_FILE_AGE_THRESHOLD_MS = 1000000L;
    private static final String validFlagFileKeywordChars = "abcdefghijklmnopqrstuvwxyz0123456789-_";
    @NotNull
    public static final String LOG_PREFIX_ASSUMING_OTHER_DAEMONS_HAVE = "Assuming other daemons have";

    public static final int getMAX_PORT_NUMBER() {
        return MAX_PORT_NUMBER;
    }

    @NotNull
    public static final String makeRunFilenameString(@NotNull String timestamp, @NotNull String digest, @NotNull String port, @NotNull String escapeSequence) {
        if (timestamp == null) {
            ClientUtilsKt.$$$reportNull$$$0(0);
        }
        if (digest == null) {
            ClientUtilsKt.$$$reportNull$$$0(1);
        }
        if (port == null) {
            ClientUtilsKt.$$$reportNull$$$0(2);
        }
        if (escapeSequence == null) {
            ClientUtilsKt.$$$reportNull$$$0(3);
        }
        Intrinsics.checkParameterIsNotNull(timestamp, "timestamp");
        Intrinsics.checkParameterIsNotNull(digest, "digest");
        Intrinsics.checkParameterIsNotNull(port, "port");
        Intrinsics.checkParameterIsNotNull(escapeSequence, "escapeSequence");
        String string = DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + escapeSequence + "." + timestamp + escapeSequence + "." + digest + escapeSequence + "." + port + escapeSequence + ".run";
        if (string == null) {
            ClientUtilsKt.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String makeRunFilenameString$default(String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 8) != 0) {
            string4 = "";
        }
        return ClientUtilsKt.makeRunFilenameString(string, string2, string3, string4);
    }

    @NotNull
    public static final Function1<String, Integer> makePortFromRunFilenameExtractor(@NotNull String digest) {
        if (digest == null) {
            ClientUtilsKt.$$$reportNull$$$0(5);
        }
        Intrinsics.checkParameterIsNotNull(digest, "digest");
        String string = ClientUtilsKt.makeRunFilenameString("[0-9TZ:\\.\\+-]+", digest, "(\\d+)", "\\");
        Regex regex = new Regex(string);
        Function1 function1 = new Function1<String, Integer>(regex){
            final /* synthetic */ Regex $regex;

            @Nullable
            public final Integer invoke(@NotNull String it) {
                Integer n;
                if (it == null) {
                    makePortFromRunFilenameExtractor.1.$$$reportNull$$$0(0);
                }
                Intrinsics.checkParameterIsNotNull(it, "it");
                Object object = Regex.find$default(this.$regex, it, 0, 2, null);
                if (object != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = ((MatchGroup)object).getValue()) != null) {
                    Object object2 = object;
                    n = Integer.parseInt((String)object2);
                } else {
                    n = null;
                }
                return n;
            }
            {
                this.$regex = regex;
                super(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "org/jetbrains/kotlin/daemon/common/ClientUtilsKt$makePortFromRunFilenameExtractor$1", "invoke"));
            }
        };
        if (function1 == null) {
            ClientUtilsKt.$$$reportNull$$$0(6);
        }
        return function1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<DaemonWithMetadata> walkDaemons(@NotNull File registryDir, @NotNull CompilerId compilerId, @NotNull File fileToCompareTimestamp, @NotNull Function2<? super File, ? super Integer, Boolean> filter, @NotNull Function2<? super DaemonReportCategory, ? super String, Unit> report) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        if (registryDir == null) {
            ClientUtilsKt.$$$reportNull$$$0(7);
        }
        if (compilerId == null) {
            ClientUtilsKt.$$$reportNull$$$0(8);
        }
        if (fileToCompareTimestamp == null) {
            ClientUtilsKt.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            ClientUtilsKt.$$$reportNull$$$0(10);
        }
        if (report == null) {
            ClientUtilsKt.$$$reportNull$$$0(11);
        }
        Intrinsics.checkParameterIsNotNull(registryDir, "registryDir");
        Intrinsics.checkParameterIsNotNull(compilerId, "compilerId");
        Intrinsics.checkParameterIsNotNull(fileToCompareTimestamp, "fileToCompareTimestamp");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Intrinsics.checkParameterIsNotNull(report, "report");
        Iterable iterable = $receiver$iv = (Iterable)compilerId.getCompilerClasspath();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string2 = new File((String)it).getAbsolutePath();
            collection.add(string2);
        }
        String classPathDigest = DaemonParamsKt.toHexString(DaemonParamsKt.distinctStringsDigest((List)destination$iv$iv));
        Function1<String, Integer> portExtractor = ClientUtilsKt.makePortFromRunFilenameExtractor(classPathDigest);
        Sequence<DaemonWithMetadata> sequence = SequencesKt.mapNotNull(SequencesKt.filter(SequencesKt.map(FilesKt.walk$default(registryDir, null, 1, null), (Function1)new Function1<File, Pair<? extends File, ? extends Integer>>(portExtractor){
            final /* synthetic */ Function1 $portExtractor;

            @NotNull
            public final Pair<File, Integer> invoke(@NotNull File it) {
                if (it == null) {
                    walkDaemons.3.$$$reportNull$$$0(0);
                }
                Intrinsics.checkParameterIsNotNull(it, "it");
                String string = it.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "it.name");
                Pair<File, Integer> pair = new Pair<File, Integer>(it, (Integer)this.$portExtractor.invoke(string));
                if (pair == null) {
                    walkDaemons.3.$$$reportNull$$$0(1);
                }
                return pair;
            }
            {
                this.$portExtractor = function1;
                super(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "it";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/daemon/common/ClientUtilsKt$walkDaemons$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/daemon/common/ClientUtilsKt$walkDaemons$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "invoke";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }), (Function1)new Function1<Pair<? extends File, ? extends Integer>, Boolean>(filter){
            final /* synthetic */ Function2 $filter;

            public final boolean invoke(@NotNull Pair<? extends File, Integer> $file_port) {
                if ($file_port == null) {
                    walkDaemons.4.$$$reportNull$$$0(0);
                }
                Intrinsics.checkParameterIsNotNull($file_port, "<name for destructuring parameter 0>");
                File file = $file_port.component1();
                Integer port = $file_port.component2();
                return port != null && (Boolean)this.$filter.invoke(file, port) != false;
            }
            {
                this.$filter = function2;
                super(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "$file_port", "org/jetbrains/kotlin/daemon/common/ClientUtilsKt$walkDaemons$4", "invoke"));
            }
        }), (Function1)new Function1<Pair<? extends File, ? extends Integer>, DaemonWithMetadata>(fileToCompareTimestamp, report){
            final /* synthetic */ File $fileToCompareTimestamp;
            final /* synthetic */ Function2 $report;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final DaemonWithMetadata invoke(@NotNull Pair<? extends File, Integer> $file_port) {
                CompileService compileService;
                CompileService daemon;
                long relativeAge;
                File file;
                block18: {
                    CompileService compileService2;
                    block17: {
                        int n;
                        Integer port;
                        if ($file_port == null) {
                            walkDaemons.5.$$$reportNull$$$0(0);
                        }
                        Intrinsics.checkParameterIsNotNull($file_port, "<name for destructuring parameter 0>");
                        file = $file_port.component1();
                        Integer n2 = port = $file_port.component2();
                        if (n2 == null) {
                            Intrinsics.throwNpe();
                        }
                        int n3 = n = 1 <= (n = n2.intValue()) && n <= ClientUtilsKt.getMAX_PORT_NUMBER() - 1 ? 1 : 0;
                        if (_Assertions.ENABLED && n == 0) {
                            String string = "Assertion failed";
                            throw (Throwable)((Object)new AssertionError((Object)string));
                        }
                        relativeAge = this.$fileToCompareTimestamp.lastModified() - file.lastModified();
                        this.$report.invoke(DaemonReportCategory.DEBUG, "found daemon on port " + port + " (" + relativeAge + " ms old), trying to connect");
                        int n4 = port;
                        Function2 report$iv = this.$report;
                        try {
                            Remote daemon$iv;
                            void port$iv;
                            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), (int)port$iv, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
                            Remote remote = daemon$iv = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
                            if (Intrinsics.areEqual(remote, null)) {
                                report$iv.invoke(DaemonReportCategory.EXCEPTION, "daemon not found");
                                break block17;
                            }
                            if (remote instanceof CompileService) {
                                compileService2 = (CompileService)daemon$iv;
                                break block18;
                            }
                            report$iv.invoke(DaemonReportCategory.EXCEPTION, "Unable to cast compiler service, actual class received: " + daemon$iv.getClass().getName());
                        }
                        catch (Throwable e$iv) {
                            Object object;
                            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
                            Object object2 = e$iv.getCause();
                            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                                object2 = object = e$iv.getMessage();
                            }
                            if (object2 == null) {
                                object = "unknown error";
                            }
                            report$iv.invoke(DaemonReportCategory.EXCEPTION, stringBuilder.append(object).toString());
                        }
                    }
                    compileService2 = daemon = null;
                }
                if (daemon == null) {
                    if (relativeAge - 1000000L <= (long)0) {
                        this.$report.invoke(DaemonReportCategory.DEBUG, "found fresh run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), but no daemon, ignoring it");
                    } else {
                        this.$report.invoke(DaemonReportCategory.DEBUG, "found seemingly orphaned run file '" + file.getAbsolutePath() + "' (" + relativeAge + " ms old), deleting it");
                        if (!file.delete()) {
                            this.$report.invoke(DaemonReportCategory.INFO, "WARNING: unable to delete seemingly orphaned file '" + file.getAbsolutePath() + "', cleanup recommended");
                        }
                    }
                }
                try {
                    DaemonWithMetadata daemonWithMetadata;
                    CompileService compileService3 = daemon;
                    if (compileService3 != null) {
                        CompileService it = compileService = compileService3;
                        daemonWithMetadata = new DaemonWithMetadata(it, file, it.getDaemonJVMOptions().get());
                    } else {
                        daemonWithMetadata = null;
                    }
                    compileService = daemonWithMetadata;
                }
                catch (Exception e) {
                    this.$report.invoke(DaemonReportCategory.INFO, "ERROR: unable to retrieve daemon JVM options, assuming daemon is dead: " + e.getMessage());
                    compileService = null;
                }
                return compileService;
            }
            {
                this.$fileToCompareTimestamp = file;
                this.$report = function2;
                super(1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "$file_port", "org/jetbrains/kotlin/daemon/common/ClientUtilsKt$walkDaemons$5", "invoke"));
            }
        });
        if (sequence == null) {
            ClientUtilsKt.$$$reportNull$$$0(12);
        }
        return sequence;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Sequence walkDaemons$default(File file, CompilerId compilerId, File file2, Function2 function2, Function2 function22, int n, Object object) {
        if ((n & 8) != 0) {
            function2 = walkDaemons.1.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            function22 = walkDaemons.2.INSTANCE;
        }
        return ClientUtilsKt.walkDaemons(file, compilerId, file2, function2, function22);
    }

    private static final CompileService tryConnectToDaemon(int port, Function2<? super DaemonReportCategory, ? super String, Unit> report) {
        try {
            Remote daemon;
            Registry registry = LocateRegistry.getRegistry(LoopbackNetworkInterface.INSTANCE.getLoopbackInetAddressName(), port, LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory());
            Remote remote = daemon = registry != null ? registry.lookup(DaemonParamsKt.getCOMPILER_SERVICE_RMI_NAME()) : null;
            if (Intrinsics.areEqual(remote, null)) {
                report.invoke(DaemonReportCategory.EXCEPTION, "daemon not found");
            } else {
                if (remote instanceof CompileService) {
                    return (CompileService)daemon;
                }
                report.invoke(DaemonReportCategory.EXCEPTION, "Unable to cast compiler service, actual class received: " + daemon.getClass().getName());
            }
        }
        catch (Throwable e) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append("cannot connect to registry: ");
            Object object2 = e.getCause();
            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                object2 = object = e.getMessage();
            }
            if (object2 == null) {
                object = "unknown error";
            }
            report.invoke(DaemonReportCategory.EXCEPTION, stringBuilder.append(object).toString());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File makeAutodeletingFlagFile(@NotNull String keyword, @Nullable File baseDir) {
        File file;
        void $receiver$iv$iv;
        if (keyword == null) {
            ClientUtilsKt.$$$reportNull$$$0(13);
        }
        Intrinsics.checkParameterIsNotNull(keyword, "keyword");
        String $receiver$iv = keyword;
        CharSequence charSequence = new StringBuilder().append("kotlin-");
        CharSequence charSequence2 = $receiver$iv;
        Appendable destination$iv$iv = new StringBuilder();
        int n = 0;
        int n2 = $receiver$iv$iv.length() - 1;
        if (n <= n2) {
            while (true) {
                void index$iv$iv;
                char element$iv$iv;
                char it;
                char c;
                char c2;
                CharSequence charSequence3;
                if (StringsKt.contains$default(charSequence3 = (CharSequence)validFlagFileKeywordChars, c2 = Character.toLowerCase(c = (it = (element$iv$iv = $receiver$iv$iv.charAt((int)index$iv$iv)))), false, 2, null)) {
                    destination$iv$iv.append(element$iv$iv);
                }
                if (index$iv$iv == n2) break;
                ++index$iv$iv;
            }
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkExpressionValueIsNotNull(string, "filterTo(StringBuilder(), predicate).toString()");
        String string2 = string;
        CharSequence charSequence4 = charSequence.append(string2).append("-").toString();
        String string3 = "-is-running";
        File file2 = baseDir;
        if (file2 != null) {
            File file3 = file2;
            string2 = string3;
            charSequence = charSequence4;
            File it = file3;
            File file4 = it.isDirectory() && it.exists() ? file3 : null;
            charSequence4 = charSequence;
            string3 = string2;
            file = file4;
        } else {
            file = null;
        }
        File flagFile = File.createTempFile(charSequence4, string3, file);
        flagFile.deleteOnExit();
        File file5 = flagFile;
        Intrinsics.checkExpressionValueIsNotNull(file5, "flagFile");
        if (file5 == null) {
            ClientUtilsKt.$$$reportNull$$$0(14);
        }
        return file5;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ File makeAutodeletingFlagFile$default(String string, File file, int n, Object object) {
        if ((n & 1) != 0) {
            string = "compiler-client";
        }
        if ((n & 2) != 0) {
            file = null;
        }
        return ClientUtilsKt.makeAutodeletingFlagFile(string, file);
    }

    static {
        MAX_PORT_NUMBER = 65535;
    }

    @Nullable
    public static final /* synthetic */ CompileService access$tryConnectToDaemon(int port, @NotNull Function2 report) {
        if (report == null) {
            ClientUtilsKt.$$$reportNull$$$0(15);
        }
        return ClientUtilsKt.tryConnectToDaemon(port, report);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timestamp";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "port";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escapeSequence";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/daemon/common/ClientUtilsKt";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registryDir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToCompareTimestamp";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "report";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/daemon/common/ClientUtilsKt";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeRunFilenameString";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makePortFromRunFilenameExtractor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "walkDaemons";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAutodeletingFlagFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "makeRunFilenameString";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makePortFromRunFilenameExtractor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "walkDaemons";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeAutodeletingFlagFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "access$tryConnectToDaemon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

