/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

public class AllowAllHostnameVerifierDetector
extends Detector
implements Detector.UastScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(AllowAllHostnameVerifierDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("AllowAllHostnameVerifier", "Insecure HostnameVerifier", "This check looks for use of HostnameVerifier implementations whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);

    @Override
    @Nullable
    public List<String> getApplicableConstructorTypes() {
        return Collections.singletonList("org.apache.http.conn.ssl.AllowAllHostnameVerifier");
    }

    @Override
    public void visitConstructor(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression node, @NonNull UMethod constructor) {
        Location location = context.getUastLocation((UElement)node);
        context.report(ISSUE, (UElement)node, location, "Using the AllowAllHostnameVerifier HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames");
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("setHostnameVerifier", "setDefaultHostnameVerifier");
    }

    @Override
    public void visitMethod(@NonNull JavaContext context, @Nullable UastVisitor visitor, @NonNull UCallExpression node, @NonNull UMethod method) {
        PsiField field;
        UExpression argument;
        PsiElement resolvedArgument;
        JavaEvaluator evaluator = context.getEvaluator();
        if (evaluator.methodMatches((PsiMethod)method, null, false, "javax.net.ssl.HostnameVerifier") && (resolvedArgument = UastUtils.tryResolve((UElement)(argument = (UExpression)node.getValueArguments().get(0)))) instanceof PsiField && "ALLOW_ALL_HOSTNAME_VERIFIER".equals((field = (PsiField)resolvedArgument).getName())) {
            Location location = context.getUastLocation((UElement)argument);
            String message = "Using the ALLOW_ALL_HOSTNAME_VERIFIER HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames";
            context.report(ISSUE, (UElement)argument, location, message);
        }
    }
}

