/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxStaticPropertyReference;

public class JavaFxStaticPropertyReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider", "getReferencesByElement"));
        }
        if (!(element instanceof XmlAttribute) || !JavaFxFileTypeFactory.isFxml(element.getContainingFile())) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttribute xmlAttribute = (XmlAttribute)element;
        String name = xmlAttribute.getName();
        int dotIndex = name.indexOf(46);
        if (dotIndex <= 0 || name.indexOf(46, dotIndex + 1) >= 0) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String className = name.substring(0, dotIndex);
        JavaFxStaticPropertyClassReference classReference = new JavaFxStaticPropertyClassReference(xmlAttribute, className);
        classReference.setRangeInElement(new TextRange(0, dotIndex));
        if (dotIndex + 1 == name.length()) {
            PsiReference[] psiReferenceArray = new PsiReference[]{classReference};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        String propertyName = name.substring(dotIndex + 1);
        JavaFxStaticPropertyReference methodReference = new JavaFxStaticPropertyReference(xmlAttribute, classReference.getPsiClass(), propertyName);
        methodReference.setRangeInElement(new TextRange(dotIndex + 1, name.length()));
        PsiReference[] psiReferenceArray = new PsiReference[]{classReference, methodReference};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private static class JavaFxStaticPropertyClassReference
    extends PsiReferenceBase<XmlAttribute> {
        private PsiClass myPsiClass;

        public JavaFxStaticPropertyClassReference(@NotNull XmlAttribute xmlAttribute, @NotNull String className) {
            if (xmlAttribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttribute", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider$JavaFxStaticPropertyClassReference", "<init>"));
            }
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider$JavaFxStaticPropertyClassReference", "<init>"));
            }
            super((PsiElement)xmlAttribute);
            this.myPsiClass = JavaFxPsiUtil.findPsiClass(className, (PsiElement)xmlAttribute);
        }

        public PsiClass getPsiClass() {
            return this.myPsiClass;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myPsiClass;
        }

        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReferenceProvider$JavaFxStaticPropertyClassReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

