/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.indexing;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;

public class JavaFxControllerClassIndex
extends ScalarIndexExtension<String> {
    @NonNls
    public static final ID<String, Void> NAME = ID.create((String)"JavaFxControllerClassIndex");
    private final MyInputFilter myInputFilter = new MyInputFilter();
    private final MyDataIndexer myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        MyDataIndexer myDataIndexer = this.myDataIndexer;
        if (myDataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "getIndexer"));
        }
        return myDataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "getKeyDescriptor"));
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        MyInputFilter myInputFilter = this.myInputFilter;
        if (myInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "getInputFilter"));
        }
        return myInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 1;
    }

    public static List<PsiFile> findFxmlWithController(Project project, @NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmlWithController"));
        }
        return JavaFxControllerClassIndex.findFxmlWithController(project, className, ProjectScope.getAllScope((Project)project));
    }

    public static List<PsiFile> findFxmlWithController(Project project, @NotNull String className, @NotNull GlobalSearchScope scope) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmlWithController"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmlWithController"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return JavaFxControllerClassIndex.findFxmlWithController(project, className, arg_0 -> ((PsiManager)psiManager).findFile(arg_0), scope);
    }

    public static List<VirtualFile> findFxmlsWithController(Project project, @NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmlsWithController"));
        }
        return JavaFxControllerClassIndex.findFxmlsWithController(project, className, ProjectScope.getAllScope((Project)project));
    }

    public static List<VirtualFile> findFxmlsWithController(Project project, @NotNull String className, @NotNull GlobalSearchScope scope) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmlsWithController"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmlsWithController"));
        }
        return JavaFxControllerClassIndex.findFxmlWithController(project, className, Functions.id(), scope);
    }

    private static <T> List<T> findFxmlWithController(Project project, @NotNull String className, Function<VirtualFile, T> f, GlobalSearchScope scope) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmlWithController"));
        }
        return JavaFxControllerClassIndex.findFxmls(NAME, project, className, f, scope);
    }

    static <T> List<T> findFxmls(ID<String, ?> id, Project project, @NotNull String className, Function<VirtualFile, T> f, GlobalSearchScope scope) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "findFxmls"));
        }
        return (List)ReadAction.compute(() -> {
            Collection files;
            if (className == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex", "lambda$findFxmls$0"));
            }
            try {
                files = FileBasedIndex.getInstance().getContainingFiles(id, (Object)className, GlobalSearchScope.projectScope((Project)project).intersectWith(scope));
            }
            catch (IndexNotReadyException e) {
                return Collections.emptyList();
            }
            if (files.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (VirtualFile file : files) {
                Object fFile;
                if (!file.isValid() || (fFile = f.fun((Object)file)) == null) continue;
                result.add(fFile);
            }
            return result;
        });
    }

    public static class MyInputFilter
    extends DefaultFileTypeSpecificInputFilter {
        public MyInputFilter() {
            super(new FileType[]{StdFileTypes.XML});
        }

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex$MyInputFilter", "acceptInput"));
            }
            return JavaFxFileTypeFactory.isFxml(file);
        }
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex$MyDataIndexer", "map"));
            }
            String className = MyDataIndexer.getControllerClassName(inputData.getContentAsText().toString());
            if (className != null) {
                Map<String, Object> map = Collections.singletonMap(className, null);
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex$MyDataIndexer", "map"));
                }
                return map;
            }
            Map<String, Void> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/indexing/JavaFxControllerClassIndex$MyDataIndexer", "map"));
            }
            return map;
        }

        @Nullable
        private static String getControllerClassName(String content) {
            if (!content.contains("http://javafx.com/fxml")) {
                return null;
            }
            final String[] className = new String[]{null};
            NanoXmlUtil.parse((Reader)new StringReader(content), (IXMLBuilder)new NanoXmlUtil.IXMLBuilderAdapter(){
                private boolean myFxRootUsed = false;

                public void addAttribute(String key, String nsPrefix, String nsURI, String value, String type) throws Exception {
                    if (value != null && ("fx:controller".equals(nsPrefix + ":" + key) || "type".equals(key) && this.myFxRootUsed)) {
                        className[0] = value;
                    }
                }

                public void elementAttributesProcessed(String name, String nsPrefix, String nsURI) throws Exception {
                    throw NanoXmlUtil.ParserStoppedXmlException.INSTANCE;
                }

                public void startElement(String name, String nsPrefix, String nsURI, String systemID, int lineNr) throws Exception {
                    this.myFxRootUsed = "fx:root".equals(nsPrefix + ":" + name);
                }
            });
            return className[0];
        }
    }
}

