/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.status;

import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.Convertor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.commandLine.SvnExceptionWrapper;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.PortableStatus;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.status.SvnStatusHandler;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CmdStatusClient
extends BaseSvnClient
implements StatusClient {
    @Override
    public long doStatus(@NotNull File path, @Nullable SVNRevision revision, @NotNull Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, boolean collectParentExternals, @NotNull StatusConsumer handler, @Nullable Collection changeLists) throws SvnBindException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/status/CmdStatusClient", "doStatus"));
        }
        if (depth == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "depth", "org/jetbrains/idea/svn/status/CmdStatusClient", "doStatus"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/idea/svn/status/CmdStatusClient", "doStatus"));
        }
        File base = CommandUtil.requireExistingParent(path);
        Info infoBase = this.myFactory.createInfoClient().doInfo(base, revision);
        ArrayList<String> parameters = new ArrayList<String>();
        CmdStatusClient.putParameters(parameters, path, depth, remote, reportAll, includeIgnored, changeLists);
        CommandExecutor command = this.execute(this.myVcs, SvnTarget.fromFile((File)path), SvnCommandName.st, parameters, null);
        this.parseResult(path, revision, handler, base, infoBase, command);
        return 0L;
    }

    private void parseResult(final File path, SVNRevision revision, StatusConsumer handler, File base, Info infoBase, CommandExecutor command) throws SvnBindException {
        block8: {
            String result = command.getOutput();
            if (StringUtil.isEmptyOrSpaces((String)result)) {
                throw new SvnBindException("Status request returned nothing for command: " + command.getCommandText());
            }
            try {
                SvnStatusHandler[] svnHandl;
                svnHandl = new SvnStatusHandler[]{this.createStatusHandler(revision, handler, base, infoBase, svnHandl)};
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse((InputStream)new ByteArrayInputStream(result.trim().getBytes(CharsetToolkit.UTF8_CHARSET)), (DefaultHandler)svnHandl[0]);
                if (svnHandl[0].isAnythingReported()) break block8;
                if (!SvnUtil.isSvnVersioned(this.myVcs, path)) {
                    throw new SvnBindException(SVNErrorCode.WC_NOT_DIRECTORY, "Command - " + command.getCommandText() + ". Result - " + result);
                }
                PortableStatus status = new PortableStatus();
                status.setFile(path);
                status.setPath(path.getAbsolutePath());
                status.setContentsStatus(StatusType.STATUS_NORMAL);
                status.setInfoGetter(new Getter<Info>(){

                    public Info get() {
                        return (Info)CmdStatusClient.this.createInfoGetter(null).convert((Object)path);
                    }
                });
                try {
                    handler.consume(status);
                }
                catch (SVNException e) {
                    throw new SvnBindException(e);
                }
            }
            catch (SvnExceptionWrapper e) {
                throw new SvnBindException(e.getCause());
            }
            catch (IOException | ParserConfigurationException e) {
                throw new SvnBindException(e);
            }
            catch (SAXException e) {
                command.logCommand();
                throw new SvnBindException(e);
            }
        }
    }

    private static void putParameters(@NotNull List<String> parameters, @NotNull File path, @Nullable Depth depth, boolean remote, boolean reportAll, boolean includeIgnored, @Nullable Collection changeLists) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/idea/svn/status/CmdStatusClient", "putParameters"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/status/CmdStatusClient", "putParameters"));
        }
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, depth);
        CommandUtil.put(parameters, remote, "-u");
        CommandUtil.put(parameters, reportAll, "--verbose");
        CommandUtil.put(parameters, includeIgnored, "--no-ignore");
        CommandUtil.putChangeLists(parameters, changeLists);
        parameters.add("--xml");
    }

    public SvnStatusHandler createStatusHandler(SVNRevision revision, StatusConsumer handler, File base, Info infoBase, SvnStatusHandler[] svnHandl) {
        SvnStatusHandler.ExternalDataCallback callback = CmdStatusClient.createStatusCallback(handler, base, infoBase, svnHandl);
        return new SvnStatusHandler(callback, base, this.createInfoGetter(revision));
    }

    private Convertor<File, Info> createInfoGetter(final SVNRevision revision) {
        return new Convertor<File, Info>(){

            public Info convert(File o) {
                try {
                    return CmdStatusClient.this.myFactory.createInfoClient().doInfo(o, revision);
                }
                catch (SvnBindException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }
        };
    }

    public static SvnStatusHandler.ExternalDataCallback createStatusCallback(final StatusConsumer handler, final File base, final Info infoBase, final SvnStatusHandler[] svnHandl) {
        final HashMap externalsMap = new HashMap();
        final String[] changelistName = new String[1];
        return new SvnStatusHandler.ExternalDataCallback(){

            @Override
            public void switchPath() {
                PortableStatus pending = svnHandl[0].getPending();
                pending.setChangelistName(changelistName[0]);
                try {
                    Info baseInfo = infoBase;
                    File baseFile = base;
                    File pendingFile = new File(pending.getPath());
                    if (!externalsMap.isEmpty()) {
                        for (File file : externalsMap.keySet()) {
                            if (!FileUtil.isAncestor((File)file, (File)pendingFile, (boolean)false)) continue;
                            baseInfo = (Info)externalsMap.get(file);
                            baseFile = file;
                            break;
                        }
                    }
                    if (baseInfo != null) {
                        String append;
                        String systemIndependentPath = FileUtil.toSystemIndependentName((String)pending.getPath());
                        if (pendingFile.isAbsolute()) {
                            String relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)baseFile.getPath()), (String)systemIndependentPath, (char)'/');
                            append = SVNPathUtil.append((String)baseInfo.getURL().toString(), (String)FileUtil.toSystemIndependentName((String)relativePath));
                        } else {
                            append = SVNPathUtil.append((String)baseInfo.getURL().toString(), (String)systemIndependentPath);
                        }
                        pending.setURL(SVNURL.parseURIEncoded((String)append));
                    }
                    if (StatusType.STATUS_EXTERNAL.equals((Object)pending.getNodeStatus())) {
                        externalsMap.put(pending.getFile(), pending.getInfo());
                    }
                    handler.consume(pending);
                }
                catch (SVNException e) {
                    throw new SvnExceptionWrapper(e);
                }
            }

            @Override
            public void switchChangeList(String newList) {
                changelistName[0] = newList;
            }
        };
    }

    @Override
    public Status doStatus(@NotNull File path, boolean remote) throws SvnBindException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/status/CmdStatusClient", "doStatus"));
        }
        final Status[] svnStatus = new Status[1];
        this.doStatus(path, SVNRevision.UNDEFINED, Depth.EMPTY, remote, false, false, false, new StatusConsumer(){

            public void consume(Status status) throws SVNException {
                svnStatus[0] = status;
            }
        }, null);
        return svnStatus[0];
    }
}

