/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsPanel;
import git4idea.config.GitVcsSettings;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcsConfigurable
implements Configurable {
    public static final String DISPLAY_NAME = "Git";
    private final Project myProject;
    private final GitVcsSettings mySettings;
    @NotNull
    private final GitSharedSettings mySharedSettings;
    private GitVcsPanel panel;

    public GitVcsConfigurable(@NotNull Project project, @NotNull GitVcsSettings settings, @NotNull GitSharedSettings sharedSettings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/config/GitVcsConfigurable", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/config/GitVcsConfigurable", "<init>"));
        }
        if (sharedSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sharedSettings", "git4idea/config/GitVcsConfigurable", "<init>"));
        }
        this.myProject = project;
        this.mySettings = settings;
        this.mySharedSettings = sharedSettings;
    }

    @NotNull
    public String getDisplayName() {
        if (DISPLAY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsConfigurable", "getDisplayName"));
        }
        return DISPLAY_NAME;
    }

    @Nullable
    public String getHelpTopic() {
        return "project.propVCSSupport.VCSs.Git";
    }

    @NotNull
    public JComponent createComponent() {
        this.panel = new GitVcsPanel(this.myProject);
        this.panel.load(this.mySettings, this.mySharedSettings);
        JComponent jComponent = this.panel.getPanel();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/config/GitVcsConfigurable", "createComponent"));
        }
        return jComponent;
    }

    public boolean isModified() {
        return this.panel.isModified(this.mySettings, this.mySharedSettings);
    }

    public void apply() throws ConfigurationException {
        this.panel.save(this.mySettings, this.mySharedSettings);
    }

    public void reset() {
        this.panel.load(this.mySettings, this.mySharedSettings);
    }
}

