/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.codeInsight.generation.MemberChooserObjectBase;
import com.intellij.codeInsight.generation.PsiElementMemberChooserObject;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import icons.MavenIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

public class GenerateDependencyUtil {
    private GenerateDependencyUtil() {
    }

    @NotNull
    public static List<MavenDomDependency> chooseDependencies(Collection<MavenDomDependency> candidates, Project project) {
        MavenDomProjectModelMember[] members;
        ArrayList<MavenDomDependency> dependencies = new ArrayList<MavenDomDependency>();
        MavenDomProjectModelMember[] memberCandidates = (MavenDomProjectModelMember[])ContainerUtil.map2Array(candidates, MavenDomProjectModelMember.class, dependency -> new MavenDomProjectModelMember((MavenDomDependency)dependency));
        MemberChooser<MavenDomProjectModelMember> chooser = new MemberChooser<MavenDomProjectModelMember>(memberCandidates, true, true, project){

            protected MemberChooser.ShowContainersAction getShowContainersAction() {
                return new MemberChooser.ShowContainersAction((MemberChooser)this, MavenDomBundle.message("chooser.show.project.files", new Object[0]), MavenIcons.MavenProject);
            }

            @NotNull
            protected String convertElementText(@NotNull String originalElementText) {
                if (originalElementText == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalElementText", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyUtil$1", "convertElementText"));
                }
                String string = originalElementText;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyUtil$1", "convertElementText"));
                }
                return string;
            }

            protected String getAllContainersNodeName() {
                return MavenDomBundle.message("all.dependencies", new Object[0]);
            }
        };
        chooser.setTitle(MavenDomBundle.message("dependencies.chooser.title", new Object[0]));
        chooser.setCopyJavadocVisible(false);
        chooser.show();
        if (chooser.getExitCode() == 0 && (members = (MavenDomProjectModelMember[])chooser.getSelectedElements((ClassMember[])new MavenDomProjectModelMember[0])) != null) {
            dependencies.addAll(ContainerUtil.mapNotNull((Object[])members, mavenDomProjectModelMember -> mavenDomProjectModelMember.getDependency()));
        }
        ArrayList<MavenDomDependency> arrayList = dependencies;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyUtil", "chooseDependencies"));
        }
        return arrayList;
    }

    private static class MavenDomProjectModelMember
    extends MemberChooserObjectBase
    implements ClassMember {
        private final MavenDomDependency myDependency;

        public MavenDomProjectModelMember(MavenDomDependency dependency) {
            super(dependency.toString(), AllIcons.Nodes.PpLib);
            this.myDependency = dependency;
        }

        @NotNull
        public String getText() {
            StringBuffer sb = new StringBuffer();
            MavenDomProjectModelMember.append(sb, this.myDependency.getGroupId().getStringValue());
            MavenDomProjectModelMember.append(sb, this.myDependency.getArtifactId().getStringValue());
            MavenDomProjectModelMember.append(sb, this.myDependency.getVersion().getStringValue());
            String string = sb.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyUtil$MavenDomProjectModelMember", "getText"));
            }
            return string;
        }

        private static void append(StringBuffer sb, String str) {
            if (!StringUtil.isEmptyOrSpaces((String)str)) {
                if (sb.length() > 0) {
                    sb.append(": ");
                }
                sb.append(str);
            }
        }

        public MemberChooserObject getParentNodeDelegate() {
            MavenDomDependency dependency = this.getDependency();
            return new MavenDomProjectModelFileMemberChooserObjectBase(dependency.getXmlTag().getContainingFile(), MavenDomProjectModelMember.getProjectName(dependency));
        }

        @Nullable
        private static String getProjectName(@Nullable MavenDomDependency dependency) {
            MavenDomProjectModel model;
            if (dependency != null && (model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false)) != null) {
                String name = model.getName().getStringValue();
                return StringUtil.isEmptyOrSpaces((String)name) ? model.getArtifactId().getStringValue() : name;
            }
            return null;
        }

        public MavenDomDependency getDependency() {
            return this.myDependency;
        }

        private static class MavenDomProjectModelFileMemberChooserObjectBase
        extends PsiElementMemberChooserObject {
            public MavenDomProjectModelFileMemberChooserObjectBase(@NotNull PsiFile psiFile, @Nullable String projectName) {
                if (psiFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/idea/maven/dom/generate/GenerateDependencyUtil$MavenDomProjectModelMember$MavenDomProjectModelFileMemberChooserObjectBase", "<init>"));
                }
                super((PsiElement)psiFile, StringUtil.isEmptyOrSpaces((String)projectName) ? psiFile.getName() : projectName, MavenIcons.MavenProject);
            }
        }
    }
}

