/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import org.gradle.model.internal.type.TypeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassTypeWrapper
implements TypeWrapper {
    private final WeakReference<Class<?>> reference;
    private final int hashCode;

    public ClassTypeWrapper(Class<?> clazz) {
        this.reference = new WeakReference(clazz);
        this.hashCode = clazz.hashCode();
    }

    public Class<?> unwrap() {
        return (Class)this.reference.get();
    }

    @Override
    public Class<?> getRawClass() {
        return this.unwrap();
    }

    @Override
    public boolean isAssignableFrom(TypeWrapper wrapper) {
        return this.unwrap().isAssignableFrom(wrapper.getRawClass());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClassTypeWrapper other = (ClassTypeWrapper)obj;
        return this.unwrap().equals(other.unwrap());
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        builder.add(this.unwrap());
    }

    @Override
    public String getRepresentation(boolean full) {
        if (full) {
            return this.unwrap().getName();
        }
        Class<?> clazz = this.unwrap();
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(clazz.getSimpleName());
            for (Class<?> c = clazz.getEnclosingClass(); c != null; c = c.getEnclosingClass()) {
                sb.insert(0, '.');
                sb.insert(0, c.getSimpleName());
            }
            return sb.toString();
        }
        catch (NoClassDefFoundError ignore) {
            Package pkg = clazz.getPackage();
            int pkgPrefixLength = pkg == null ? 0 : pkg.getName().length() + 1;
            return clazz.getName().substring(pkgPrefixLength).replace('$', '.');
        }
    }
}

