/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.build;

import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.build.PluginBuildConfiguration;

public class PluginModuleBuildConfEditor
implements ModuleConfigurationEditor {
    private final JPanel myWholePanel = new JPanel(new GridBagLayout());
    @NonNls
    private final JLabel myPluginXMLLabel = new JLabel(DevKitBundle.message("deployment.view.meta-inf.label", "META-INF" + File.separator + "plugin.xml:"));
    private final TextFieldWithBrowseButton myPluginXML = new TextFieldWithBrowseButton();
    private final TextFieldWithBrowseButton myManifest = new TextFieldWithBrowseButton();
    private final JCheckBox myUseUserManifest = new JCheckBox(DevKitBundle.message("manifest.use.user.defined", new Object[0]));
    private final PluginBuildConfiguration myBuildProperties;
    private final Module myModule;
    @NonNls
    private static final String META_INF = "META-INF";
    @NonNls
    private static final String PLUGIN_XML = "plugin.xml";
    @NonNls
    private static final String MANIFEST_MF = "manifest.mf";

    public PluginModuleBuildConfEditor(ModuleConfigurationState state) {
        this.myModule = state.getRootModel().getModule();
        this.myBuildProperties = PluginBuildConfiguration.getInstance(this.myModule);
    }

    public JComponent createComponent() {
        this.myPluginXML.addActionListener((ActionListener)new BrowseFilesListener(this.myPluginXML.getTextField(), DevKitBundle.message("deployment.directory.location", META_INF), DevKitBundle.message("saved.message.common", META_INF + File.separator + PLUGIN_XML), BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR));
        this.myManifest.addActionListener((ActionListener)new BrowseFilesListener(this.myManifest.getTextField(), DevKitBundle.message("deployment.view.select", MANIFEST_MF), DevKitBundle.message("manifest.selection", MANIFEST_MF), BrowseFilesListener.SINGLE_FILE_DESCRIPTOR));
        this.myManifest.setEnabled(this.myBuildProperties.isUseUserManifest());
        this.myUseUserManifest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = PluginModuleBuildConfEditor.this.myUseUserManifest.isSelected();
                PluginModuleBuildConfEditor.this.myManifest.setEnabled(selected);
            }
        });
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.insets((int)2), 0, 0);
        this.myWholePanel.add((Component)this.myPluginXMLLabel, gc);
        this.myWholePanel.add((Component)this.myPluginXML, gc);
        JPanel manifestPanel = new JPanel(new GridBagLayout());
        manifestPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)DevKitBundle.message("manifest.settings", new Object[0]), (boolean)true));
        gc.insets.left = 0;
        manifestPanel.add((Component)this.myUseUserManifest, gc);
        gc.insets.left = 2;
        gc.weighty = 1.0;
        manifestPanel.add((Component)this.myManifest, gc);
        this.myWholePanel.add((Component)manifestPanel, gc);
        this.myWholePanel.setBorder(JBUI.Borders.empty((int)5));
        return this.myWholePanel;
    }

    public boolean isModified() {
        String pluginXmlPath = new File(this.myBuildProperties.getPluginXmlPath()).getParentFile().getParent();
        boolean modified = !Comparing.strEqual((String)this.myPluginXML.getText(), (String)pluginXmlPath);
        boolean selected = this.myUseUserManifest.isSelected();
        modified |= this.myBuildProperties.isUseUserManifest() != selected;
        if (selected) {
            modified |= !Comparing.strEqual((String)this.myManifest.getText(), (String)this.myBuildProperties.getManifestPath());
        }
        return modified;
    }

    public void apply() throws ConfigurationException {
        if (this.myUseUserManifest.isSelected() && !new File(this.myManifest.getText()).exists()) {
            throw new ConfigurationException(DevKitBundle.message("error.file.not.found.message", this.myManifest.getText()));
        }
        File plugin = new File(this.myBuildProperties.getPluginXmlPath());
        String newPluginPath = this.myPluginXML.getText() + File.separator + META_INF + File.separator + PLUGIN_XML;
        if (plugin.exists() && !plugin.getPath().equals(newPluginPath)) {
            Project project = this.myModule.getProject();
            ApplicationManager.getApplication().invokeLater(() -> this.askToDeleteOldPlugin(plugin, project), project.getDisposed());
        }
        this.myBuildProperties.setPluginXmlPathAndCreateDescriptorIfDoesntExist(newPluginPath);
        this.myBuildProperties.setManifestPath(this.myManifest.getText());
        this.myBuildProperties.setUseUserManifest(this.myUseUserManifest.isSelected());
    }

    protected void askToDeleteOldPlugin(File plugin, Project project) {
        if (Messages.showYesNoDialog((Project)project, (String)DevKitBundle.message("deployment.view.delete", plugin.getPath()), (String)DevKitBundle.message("deployment.cleanup", META_INF), null) == 0) {
            WriteCommandAction.writeCommandAction((Project)project).withName(DevKitBundle.message("deployment.cleanup", META_INF)).run(() -> FileUtil.delete((File)plugin.getParentFile()));
        }
    }

    public void reset() {
        this.myPluginXML.setText(this.myBuildProperties.getPluginXmlPath().substring(0, this.myBuildProperties.getPluginXmlPath().length() - META_INF.length() - PLUGIN_XML.length() - 2));
        this.myManifest.setText(this.myBuildProperties.getManifestPath());
        this.myUseUserManifest.setSelected(this.myBuildProperties.isUseUserManifest());
    }

    public String getDisplayName() {
        return DevKitBundle.message("deployment.title", new Object[0]);
    }

    public String getHelpTopic() {
        return "plugin.configuring";
    }

    public void moduleStateChanged() {
    }
}

