/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GrInspectionUtil;
import org.jetbrains.plugins.groovy.codeInspection.changeToMethod.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

class CompareToTransformation
extends BinaryTransformation {
    @NotNull
    private final IElementType myElementType;

    public CompareToTransformation(@NotNull IElementType elementType) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/CompareToTransformation", "<init>"));
        }
        this.myElementType = elementType;
    }

    @Override
    public void apply(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/changeToMethod/transformations/CompareToTransformation", "apply"));
        }
        GrExpression lhsParenthesized = this.addParenthesesIfNeeded(this.getLhs(expression));
        String compare = "";
        if (this.myElementType != GroovyTokenTypes.mCOMPARE_TO) {
            compare = String.format(" %s 0", this.myElementType.toString());
        }
        GrInspectionUtil.replaceExpression(expression, String.format("%s.compareTo(%s) %s", lhsParenthesized.getText(), this.getRhs(expression).getText(), compare));
    }

    @Override
    public String getMethod() {
        return "compareTo";
    }
}

