/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.BoolUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyNegatedConditionalInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedConditionalInspection", "getGroupDisplayName"));
        }
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Negated conditional expression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedConditionalInspection", "getDisplayName"));
        }
        return "Negated conditional expression";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Negated conditional expression #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor2 = new Visitor();
        if (visitor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedConditionalInspection", "buildVisitor"));
        }
        return visitor2;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(@NotNull GrConditionalExpression grConditionalExpression) {
            if (grConditionalExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grConditionalExpression", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyNegatedConditionalInspection$Visitor", "visitConditionalExpression"));
            }
            super.visitConditionalExpression(grConditionalExpression);
            GrExpression condition = grConditionalExpression.getCondition();
            if (!BoolUtils.isNegation(condition)) {
                return;
            }
            this.registerError(grConditionalExpression);
        }
    }
}

