/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkEntry;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.EmptyPanel;
import com.android.tools.idea.apk.viewer.arsc.ArscViewer;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.diff.ApkDiffPanel;
import com.android.tools.idea.apk.viewer.diff.ApkDiffParser;
import com.android.tools.idea.editors.NinePatchEditorProvider;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApkEditor
extends UserDataHolderBase
implements FileEditor,
ApkViewPanel.Listener {
    private final Project myProject;
    private final VirtualFile myBaseFile;
    private final VirtualFile myRoot;
    private final ApkViewPanel myApkViewPanel;
    private JBSplitter mySplitter;
    private ApkFileEditorComponent myCurrentEditor;

    public ApkEditor(@NotNull Project project, @NotNull VirtualFile baseFile, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/apk/viewer/ApkEditor", "<init>"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/android/tools/idea/apk/viewer/ApkEditor", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/android/tools/idea/apk/viewer/ApkEditor", "<init>"));
        }
        this.myProject = project;
        this.myBaseFile = baseFile;
        this.myRoot = root;
        this.mySplitter = new JBSplitter(true, "android.apk.viewer", 0.62f);
        this.myApkViewPanel = new ApkViewPanel(new ApkParser(baseFile, root));
        this.myApkViewPanel.setListener(this);
        this.mySplitter.setFirstComponent(this.myApkViewPanel.getContainer());
        this.mySplitter.setSecondComponent((JComponent)new JPanel());
    }

    @Override
    public void selectionChanged(@Nullable ApkEntry entry) {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
        }
        VirtualFile file = entry == null ? null : entry.getFile();
        this.myCurrentEditor = this.getEditor(file);
        this.mySplitter.setSecondComponent(this.myCurrentEditor.getComponent());
    }

    @Override
    public void selectApkAndCompare() {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, false, false, false, false, false);
        desc.withFileFilter(file -> "apk".equals(file.getExtension()));
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)desc, (Project)this.myProject, null);
        if (file2 == null) {
            return;
        }
        VirtualFile newApk = ApkFileSystem.getInstance().getRootByLocal(file2);
        assert (newApk != null);
        DialogBuilder builder = new DialogBuilder(this.myProject);
        builder.setTitle(this.myRoot.getName() + " vs " + newApk.getName());
        ApkDiffParser parser = new ApkDiffParser(this.myRoot, newApk);
        ApkDiffPanel panel = new ApkDiffPanel(parser);
        builder.setCenterPanel(panel.getContainer());
        builder.setPreferredFocusComponent(panel.getPreferredFocusedComponent());
        builder.show();
    }

    @NotNull
    public JComponent getComponent() {
        JBSplitter jBSplitter = this.mySplitter;
        if (jBSplitter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getComponent"));
        }
        return jBSplitter;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myApkViewPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = this.myBaseFile.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getName"));
        }
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/apk/viewer/ApkEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/apk/viewer/ApkEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.myBaseFile.isValid();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/apk/viewer/ApkEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/apk/viewer/ApkEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.myCurrentEditor != null) {
            Disposer.dispose((Disposable)this.myCurrentEditor);
            this.myCurrentEditor = null;
        }
    }

    @NotNull
    private ApkFileEditorComponent getEditor(@Nullable VirtualFile file) {
        if (file == null) {
            EmptyPanel emptyPanel = new EmptyPanel();
            if (emptyPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getEditor"));
            }
            return emptyPanel;
        }
        if (ApkFileSystem.getInstance().isArsc(file)) {
            byte[] arscContent;
            try {
                arscContent = file.contentsToByteArray();
            }
            catch (IOException e) {
                EmptyPanel emptyPanel = new EmptyPanel();
                if (emptyPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getEditor"));
                }
                return emptyPanel;
            }
            ArscViewer arscViewer = new ArscViewer(arscContent);
            if (arscViewer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getEditor"));
            }
            return arscViewer;
        }
        if ("dex".equals(file.getExtension())) {
            DexFileViewer dexFileViewer = new DexFileViewer(file);
            if (dexFileViewer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getEditor"));
            }
            return dexFileViewer;
        }
        Optional<FileEditorProvider> providers = this.getFileEditorProviders(file);
        if (!providers.isPresent()) {
            EmptyPanel emptyPanel = new EmptyPanel();
            if (emptyPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getEditor"));
            }
            return emptyPanel;
        }
        final FileEditor editor = providers.get().createEditor(this.myProject, file);
        ApkFileEditorComponent apkFileEditorComponent = new ApkFileEditorComponent(){

            @Override
            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = editor.getComponent();
                if (jComponent == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor$1", "getComponent"));
                }
                return jComponent;
            }

            public void dispose() {
                Disposer.dispose((Disposable)editor);
            }
        };
        if (apkFileEditorComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getEditor"));
        }
        return apkFileEditorComponent;
    }

    @NotNull
    private Optional<FileEditorProvider> getFileEditorProviders(@Nullable VirtualFile file) {
        if (file == null || file.isDirectory()) {
            Optional<FileEditorProvider> optional = Optional.empty();
            if (optional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getFileEditorProviders"));
            }
            return optional;
        }
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(this.myProject, file);
        Optional<FileEditorProvider> optional = Arrays.stream(providers).filter(fileEditorProvider -> !(fileEditorProvider instanceof NinePatchEditorProvider)).findFirst();
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditor", "getFileEditorProviders"));
        }
        return optional;
    }
}

