/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.FlatComboAction;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.ResourceHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import icons.AndroidIcons;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetMenuAction
extends FlatComboAction {
    private static final int SHOW_FROM_API_LEVEL = 7;
    private final ConfigurationHolder myRenderContext;
    private final boolean myUseCompatibilityTarget;

    public TargetMenuAction(ConfigurationHolder renderContext, boolean useCompatibilityTarget, boolean classicStyle) {
        this.myRenderContext = renderContext;
        this.myUseCompatibilityTarget = useCompatibilityTarget;
        Presentation presentation = this.getTemplatePresentation();
        presentation.setDescription("API Version in Editor");
        presentation.setIcon(classicStyle ? AndroidIcons.Targets : AndroidIcons.NeleIcons.Api);
        this.updatePresentation(presentation);
    }

    public TargetMenuAction(ConfigurationHolder renderContext, boolean useCompatibilityTarget) {
        this(renderContext, useCompatibilityTarget, false);
    }

    public TargetMenuAction(ConfigurationHolder renderContext) {
        this(renderContext, false);
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            IAndroidTarget target = configuration.getTarget();
            String brief = TargetMenuAction.getRenderingTargetLabel(target, true);
            presentation.setText(brief);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    private int getMinSdkVersion() {
        AndroidFacet facet;
        Module module;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (module = configuration.getModule()) != null && (facet = AndroidFacet.getInstance(module)) != null) {
            return facet.getAndroidModuleInfo().getMinSdkVersion().getFeatureLevel();
        }
        return -1;
    }

    private void addCompatibilityTargets(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/TargetMenuAction", "addCompatibilityTargets"));
        }
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget currentTarget = configuration.getTarget();
        IAndroidTarget highestTarget = configuration.getConfigurationManager().getHighestApiTarget();
        assert (highestTarget != null);
        int highestApiLevel = highestTarget.getVersion().getFeatureLevel();
        int minApi = Math.max(this.getMinSdkVersion(), 7);
        for (int apiLevel = highestApiLevel; apiLevel >= minApi; --apiLevel) {
            CompatibilityRenderTarget target = new CompatibilityRenderTarget(highestTarget, apiLevel, null);
            boolean isSelected = target.getVersion().equals((Object)currentTarget.getVersion());
            group.add((AnAction)new SetTargetAction(this.myRenderContext, target.getVersionName(), target, isSelected));
        }
    }

    private void addRealTargets(@NotNull DefaultActionGroup group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/android/tools/idea/configurations/TargetMenuAction", "addRealTargets"));
        }
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget current = configuration.getTarget();
        IAndroidTarget[] targets = configuration.getConfigurationManager().getTargets();
        boolean haveRecent = false;
        int minSdk = this.getMinSdkVersion();
        for (int i = targets.length - 1; i >= 0; --i) {
            AndroidVersion version;
            IAndroidTarget target = targets[i];
            if (!ConfigurationManager.isLayoutLibTarget(target) || !TargetMenuAction.switchToTargetAllowed(configuration, target) || (version = target.getVersion()).getFeatureLevel() < minSdk) continue;
            if (version.getApiLevel() >= 7) {
                haveRecent = true;
            } else if (haveRecent) break;
            String title = TargetMenuAction.getRenderingTargetLabel(target, false);
            boolean select = current == target;
            group.add((AnAction)new SetTargetAction(this.myRenderContext, title, target, select));
        }
    }

    @Override
    @NotNull
    protected DefaultActionGroup createPopupActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            DefaultActionGroup defaultActionGroup = group;
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/TargetMenuAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }
        group.add((AnAction)new TogglePickBestAction(configuration.getConfigurationManager()));
        group.addSeparator();
        if (this.myUseCompatibilityTarget && configuration.getConfigurationManager().getHighestApiTarget() != null) {
            this.addCompatibilityTargets(group);
        } else {
            this.addRealTargets(group);
        }
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/configurations/TargetMenuAction", "createPopupActionGroup"));
        }
        return defaultActionGroup;
    }

    private static boolean switchToTargetAllowed(Configuration configuration, IAndroidTarget target) {
        if (ResourceHelper.getFolderType(configuration.getFile()) != ResourceFolderType.XML) {
            return true;
        }
        PsiFile file = configuration.getPsiFile();
        return file == null || target.getVersion().getFeatureLevel() >= 22 || !"PreferenceScreen".equals(AndroidPsiUtils.getRootTagName(file));
    }

    public static String getRenderingTargetLabel(@Nullable IAndroidTarget target, boolean brief) {
        if (target == null) {
            return "<null>";
        }
        AndroidVersion version = target.getVersion();
        if (brief) {
            if (target.isPlatform()) {
                String codename = version.getCodename();
                if (codename != null && !codename.isEmpty()) {
                    if (codename.equals("MNC")) {
                        return "M";
                    }
                    if (codename.length() <= 3) {
                        return codename;
                    }
                    return Character.toString(codename.charAt(0));
                }
                return Integer.toString(version.getApiLevel());
            }
            return target.getName() + ':' + Integer.toString(version.getApiLevel());
        }
        return String.format("API %1$d: %2$s", version.getApiLevel(), target.getShortClasspathName());
    }

    private static class SetTargetAction
    extends ConfigurationAction {
        private final IAndroidTarget myTarget;

        public SetTargetAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull IAndroidTarget target, boolean select) {
            if (renderContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderContext", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "<init>"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "<init>"));
            }
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "<init>"));
            }
            super(renderContext, title);
            this.myTarget = target;
            if (select) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "updateConfiguration"));
            }
            if (commit) {
                this.setProjectWideTarget();
            } else {
                configuration.setTarget(this.myTarget);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file, @NotNull VirtualFile old) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "pickedBetterMatch"));
            }
            if (old == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "old", "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction", "pickedBetterMatch"));
            }
            super.pickedBetterMatch(file, old);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideTarget();
            }
        }

        private void setProjectWideTarget() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setTarget(this.myTarget);
            }
        }
    }

    private static class TogglePickBestAction
    extends ToggleAction {
        private final ConfigurationManager myManager;

        TogglePickBestAction(ConfigurationManager manager) {
            super("Automatically Pick Best");
            this.myManager = manager;
            if (manager.getStateManager().getProjectState().isPickTarget()) {
                this.getTemplatePresentation().setIcon(AllIcons.Actions.Checked);
            }
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myManager.getStateManager().getProjectState().isPickTarget();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myManager.getStateManager().getProjectState().setPickTarget(state);
            if (state) {
                this.myManager.setTarget(null);
            }
        }
    }
}

