/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.values;

import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public abstract class GradleValue {
    @NotNull
    protected final GradleDslElement myDslElement;

    protected GradleValue(@NotNull GradleDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/values/GradleValue", "<init>"));
        }
        this.myDslElement = dslElement;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myDslElement.getDslFile().getFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/values/GradleValue", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public String getPropertyName() {
        String string = this.myDslElement.getQualifiedName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/values/GradleValue", "getPropertyName"));
        }
        return string;
    }

    @Nullable
    public String getDslText() {
        GroovyPsiElement psiElement = this.myDslElement.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @NotNull
    public Map<String, GradleNotNullValue<Object>> getResolvedVariables() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GradleResolvedVariable variable : this.myDslElement.getResolvedVariables()) {
            String variableName = variable.getVariableName();
            Object resolvedValue = variable.getValue();
            GradleDslElement element = variable.getElement();
            builder.put((Object)variableName, new GradleNotNullValue<Object>(element, resolvedValue));
        }
        ImmutableMap immutableMap = builder.build();
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/values/GradleValue", "getResolvedVariables"));
        }
        return immutableMap;
    }
}

