/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.android;

import com.android.builder.model.Library;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidArtifact;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.util.PlatformIcons;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsLibraryAndroidDependency
extends PsAndroidDependency
implements PsLibraryDependency {
    @NotNull
    private final List<PsArtifactDependencySpec> myPomDependencies;
    @NotNull
    private final Set<String> myTransitiveDependencies;
    @NotNull
    private PsArtifactDependencySpec myResolvedSpec;
    @Nullable
    private final Library myResolvedModel;
    @Nullable
    private PsArtifactDependencySpec myDeclaredSpec;

    PsLibraryAndroidDependency(@NotNull PsAndroidModule parent, @NotNull PsArtifactDependencySpec resolvedSpec, @NotNull PsAndroidArtifact container, @Nullable Library resolvedModel, @Nullable ArtifactDependencyModel parsedModel) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "<init>"));
        }
        if (resolvedSpec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedSpec", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "<init>"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "<init>"));
        }
        super(parent, container, parsedModel);
        this.myPomDependencies = Lists.newArrayList();
        this.myTransitiveDependencies = Sets.newHashSet();
        this.myResolvedSpec = resolvedSpec;
        this.myResolvedModel = resolvedModel;
        if (parsedModel != null) {
            this.setDeclaredSpec(this.createSpec(parsedModel));
        }
    }

    @Nullable
    public Library getResolvedModel() {
        return this.myResolvedModel;
    }

    void addTransitiveDependency(@NotNull String dependency) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "addTransitiveDependency"));
        }
        this.myTransitiveDependencies.add(dependency);
    }

    void setDependenciesFromPomFile(@NotNull List<PsArtifactDependencySpec> pomDependencies) {
        if (pomDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pomDependencies", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "setDependenciesFromPomFile"));
        }
        this.myPomDependencies.clear();
        this.myPomDependencies.addAll(pomDependencies);
    }

    @Override
    @NotNull
    public ImmutableCollection<PsDependency> getTransitiveDependencies() {
        PsLibraryAndroidDependency found;
        PsModule module = this.getParent();
        ImmutableSet.Builder transitive = ImmutableSet.builder();
        for (String string : this.myTransitiveDependencies) {
            found = ((PsAndroidModule)module).findLibraryDependency(string);
            if (found == null) continue;
            transitive.add((Object)found);
        }
        for (PsArtifactDependencySpec psArtifactDependencySpec : this.myPomDependencies) {
            found = ((PsAndroidModule)module).findLibraryDependency(psArtifactDependencySpec);
            if (found == null) continue;
            transitive.add((Object)found);
        }
        ImmutableSet immutableSet = transitive.build();
        if (immutableSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "getTransitiveDependencies"));
        }
        return immutableSet;
    }

    @Override
    public void addParsedModel(@NotNull DependencyModel parsedModel) {
        if (parsedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parsedModel", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "addParsedModel"));
        }
        assert (parsedModel instanceof ArtifactDependencyModel);
        if (this.getParsedModels().isEmpty()) {
            this.myDeclaredSpec = PsArtifactDependencySpec.create((ArtifactDependencyModel)parsedModel);
        }
        super.addParsedModel(parsedModel);
    }

    @Override
    @Nullable
    public PsArtifactDependencySpec getDeclaredSpec() {
        return this.myDeclaredSpec;
    }

    @Override
    @NotNull
    public PsArtifactDependencySpec getResolvedSpec() {
        PsArtifactDependencySpec psArtifactDependencySpec = this.myResolvedSpec;
        if (psArtifactDependencySpec == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "getResolvedSpec"));
        }
        return psArtifactDependencySpec;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myResolvedSpec.name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PlatformIcons.LIBRARY_ICON;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "getIcon"));
        }
        return icon;
    }

    @Override
    @NotNull
    public String toText(@NotNull PsDependency.TextType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "toText"));
        }
        switch (type) {
            case PLAIN_TEXT: {
                String string = this.myResolvedSpec.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "toText"));
                }
                return string;
            }
            case FOR_NAVIGATION: {
                PsArtifactDependencySpec spec = this.myDeclaredSpec;
                if (spec == null) {
                    spec = this.myResolvedSpec;
                }
                String string = spec.toString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "toText"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "toText"));
        }
        return "";
    }

    @Override
    public boolean hasPromotedVersion() {
        if (this.myResolvedSpec.version != null && this.myDeclaredSpec != null && this.myDeclaredSpec.version != null) {
            GradleVersion declaredVersion = GradleVersion.tryParse((String)this.myDeclaredSpec.version);
            return declaredVersion != null && declaredVersion.compareTo(this.myResolvedSpec.version) < 0;
        }
        return false;
    }

    @Override
    public void setResolvedSpec(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "setResolvedSpec"));
        }
        this.myResolvedSpec = spec;
    }

    @Override
    public void setDeclaredSpec(@NotNull PsArtifactDependencySpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "spec", "com/android/tools/idea/gradle/structure/model/android/PsLibraryAndroidDependency", "setDeclaredSpec"));
        }
        this.myDeclaredSpec = spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PsLibraryAndroidDependency that = (PsLibraryAndroidDependency)o;
        return Objects.equals(this.myResolvedSpec, that.myResolvedSpec);
    }

    public int hashCode() {
        return Objects.hash(this.myDeclaredSpec);
    }

    @Override
    public String toString() {
        return this.toText(PsDependency.TextType.PLAIN_TEXT);
    }
}

