/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.ProgressRunner;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.android.sdklib.repository.targets.SystemImage;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.FormFactorUtils;
import com.android.tools.idea.npw.deprecated.ConfigureAndroidProjectPath;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.progress.StudioProgressRunner;
import com.android.tools.idea.templates.TemplateMetadata;
import com.android.tools.idea.templates.TemplateUtils;
import com.android.tools.idea.ui.ApiComboBoxItem;
import com.android.tools.idea.wizard.WizardConstants;
import com.android.tools.idea.wizard.dynamic.ScopedDataBinder;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FormFactorApiComboBox
extends JComboBox {
    private static final Set<AndroidVersion> ourInstalledVersions = Sets.newHashSet();
    private static final List<AndroidTargetComboBoxItem> ourTargets = Lists.newArrayList();
    private static IAndroidTarget ourHighestInstalledApiTarget;
    private FormFactor myFormFactor;
    private final List<String> myInstallRequests = Lists.newArrayList();
    private ScopedStateStore.Key<String> myBuildApiKey;
    private ScopedStateStore.Key<Integer> myBuildApiLevelKey;
    private ScopedStateStore.Key<Integer> myTargetApiLevelKey;
    private ScopedStateStore.Key<String> myTargetApiStringKey;
    private ScopedStateStore.Key<AndroidTargetComboBoxItem> myTargetComboBoxKey;
    private ScopedStateStore.Key<Boolean> myInclusionKey;
    private static final ProgressIndicator REPO_LOG;
    static final ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox> TARGET_COMBO_BINDING;

    public void init(@NotNull FormFactor formFactor, int minSdkLevel, @Nullable Runnable completedCallback, @Nullable Runnable foundItemsCallback, @Nullable Runnable noItemsCallback) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorApiComboBox", "init"));
        }
        this.myFormFactor = formFactor;
        FormFactorApiComboBox.loadTargets();
        FormFactorApiComboBox.loadInstalledVersions();
        this.myBuildApiKey = FormFactorUtils.getBuildApiKey(formFactor);
        this.myBuildApiLevelKey = FormFactorUtils.getBuildApiLevelKey(formFactor);
        this.myTargetApiLevelKey = FormFactorUtils.getTargetApiLevelKey(formFactor);
        this.myTargetApiStringKey = FormFactorUtils.getTargetApiStringKey(formFactor);
        this.myTargetComboBoxKey = FormFactorUtils.getTargetComboBoxKey(formFactor);
        this.myInclusionKey = FormFactorUtils.getInclusionKey(formFactor);
        this.populateComboBox(formFactor, minSdkLevel);
        if (this.getItemCount() > 0 && foundItemsCallback != null) {
            foundItemsCallback.run();
        }
        this.loadSavedApi();
        this.loadRemoteTargets(minSdkLevel, completedCallback, foundItemsCallback, noItemsCallback);
    }

    public void registerWith(@NotNull ScopedDataBinder binder) {
        if (binder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binder", "com/android/tools/idea/npw/FormFactorApiComboBox", "registerWith"));
        }
        assert (this.myFormFactor != null) : "register() called on FormFactorApiComboBox before init()";
        binder.register(FormFactorUtils.getTargetComboBoxKey(this.myFormFactor), this, TARGET_COMBO_BINDING);
    }

    public void loadSavedApi() {
        String savedApiLevel = PropertiesComponent.getInstance().getValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), Integer.toString(this.myFormFactor.defaultApi));
        this.setSelectedApiLevel(savedApiLevel);
        if (this.getSelectedIndex() < 0 && this.getItemCount() > 0) {
            this.setSelectedIndex(0);
        }
    }

    public void deriveValues(@NotNull ScopedStateStore stateStore, @NotNull Set<ScopedStateStore.Key> modified) {
        if (stateStore == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateStore", "com/android/tools/idea/npw/FormFactorApiComboBox", "deriveValues"));
        }
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/android/tools/idea/npw/FormFactorApiComboBox", "deriveValues"));
        }
        if (modified.contains(this.myTargetComboBoxKey) || modified.contains(this.myInclusionKey)) {
            AndroidSdkData sdkData;
            AndroidTargetComboBoxItem targetItem;
            if (!this.myInstallRequests.isEmpty()) {
                for (String request : this.myInstallRequests) {
                    stateStore.listRemove(WizardConstants.INSTALL_REQUESTS_KEY, request);
                }
                this.myInstallRequests.clear();
            }
            if ((targetItem = stateStore.get(this.myTargetComboBoxKey)) == null || !stateStore.getNotNull(this.myInclusionKey, false).booleanValue()) {
                return;
            }
            stateStore.put(FormFactorUtils.getMinApiKey(this.myFormFactor), targetItem.getData());
            stateStore.put(FormFactorUtils.getMinApiLevelKey(this.myFormFactor), targetItem.myApiLevel);
            IAndroidTarget target = targetItem.target;
            if (target != null && (target.getVersion().isPreview() || !target.isPlatform())) {
                this.populateApiLevels(targetItem.myApiLevel, target, stateStore);
            } else {
                int targetApiLevel = ourHighestInstalledApiTarget != null ? ourHighestInstalledApiTarget.getVersion().getFeatureLevel() : 0;
                this.populateApiLevels(targetApiLevel, ourHighestInstalledApiTarget, stateStore);
            }
            AndroidVersion androidVersion = targetItem.myAndroidVersion;
            String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)androidVersion);
            BuildToolInfo buildTool = null;
            if (target != null) {
                buildTool = target.getBuildToolInfo();
            }
            if (buildTool == null) {
                AndroidSdkHandler sdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
                buildTool = sdkHandler.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(ConfigureAndroidProjectPath.class), false);
            }
            if (buildTool != null) {
                stateStore.put(WizardConstants.BUILD_TOOLS_VERSION_KEY, buildTool.getRevision().toString());
            }
            if (targetItem.myAddon != null) {
                RemotePackage p = targetItem.myAddon;
                stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, p.getPath());
                this.myInstallRequests.add(p.getPath());
                AndroidTargetManager targetManager = AndroidSdkUtils.tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
                if (targetManager.getTargetFromHashString(AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion), REPO_LOG) == null) {
                    stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformPath);
                    this.myInstallRequests.add(platformPath);
                }
                this.populateApiLevels(targetItem.myApiLevel, null, stateStore);
            } else if (target == null && (ourHighestInstalledApiTarget == null || androidVersion.getApiLevel() > ourHighestInstalledApiTarget.getVersion().getApiLevel() && !ourInstalledVersions.contains(androidVersion))) {
                platformPath = DetailsTypes.getPlatformPath((AndroidVersion)new AndroidVersion(24, null));
                stateStore.listPush(WizardConstants.INSTALL_REQUESTS_KEY, platformPath);
                this.myInstallRequests.add(platformPath);
                this.populateApiLevels(24, null, stateStore);
            }
            PropertiesComponent.getInstance().setValue(FormFactorUtils.getPropertiesComponentMinSdkKey(this.myFormFactor), (String)targetItem.getData());
            String javaVersion = null;
            if (ourHighestInstalledApiTarget != null && ourHighestInstalledApiTarget.getVersion().getFeatureLevel() >= 21 && (sdkData = AndroidSdkUtils.tryToChooseAndroidSdk()) != null) {
                JavaSdkVersion version;
                JavaSdk jdk = JavaSdk.getInstance();
                Sdk sdk = ProjectJdkTable.getInstance().findMostRecentSdkOfType((SdkTypeId)jdk);
                if (sdk != null && (version = jdk.getVersion(sdk)) != null && version.isAtLeast(JavaSdkVersion.JDK_1_7)) {
                    javaVersion = JavaSdkVersion.JDK_1_7.getDescription();
                }
            }
            stateStore.put(FormFactorUtils.getLanguageLevelKey(this.myFormFactor), javaVersion);
        }
    }

    public void setSelectedApiLevel(String item) {
        ScopedDataBinder.setSelectedItem(this, item);
    }

    private void populateComboBox(@NotNull FormFactor formFactor, int minSdk) {
        if (formFactor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formFactor", "com/android/tools/idea/npw/FormFactorApiComboBox", "populateComboBox"));
        }
        for (AndroidTargetComboBoxItem target : Iterables.filter(ourTargets, FormFactorUtils.getMinSdkComboBoxFilter(formFactor, minSdk))) {
            if (target.myApiLevel < minSdk && (target.target == null || !target.target.getVersion().isPreview())) continue;
            this.addItem(target);
        }
    }

    private static void loadTargets() {
        ourTargets.clear();
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        if (AndroidSdkUtils.isAndroidSdkAvailable()) {
            String[] knownVersions = TemplateUtils.getKnownVersions();
            for (int i = 0; i < knownVersions.length; ++i) {
                AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(knownVersions[i], i + 1);
                ourTargets.add(targetInfo);
            }
        }
        for (IAndroidTarget target : targets) {
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourTargets.add(targetInfo);
        }
    }

    public static void loadInstalledVersions() {
        IAndroidTarget[] targets = FormFactorApiComboBox.getCompilationTargets();
        IAndroidTarget highestInstalledTarget = null;
        ourInstalledVersions.clear();
        for (IAndroidTarget target : targets) {
            if (target.isPlatform() && target.getVersion().getFeatureLevel() >= 22 && (highestInstalledTarget == null || target.getVersion().getFeatureLevel() > highestInstalledTarget.getVersion().getFeatureLevel() && !target.getVersion().isPreview())) {
                highestInstalledTarget = target;
            }
            if (!target.getVersion().isPreview() && target.getAdditionalLibraries().isEmpty()) continue;
            AndroidTargetComboBoxItem targetInfo = new AndroidTargetComboBoxItem(target);
            ourInstalledVersions.add(targetInfo.target.getVersion());
        }
        ourHighestInstalledApiTarget = highestInstalledTarget;
    }

    @NotNull
    private static IAndroidTarget[] getCompilationTargets() {
        AndroidTargetManager targetManager = AndroidSdkUtils.tryToChooseSdkHandler().getAndroidTargetManager(REPO_LOG);
        ArrayList result = Lists.newArrayList();
        for (IAndroidTarget target : targetManager.getTargets(REPO_LOG)) {
            if (!target.isPlatform()) continue;
            result.add(target);
        }
        IAndroidTarget[] iAndroidTargetArray = result.toArray(new IAndroidTarget[result.size()]);
        if (iAndroidTargetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/npw/FormFactorApiComboBox", "getCompilationTargets"));
        }
        return iAndroidTargetArray;
    }

    public void populateApiLevels(int apiLevel, @Nullable IAndroidTarget apiTarget, @NotNull ScopedStateStore state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/npw/FormFactorApiComboBox", "populateApiLevels"));
        }
        if (apiLevel >= 1) {
            if (apiTarget == null) {
                state.put(this.myBuildApiKey, Integer.toString(apiLevel));
            } else if (!apiTarget.isPlatform()) {
                state.put(this.myBuildApiKey, AndroidTargetHash.getTargetHashString((IAndroidTarget)apiTarget));
            } else {
                state.put(this.myBuildApiKey, TemplateMetadata.getBuildApiString(apiTarget.getVersion()));
            }
            state.put(this.myBuildApiLevelKey, apiLevel);
            if (apiLevel >= 25 || apiTarget != null && apiTarget.getVersion().isPreview()) {
                state.put(this.myTargetApiLevelKey, apiLevel);
                if (apiTarget != null) {
                    state.put(this.myTargetApiStringKey, apiTarget.getVersion().getApiString());
                } else {
                    state.put(this.myTargetApiStringKey, Integer.toString(apiLevel));
                }
            } else if (ourHighestInstalledApiTarget != null) {
                state.put(this.myTargetApiLevelKey, ourHighestInstalledApiTarget.getVersion().getApiLevel());
                state.put(this.myTargetApiStringKey, ourHighestInstalledApiTarget.getVersion().getApiString());
            }
        }
    }

    private void loadRemoteTargets(final int minSdkLevel, final Runnable completedCallback, final Runnable foundItemsCallback, final Runnable noItemsCallback) {
        AndroidSdkHandler sdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
        final Runnable runCallbacks = new Runnable(){

            @Override
            public void run() {
                if (completedCallback != null) {
                    completedCallback.run();
                }
                if (FormFactorApiComboBox.this.getItemCount() > 0) {
                    if (foundItemsCallback != null) {
                        foundItemsCallback.run();
                    }
                } else if (noItemsCallback != null) {
                    noItemsCallback.run();
                }
            }
        };
        RepoManager.RepoLoadedCallback onComplete = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/npw/FormFactorApiComboBox$3", "doRun"));
                }
                FormFactorApiComboBox.this.addPackages(packages.getNewPkgs(), minSdkLevel);
                FormFactorApiComboBox.this.addOfflineLevels();
                FormFactorApiComboBox.this.loadSavedApi();
                runCallbacks.run();
            }
        };
        RepoManager.RepoLoadedCallback onLocalComplete = new RepoManager.RepoLoadedCallback(){

            public void doRun(@NotNull RepositoryPackages packages) {
                if (packages == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/npw/FormFactorApiComboBox$4", "doRun"));
                }
                FormFactorApiComboBox.this.addPackages(packages.getLocalPackages().values(), minSdkLevel);
            }
        };
        Runnable onError = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FormFactorApiComboBox.this.addOfflineLevels();
                        runCallbacks.run();
                    }
                }, ModalityState.any());
            }
        };
        StudioProgressRunner runner = new StudioProgressRunner(false, true, false, "Refreshing Targets", true, null);
        sdkHandler.getSdkManager(REPO_LOG).load(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (List)ImmutableList.of((Object)onLocalComplete), (List)ImmutableList.of((Object)onComplete), (List)ImmutableList.of((Object)onError), (ProgressRunner)runner, (Downloader)new StudioDownloader(), StudioSettingsController.getInstance(), false);
    }

    private void addPackages(@NotNull Collection<? extends RepoPackage> packages, int minSdkLevel) {
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/android/tools/idea/npw/FormFactorApiComboBox", "addPackages"));
        }
        Iterable filter = Iterables.filter(packages, FormFactorUtils.getMinSdkPackageFilter(this.myFormFactor, minSdkLevel));
        ArrayList sorted = Lists.newArrayList((Iterable)filter);
        Collections.sort(sorted, new Comparator<RepoPackage>(){

            @Override
            public int compare(@NotNull RepoPackage repoPackage, @NotNull RepoPackage other) {
                if (repoPackage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repoPackage", "com/android/tools/idea/npw/FormFactorApiComboBox$6", "compare"));
                }
                if (other == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/android/tools/idea/npw/FormFactorApiComboBox$6", "compare"));
                }
                return FormFactorUtils.getAndroidVersion(repoPackage).compareTo(FormFactorUtils.getAndroidVersion(other));
            }
        });
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (RepoPackage info : sorted) {
            int apiLevel = FormFactorUtils.getFeatureLevel(info);
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < this.getItemCount() ? ((AndroidTargetComboBoxItem)this.getItemAt(index)).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            this.insertItemAt(new AndroidTargetComboBoxItem(info), index++);
            prevInsertedApiLevel = apiLevel;
        }
    }

    private void addOfflineLevels() {
        int existingApiLevel = -1;
        int prevInsertedApiLevel = -1;
        int index = -1;
        for (int apiLevel = this.myFormFactor.getMinOfflineApiLevel(); apiLevel <= this.myFormFactor.getMaxOfflineApiLevel(); ++apiLevel) {
            if (this.myFormFactor.getApiBlacklist().contains(apiLevel) || apiLevel <= 0) continue;
            while (apiLevel > existingApiLevel) {
                existingApiLevel = ++index < this.getItemCount() ? ((AndroidTargetComboBoxItem)this.getItemAt(index)).myApiLevel : Integer.MAX_VALUE;
            }
            if (apiLevel == existingApiLevel || apiLevel == prevInsertedApiLevel) continue;
            this.insertItemAt(new AndroidTargetComboBoxItem(apiLevel), index++);
            prevInsertedApiLevel = apiLevel;
        }
    }

    static {
        REPO_LOG = new StudioLoggerProgressIndicator(FormFactorApiComboBox.class);
        TARGET_COMBO_BINDING = new ScopedDataBinder.ComponentBinding<AndroidTargetComboBoxItem, JComboBox>(){

            @Override
            public void setValue(@Nullable AndroidTargetComboBoxItem newValue, @NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "setValue"));
                }
                component.setSelectedItem(newValue);
            }

            @Override
            @Nullable
            public AndroidTargetComboBoxItem getValue(@NotNull JComboBox component) {
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "getValue"));
                }
                return (AndroidTargetComboBoxItem)component.getItemAt(component.getSelectedIndex());
            }

            @Override
            public void addActionListener(@NotNull ActionListener listener, @NotNull JComboBox component) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "addActionListener"));
                }
                if (component == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/npw/FormFactorApiComboBox$1", "addActionListener"));
                }
                component.addActionListener(listener);
            }
        };
    }

    public static class AndroidTargetComboBoxItem
    extends ApiComboBoxItem<String> {
        private int myApiLevel;
        private AndroidVersion myAndroidVersion;
        public IAndroidTarget target;
        public RemotePackage myAddon;

        private AndroidTargetComboBoxItem(@NotNull AndroidVersion androidVersion, IdDisplay tag) {
            if (androidVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "androidVersion", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "<init>"));
            }
            super(androidVersion.getApiString(), AndroidTargetComboBoxItem.getLabel(androidVersion, tag), 1, 1);
            this.myApiLevel = -1;
            this.target = null;
            this.myAddon = null;
            this.myAndroidVersion = androidVersion;
            this.myApiLevel = androidVersion.getFeatureLevel();
        }

        public AndroidTargetComboBoxItem(String label, int apiLevel) {
            super(Integer.toString(apiLevel), label, 1, 1);
            this.myApiLevel = -1;
            this.target = null;
            this.myAddon = null;
            this.myAndroidVersion = new AndroidVersion(apiLevel, null);
            this.myApiLevel = apiLevel;
        }

        public AndroidTargetComboBoxItem(int apiLevel) {
            this(new AndroidVersion(apiLevel, null), SystemImage.DEFAULT_TAG);
        }

        public AndroidTargetComboBoxItem(@NotNull IAndroidTarget target) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "<init>"));
            }
            this(target.getVersion(), SystemImage.DEFAULT_TAG);
            this.target = target;
        }

        public AndroidTargetComboBoxItem(@NotNull RepoPackage info) {
            if (info == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "<init>"));
            }
            this(FormFactorUtils.getAndroidVersion(info), FormFactorUtils.getTag(info));
            if (info instanceof RemotePackage && SystemImage.GLASS_TAG.equals((Object)FormFactorUtils.getTag(info))) {
                this.myAddon = (RemotePackage)info;
            }
        }

        public int getApiLevel() {
            return this.myApiLevel;
        }

        private static String getLabel(@NotNull AndroidVersion version, @Nullable IdDisplay tag) {
            if (version == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/android/tools/idea/npw/FormFactorApiComboBox$AndroidTargetComboBoxItem", "getLabel"));
            }
            int featureLevel = version.getFeatureLevel();
            if (SystemImage.GLASS_TAG.equals((Object)tag)) {
                return String.format("Glass Development Kit Preview (API %1$d)", featureLevel);
            }
            if (featureLevel <= 25) {
                if (version.isPreview()) {
                    return String.format("API %1$s: Android %2$s (%3$s preview)", SdkVersionInfo.getCodeName((int)featureLevel), SdkVersionInfo.getVersionString((int)featureLevel), SdkVersionInfo.getCodeName((int)featureLevel));
                }
                return SdkVersionInfo.getAndroidName((int)featureLevel);
            }
            if (version.isPreview()) {
                return String.format("API %1$d: Android (%2$s)", featureLevel, version.getCodename());
            }
            return String.format("API %1$d: Android", featureLevel);
        }
    }
}

