/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import com.android.tools.idea.uibuilder.model.NlComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResizePolicy {
    private static final int NONE = 0;
    private static final int LEFT_EDGE = 1;
    private static final int RIGHT_EDGE = 2;
    private static final int TOP_EDGE = 4;
    private static final int BOTTOM_EDGE = 8;
    private static final int PRESERVE_RATIO = 16;
    private static final int HORIZONTAL = 3;
    private static final int VERTICAL = 12;
    private static final int ANY = 15;
    private static final ResizePolicy ourAny = new ResizePolicy(15);
    private static final ResizePolicy ourNone = new ResizePolicy(0);
    private static final ResizePolicy ourHorizontal = new ResizePolicy(3);
    private static final ResizePolicy ourVertical = new ResizePolicy(12);
    private static final ResizePolicy ourScaled = new ResizePolicy(31);
    private final int myFlags;

    private ResizePolicy(int flags) {
        this.myFlags = flags;
    }

    public boolean isResizable() {
        return (this.myFlags & 0xF) != 0;
    }

    public boolean topAllowed() {
        return (this.myFlags & 4) != 0;
    }

    public boolean rightAllowed() {
        return (this.myFlags & 2) != 0;
    }

    public boolean bottomAllowed() {
        return (this.myFlags & 8) != 0;
    }

    public boolean leftAllowed() {
        return (this.myFlags & 1) != 0;
    }

    public boolean isAspectPreserving() {
        return (this.myFlags & 0x10) != 0;
    }

    @NotNull
    public static ResizePolicy full() {
        ResizePolicy resizePolicy = ourAny;
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/ResizePolicy", "full"));
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy none() {
        ResizePolicy resizePolicy = ourNone;
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/ResizePolicy", "none"));
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy horizontal() {
        ResizePolicy resizePolicy = ourHorizontal;
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/ResizePolicy", "horizontal"));
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy vertical() {
        ResizePolicy resizePolicy = ourVertical;
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/ResizePolicy", "vertical"));
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy scaled() {
        ResizePolicy resizePolicy = ourScaled;
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/ResizePolicy", "scaled"));
        }
        return resizePolicy;
    }

    @NotNull
    public static ResizePolicy create(boolean top, boolean right, boolean bottom, boolean left, boolean preserve) {
        int mask = 0;
        if (top) {
            mask |= 4;
        }
        if (right) {
            mask |= 2;
        }
        if (bottom) {
            mask |= 8;
        }
        if (left) {
            mask |= 1;
        }
        if (preserve) {
            mask |= 0x10;
        }
        ResizePolicy resizePolicy = new ResizePolicy(mask);
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/ResizePolicy", "create"));
        }
        return resizePolicy;
    }

    @Nullable
    public static ResizePolicy get(@Nullable String resize) {
        if (resize != null && resize.length() > 0) {
            if ("full".equals(resize)) {
                return ResizePolicy.full();
            }
            if ("none".equals(resize)) {
                return ResizePolicy.none();
            }
            if ("horizontal".equals(resize)) {
                return ResizePolicy.horizontal();
            }
            if ("vertical".equals(resize)) {
                return ResizePolicy.vertical();
            }
            if ("scaled".equals(resize)) {
                return ResizePolicy.scaled();
            }
            assert (false) : resize;
        }
        return null;
    }

    @NotNull
    public static ResizePolicy getResizePolicy(@NotNull NlComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/android/tools/idea/uibuilder/model/ResizePolicy", "getResizePolicy"));
        }
        ResizePolicy resizePolicy = ourAny;
        if (resizePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/model/ResizePolicy", "getResizePolicy"));
        }
        return resizePolicy;
    }
}

