/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.repository.Revision;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.IdDisplay;
import com.android.sdklib.repository.legacy.descriptors.IPkgDesc;
import com.android.sdklib.repository.legacy.descriptors.PkgDesc;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.ElevatedCommandLine;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.InstallContext;
import com.android.tools.idea.welcome.install.InstallableComponent;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.wizard.ProgressStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class Haxm
extends InstallableComponent {
    public static final Storage.Unit UI_UNITS = Storage.Unit.MiB;
    public static final Logger LOG = Logger.getInstance(Haxm.class);
    public static final IdDisplay ID_INTEL = IdDisplay.create((String)"intel", (String)"");
    public static final String COMPONENT_PATH = "Hardware_Accelerated_Execution_Manager";
    public static final String REPO_PACKAGE_PATH = "extras;intel;Hardware_Accelerated_Execution_Manager";
    public static final String RUNNING_INTEL_HAXM_INSTALLER_MESSAGE = "Running Intel\u00ae HAXM installer";
    private static final ScopedStateStore.Key<Integer> KEY_EMULATOR_MEMORY_MB = ScopedStateStore.createKey("emulator.memory", ScopedStateStore.Scope.PATH, Integer.class);
    private final ScopedStateStore.Key<Boolean> myIsCustomInstall;
    private ProgressStep myProgressStep;
    private static AccelerationErrorCode ourInitialCheck;

    public static boolean canRun() {
        if (ourInitialCheck == null) {
            ourInitialCheck = Haxm.checkHaxmInstallation();
        }
        switch (ourInitialCheck) {
            case NO_EMULATOR_INSTALLED: 
            case UNKNOWN_ERROR: {
                return SystemInfo.isMac || SystemInfo.isWindows;
            }
            case NOT_ENOUGH_MEMORY: 
            case ALREADY_INSTALLED: {
                return false;
            }
        }
        switch (ourInitialCheck.getSolution()) {
            case INSTALL_HAXM: 
            case REINSTALL_HAXM: {
                return true;
            }
        }
        return false;
    }

    public static AccelerationErrorCode checkHaxmInstallation() {
        if (!SystemInfo.isWindows && !SystemInfo.isMac) {
            return AccelerationErrorCode.CANNOT_INSTALL_ON_THIS_OS;
        }
        AvdManagerConnection manager = AvdManagerConnection.getDefaultAvdManagerConnection();
        return manager.checkAcceration();
    }

    public Haxm(@NotNull ScopedStateStore store, ScopedStateStore.Key<Boolean> isCustomInstall, boolean installUpdates) {
        if (store == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "store", "com/android/tools/idea/welcome/install/Haxm", "<init>"));
        }
        super(store, "Performance (Intel \u00ae HAXM)", "Enables a hardware-assisted virtualization engine (hypervisor) to speed up Android app emulation on your development computer. (Recommended)", installUpdates, FileOpUtils.create());
        this.myIsCustomInstall = isCustomInstall;
    }

    @NotNull
    private static GeneralCommandLine addInstallParameters(@NotNull GeneralCommandLine cl, int memorySize) {
        if (cl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cl", "com/android/tools/idea/welcome/install/Haxm", "addInstallParameters"));
        }
        cl.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        GeneralCommandLine generalCommandLine = cl;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "addInstallParameters"));
        }
        return generalCommandLine;
    }

    private static GeneralCommandLine getMacHaxmCommandLine(File path) throws WizardException {
        Haxm.ensureExistsAndIsExecutable(path, "silent_install.sh");
        File executable = Haxm.ensureExistsAndIsExecutable(path, "HAXM installation");
        return new GeneralCommandLine(new String[]{executable.getAbsolutePath()}).withWorkDirectory(path);
    }

    @NotNull
    private static File ensureExistsAndIsExecutable(File path, String exeName) throws WizardException {
        File executable = new File(path, exeName);
        if (!executable.isFile()) {
            throw new WizardException("HAXM installer executable is missing: " + executable.getAbsolutePath());
        }
        if (executable.canExecute() || executable.setExecutable(true)) {
            File file = executable;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "ensureExistsAndIsExecutable"));
            }
            return file;
        }
        throw new WizardException("Unable to set execute permission bit on HAXM installer executable: " + executable.getAbsolutePath());
    }

    @NotNull
    private static GeneralCommandLine getWindowsHaxmCommandLine(File source) {
        File batFile = new File(source, "silent_install.bat");
        GeneralCommandLine generalCommandLine = new ElevatedCommandLine(batFile.getAbsolutePath()).withWorkDirectory(source);
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getWindowsHaxmCommandLine"));
        }
        return generalCommandLine;
    }

    private static int getRecommendedMemoryAllocation() {
        return FirstRunWizardDefaults.getRecommendedHaxmMemory(AvdManagerConnection.getMemorySize());
    }

    @NotNull
    private static IPkgDesc createExtra(@NotNull IdDisplay vendor, @NotNull String path) {
        if (vendor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vendor", "com/android/tools/idea/welcome/install/Haxm", "createExtra"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/welcome/install/Haxm", "createExtra"));
        }
        IPkgDesc iPkgDesc = PkgDesc.Builder.newExtra((IdDisplay)vendor, (String)path, (String)"", null, (Revision)new Revision(0)).create();
        if (iPkgDesc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "createExtra"));
        }
        return iPkgDesc;
    }

    @Override
    public void init(@NotNull ProgressStep progressStep) {
        if (progressStep == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressStep", "com/android/tools/idea/welcome/install/Haxm", "init"));
        }
        this.myProgressStep = progressStep;
        this.myStateStore.put(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        Set<DynamicWizardStep> set = Collections.singleton(new HaxmInstallSettingsStep(this.myIsCustomInstall, this.myKey, KEY_EMULATOR_MEMORY_MB));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "createSteps"));
        }
        return set;
    }

    @Override
    public void configure(@NotNull InstallContext installContext, @NotNull AndroidSdkHandler sdkHandler) {
        if (installContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "installContext", "com/android/tools/idea/welcome/install/Haxm", "configure"));
        }
        if (sdkHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkHandler", "com/android/tools/idea/welcome/install/Haxm", "configure"));
        }
        AccelerationErrorCode error = Haxm.checkHaxmInstallation();
        if (error == AccelerationErrorCode.ALREADY_INSTALLED) {
            return;
        }
        switch (error.getSolution()) {
            case INSTALL_HAXM: 
            case REINSTALL_HAXM: {
                try {
                    GeneralCommandLine commandLine = this.getInstallCommandLine(sdkHandler.getLocation());
                    this.runInstaller(installContext, commandLine);
                }
                catch (WizardException e) {
                    LOG.error(String.format("Tried to install HAXM on %s OS with %s memory size", Platform.current().name(), String.valueOf(AvdManagerConnection.getMemorySize())));
                    installContext.print("Unable to install Intel HAXM\n", ConsoleViewContentType.ERROR_OUTPUT);
                    String message = e.getMessage();
                    if (!StringUtil.endsWithLineBreak((CharSequence)message)) {
                        message = message + "\n";
                    }
                    installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
                    LOG.error((Throwable)e);
                }
                break;
            }
            case NONE: {
                String message = String.format("Unable to install Intel HAXM\n%1$s\n%2$s\n", error.getProblem(), error.getSolutionMessage());
                installContext.print(message, ConsoleViewContentType.ERROR_OUTPUT);
                break;
            }
        }
    }

    private void runInstaller(InstallContext installContext, GeneralCommandLine commandLine) {
        try {
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            progressIndicator.setIndeterminate(true);
            progressIndicator.setText(RUNNING_INTEL_HAXM_INSTALLER_MESSAGE);
            installContext.print("Running Intel\u00ae HAXM installer\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            CapturingAnsiEscapesAwareProcessHandler process = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
            final StringBuffer output = new StringBuffer();
            process.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    output.append(event.getText());
                    super.onTextAvailable(event, outputType);
                }
            });
            this.myProgressStep.attachToProcess((ProcessHandler)process);
            int exitCode = process.runProcess().getExitCode();
            if (exitCode != 0) {
                installContext.print(String.format("HAXM installation failed. To install HAXM follow the instructions found at: %s", SystemInfo.isWindows ? "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-windows" : "https://software.intel.com/android/articles/installation-instructions-for-intel-hardware-accelerated-execution-manager-mac-os-x"), ConsoleViewContentType.ERROR_OUTPUT);
                Matcher m = Pattern.compile("installation log:\\s*\"(.*)\"").matcher(output.toString());
                if (m.find()) {
                    String file = m.group(1);
                    try {
                        installContext.print("Installer log:\n", ConsoleViewContentType.ERROR_OUTPUT);
                        installContext.print(FileUtil.loadFile((File)new File(file), (String)"UTF-16"), ConsoleViewContentType.NORMAL_OUTPUT);
                    }
                    catch (IOException e) {
                        installContext.print("Failed to read installer output log.\n", ConsoleViewContentType.ERROR_OUTPUT);
                    }
                }
            }
            progressIndicator.setFraction(1.0);
        }
        catch (ExecutionException e) {
            installContext.print("Unable to run Intel HAXM installer: " + e.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private GeneralCommandLine getInstallCommandLine(File sdk) throws WizardException {
        int memorySize = this.myStateStore.getNotNull(KEY_EMULATOR_MEMORY_MB, Haxm.getRecommendedMemoryAllocation());
        String path = FileUtil.join((String[])new String[]{"extras", ID_INTEL.getId(), COMPONENT_PATH});
        File sourceLocation = new File(sdk, path);
        if (SystemInfo.isMac) {
            GeneralCommandLine generalCommandLine = Haxm.addInstallParameters(Haxm.getMacHaxmCommandLine(sourceLocation), memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getInstallCommandLine"));
            }
            return generalCommandLine;
        }
        if (SystemInfo.isWindows) {
            GeneralCommandLine generalCommandLine = Haxm.addInstallParameters(Haxm.getWindowsHaxmCommandLine(sourceLocation), memorySize);
            if (generalCommandLine == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getInstallCommandLine"));
            }
            return generalCommandLine;
        }
        assert (!Haxm.canRun());
        throw new IllegalStateException("Unsupported OS");
    }

    @Override
    @NotNull
    protected Collection<String> getRequiredSdkPackages() {
        ImmutableList immutableList = ImmutableList.of((Object)REPO_PACKAGE_PATH);
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/welcome/install/Haxm", "getRequiredSdkPackages"));
        }
        return immutableList;
    }
}

