/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.EditorFontsConstants;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FontComboBox;
import com.intellij.ui.FontInfoRenderer;
import com.intellij.ui.TooltipWithClickableLinks;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontOptions
extends JPanel
implements OptionsPanel {
    private static final FontInfoRenderer RENDERER = new FontInfoRenderer(){

        @Override
        protected boolean isEditorFont() {
            return true;
        }
    };
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher;
    @NotNull
    private final ColorAndFontOptions myOptions;
    @NotNull
    private final JTextField myEditorFontSizeField;
    @NotNull
    private final JTextField myLineSpacingField;
    private final FontComboBox myPrimaryCombo;
    private final JCheckBox myUseSecondaryFontCheckbox;
    private final JCheckBox myEnableLigaturesCheckbox;
    private final FontComboBox mySecondaryCombo;
    @NotNull
    private final JBCheckBox myOnlyMonospacedCheckBox;
    private boolean myIsInSchemeChange;

    public FontOptions(@NotNull ColorAndFontOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/application/options/colors/FontOptions", "<init>"));
        }
        this.myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
        this.myEditorFontSizeField = new JTextField(4);
        this.myLineSpacingField = new JTextField(4);
        this.myPrimaryCombo = new FontComboBox();
        this.myUseSecondaryFontCheckbox = new JCheckBox(ApplicationBundle.message((String)"secondary.font", (Object[])new Object[0]));
        this.myEnableLigaturesCheckbox = new JCheckBox(ApplicationBundle.message((String)"use.ligatures", (Object[])new Object[0]));
        this.mySecondaryCombo = new FontComboBox(false, false);
        this.myOnlyMonospacedCheckBox = new JBCheckBox(ApplicationBundle.message((String)"checkbox.show.only.monospaced.fonts", (Object[])new Object[0]));
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 5, flowx"));
        this.myOptions = options;
        this.add((Component)this.myOnlyMonospacedCheckBox, "newline 10, sgx b, sx 2");
        this.add((Component)new JLabel(ApplicationBundle.message((String)"primary.font", (Object[])new Object[0])), "newline, ax right");
        this.add((Component)((Object)this.myPrimaryCombo), "sgx b");
        this.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.font.size", (Object[])new Object[0])), "gapleft 20");
        this.add(this.myEditorFontSizeField);
        this.add((Component)new JLabel(ApplicationBundle.message((String)"editbox.line.spacing", (Object[])new Object[0])), "gapleft 20");
        this.add(this.myLineSpacingField);
        this.add((Component)new JLabel(ApplicationBundle.message((String)"label.fallback.fonts.list.description", (Object[])new Object[0]), MessageType.INFO.getDefaultIcon(), 2), "newline, sx 5");
        this.add((Component)this.myUseSecondaryFontCheckbox, "newline, ax right");
        this.add((Component)((Object)this.mySecondaryCombo), "sgx b");
        JPanel panel2 = new JPanel(new FlowLayout(1, 0, 0));
        this.myEnableLigaturesCheckbox.setBorder(null);
        panel2.add(this.myEnableLigaturesCheckbox);
        JLabel warningIcon = new JLabel(AllIcons.General.BalloonWarning);
        IdeTooltipManager.getInstance().setCustomTooltip(warningIcon, new TooltipWithClickableLinks.ForBrowser(warningIcon, ApplicationBundle.message((String)"ligatures.jre.warning", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()})));
        warningIcon.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        warningIcon.setVisible(!SystemInfo.isJetbrainsJvm);
        panel2.add(warningIcon);
        this.add((Component)panel2, "newline, sx 2");
        this.myOnlyMonospacedCheckBox.setBorder(null);
        this.myUseSecondaryFontCheckbox.setBorder(null);
        this.mySecondaryCombo.setEnabled(false);
        this.myOnlyMonospacedCheckBox.setSelected(EditorColorsManager.getInstance().isUseOnlyMonospacedFonts());
        this.myOnlyMonospacedCheckBox.addActionListener(e -> {
            EditorColorsManager.getInstance().setUseOnlyMonospacedFonts(this.myOnlyMonospacedCheckBox.isSelected());
            this.myPrimaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
            this.mySecondaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        });
        this.myPrimaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        this.myPrimaryCombo.setRenderer((ListCellRenderer)((Object)RENDERER));
        this.mySecondaryCombo.setMonospacedOnly(this.myOnlyMonospacedCheckBox.isSelected());
        this.mySecondaryCombo.setRenderer((ListCellRenderer)((Object)RENDERER));
        this.myUseSecondaryFontCheckbox.addActionListener(e -> {
            this.mySecondaryCombo.setEnabled(this.myUseSecondaryFontCheckbox.isSelected());
            this.syncFontFamilies();
        });
        ItemListener itemListener = this::syncFontFamilies;
        this.myPrimaryCombo.addItemListener(itemListener);
        this.mySecondaryCombo.addItemListener(itemListener);
        ActionListener actionListener = this::syncFontFamilies;
        this.myPrimaryCombo.addActionListener(actionListener);
        this.mySecondaryCombo.addActionListener(actionListener);
        this.myEditorFontSizeField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                if (FontOptions.this.myIsInSchemeChange || !SwingUtilities.isEventDispatchThread()) {
                    return;
                }
                String selectedFont = FontOptions.this.myPrimaryCombo.getFontName();
                if (selectedFont != null) {
                    FontOptions.this.setFontSize(FontOptions.this.getFontSizeFromField());
                }
                FontOptions.this.updateDescription(true);
            }
        });
        this.myEditorFontSizeField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    int value = Integer.parseInt(FontOptions.this.myEditorFontSizeField.getText());
                    value += up ? 1 : -1;
                    value = Math.min(EditorFontsConstants.getMaxEditorFontSize(), Math.max(EditorFontsConstants.getMinEditorFontSize(), value));
                    FontOptions.this.myEditorFontSizeField.setText(String.valueOf(value));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.myLineSpacingField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                if (FontOptions.this.myIsInSchemeChange) {
                    return;
                }
                float lineSpacing = FontOptions.this.getLineSpacingFromField();
                if (FontOptions.this.getLineSpacing() != lineSpacing) {
                    FontOptions.this.setCurrentLineSpacing(lineSpacing);
                }
                FontOptions.this.updateDescription(true);
            }
        });
        this.myLineSpacingField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40) {
                    return;
                }
                boolean up = e.getKeyCode() == 38;
                try {
                    float value = Float.parseFloat(FontOptions.this.myLineSpacingField.getText());
                    value += (float)(up ? 1 : -1) * 0.1f;
                    value = Math.min(EditorFontsConstants.getMaxEditorLineSpacing(), Math.max(EditorFontsConstants.getMinEditorLineSpacing(), value));
                    FontOptions.this.myLineSpacingField.setText(String.format(Locale.ENGLISH, "%.1f", Float.valueOf(value)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.myEnableLigaturesCheckbox.addActionListener(e -> {
            this.getFontPreferences().setUseLigatures(this.myEnableLigaturesCheckbox.isSelected());
            this.updateDescription(true);
        });
    }

    private int getFontSizeFromField() {
        try {
            return Math.min(EditorFontsConstants.getMaxEditorFontSize(), Math.max(EditorFontsConstants.getMinEditorFontSize(), Integer.parseInt(this.myEditorFontSizeField.getText())));
        }
        catch (NumberFormatException e) {
            return EditorFontsConstants.getDefaultEditorFontSize();
        }
    }

    private float getLineSpacingFromField() {
        try {
            return Math.min(EditorFontsConstants.getMaxEditorLineSpacing(), Math.max(EditorFontsConstants.getMinEditorLineSpacing(), Float.parseFloat(this.myLineSpacingField.getText())));
        }
        catch (NumberFormatException e) {
            return EditorFontsConstants.getDefaultEditorLineSpacing();
        }
    }

    private void syncFontFamilies(AWTEvent event) {
        FontComboBox combo;
        Object source = event.getSource();
        if (source instanceof FontComboBox && (combo = (FontComboBox)((Object)source)).isEnabled() && combo.isShowing() && combo.getSelectedItem() != null) {
            this.syncFontFamilies();
        }
    }

    private void syncFontFamilies() {
        if (this.myIsInSchemeChange) {
            return;
        }
        FontPreferences fontPreferences = this.getFontPreferences();
        fontPreferences.clearFonts();
        String primaryFontFamily = this.myPrimaryCombo.getFontName();
        String secondaryFontFamily = this.mySecondaryCombo.isEnabled() ? this.mySecondaryCombo.getFontName() : null;
        int fontSize = this.getFontSizeFromField();
        if (primaryFontFamily != null) {
            if (!FontPreferences.DEFAULT_FONT_NAME.equals(primaryFontFamily)) {
                fontPreferences.addFontFamily(primaryFontFamily);
            }
            fontPreferences.register(primaryFontFamily, fontSize);
        }
        if (secondaryFontFamily != null) {
            if (!FontPreferences.DEFAULT_FONT_NAME.equals(secondaryFontFamily)) {
                fontPreferences.addFontFamily(secondaryFontFamily);
            }
            fontPreferences.register(secondaryFontFamily, fontSize);
        }
        this.updateDescription(true);
    }

    @Override
    public void updateOptionsList() {
        this.myIsInSchemeChange = true;
        this.myLineSpacingField.setText(Float.toString(this.getLineSpacing()));
        FontPreferences fontPreferences = this.getFontPreferences();
        List fontFamilies = fontPreferences.getEffectiveFontFamilies();
        this.myPrimaryCombo.setFontName(fontPreferences.getFontFamily());
        boolean isThereSecondaryFont = fontFamilies.size() > 1;
        this.myUseSecondaryFontCheckbox.setSelected(isThereSecondaryFont);
        this.mySecondaryCombo.setFontName(isThereSecondaryFont ? (String)fontFamilies.get(1) : null);
        this.myEditorFontSizeField.setText(String.valueOf(fontPreferences.getSize(fontPreferences.getFontFamily())));
        boolean readOnly = ColorAndFontOptions.isReadOnly(this.myOptions.getSelectedScheme());
        this.myPrimaryCombo.setEnabled(!readOnly);
        this.mySecondaryCombo.setEnabled(isThereSecondaryFont && !readOnly);
        this.myOnlyMonospacedCheckBox.setEnabled(!readOnly);
        this.myLineSpacingField.setEnabled(!readOnly);
        this.myEditorFontSizeField.setEnabled(!readOnly);
        this.myUseSecondaryFontCheckbox.setEnabled(!readOnly);
        this.myEnableLigaturesCheckbox.setEnabled(!readOnly && SystemInfo.isJetbrainsJvm);
        this.myEnableLigaturesCheckbox.setSelected(fontPreferences.useLigatures());
        this.myIsInSchemeChange = false;
    }

    @NotNull
    protected FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.getCurrentScheme().getFontPreferences();
        if (fontPreferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/FontOptions", "getFontPreferences"));
        }
        return fontPreferences;
    }

    protected void setFontSize(int fontSize) {
        this.getCurrentScheme().setEditorFontSize(fontSize);
    }

    protected float getLineSpacing() {
        return this.getCurrentScheme().getLineSpacing();
    }

    protected void setCurrentLineSpacing(float lineSpacing) {
        this.getCurrentScheme().setLineSpacing(lineSpacing);
    }

    @Override
    @Nullable
    public Runnable showOption(String option) {
        return null;
    }

    @Override
    public void applyChangesToScheme() {
    }

    @Override
    public void selectOption(String typeToSelect) {
    }

    protected EditorColorsScheme getCurrentScheme() {
        return this.myOptions.getSelectedScheme();
    }

    public boolean updateDescription(boolean modified) {
        EditorColorsScheme scheme2 = this.myOptions.getSelectedScheme();
        if (modified && ColorAndFontOptions.isReadOnly(scheme2)) {
            return false;
        }
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).fontChanged();
        return true;
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public Set<String> processListOptions() {
        return new HashSet<String>();
    }
}

