/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesPanel
extends SimpleSchemesPanel<EditorColorsScheme>
implements SkipSelfSearchComponent {
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myListLoaded = false;

    public SchemesPanel(ColorAndFontOptions options) {
        this.myOptions = options;
    }

    public boolean areSchemesLoaded() {
        return this.myListLoaded;
    }

    @Deprecated
    public boolean updateDescription(boolean modified) {
        EditorColorsScheme scheme2 = this.myOptions.getSelectedScheme();
        return !modified || !ColorAndFontOptions.isReadOnly(scheme2);
    }

    public void resetSchemesCombo(Object source) {
        if (this != source) {
            this.setListLoaded(false);
            EditorColorsScheme selectedSchemeBackup = this.myOptions.getSelectedScheme();
            this.resetSchemes(this.myOptions.getOrderedSchemes());
            this.selectScheme(selectedSchemeBackup);
            this.setListLoaded(true);
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
        }
    }

    private void setListLoaded(boolean b) {
        this.myListLoaded = b;
    }

    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    protected AbstractSchemeActions<EditorColorsScheme> createSchemeActions() {
        return new ColorSchemeActions(this){

            @Override
            @NotNull
            protected ColorAndFontOptions getOptions() {
                ColorAndFontOptions colorAndFontOptions = SchemesPanel.this.myOptions;
                if (colorAndFontOptions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/SchemesPanel$1", "getOptions"));
                }
                return colorAndFontOptions;
            }

            @Override
            protected void onSchemeChanged(@Nullable EditorColorsScheme scheme2) {
                if (scheme2 != null) {
                    SchemesPanel.this.myOptions.selectScheme(scheme2.getName());
                    if (SchemesPanel.this.areSchemesLoaded()) {
                        ((ColorAndFontSettingsListener)SchemesPanel.this.myDispatcher.getMulticaster()).schemeChanged(SchemesPanel.this);
                    }
                }
            }

            @Override
            protected void renameScheme(@NotNull EditorColorsScheme scheme2, @NotNull String newName) {
                if (scheme2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/application/options/colors/SchemesPanel$1", "renameScheme"));
                }
                if (newName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/application/options/colors/SchemesPanel$1", "renameScheme"));
                }
                if (SchemesPanel.this.myOptions.saveSchemeAs(scheme2, newName)) {
                    SchemesPanel.this.myOptions.removeScheme(scheme2);
                    SchemesPanel.this.myOptions.selectScheme(newName);
                }
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<EditorColorsScheme> getModel() {
        ColorAndFontOptions colorAndFontOptions = this.myOptions;
        if (colorAndFontOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/SchemesPanel", "getModel"));
        }
        return colorAndFontOptions;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }
}

