/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorAppearanceConfigurableEP;
import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsConfigurable;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EditorAppearanceConfigurable
extends CompositeConfigurable<UnnamedConfigurable>
implements EditorOptionsProvider {
    private static final ExtensionPointName<EditorAppearanceConfigurableEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.editorAppearanceConfigurable");
    private JPanel myRootPanel;
    private JCheckBox myCbBlinkCaret;
    private JCheckBox myCbBlockCursor;
    private JCheckBox myCbRightMargin;
    private JCheckBox myCbShowLineNumbers;
    private JCheckBox myCbShowWhitespaces;
    private JCheckBox myLeadingWhitespacesCheckBox;
    private JCheckBox myInnerWhitespacesCheckBox;
    private JCheckBox myTrailingWhitespacesCheckBox;
    private JTextField myBlinkIntervalField;
    private JPanel myAddonPanel;
    private JCheckBox myCbShowMethodSeparators;
    private JCheckBox myShowCodeLensInEditorCheckBox;
    private JCheckBox myShowVerticalIndentGuidesCheckBox;
    private JCheckBox myShowBreadcrumbsCheckBox;
    private JPanel myParameterHintsSettingsPanel;
    private JBCheckBox myShowParameterNameHints;
    private JButton myConfigureParameterHintsButton;

    public EditorAppearanceConfigurable() {
        this.$$$setupUI$$$();
        this.myCbBlinkCaret.addActionListener(e -> this.myBlinkIntervalField.setEnabled(this.myCbBlinkCaret.isSelected()));
        this.myCbShowWhitespaces.addActionListener(e -> this.updateWhitespaceCheckboxesState());
        this.initInlaysPanel();
    }

    private void initInlaysPanel() {
        boolean isInlayProvidersAvailable = InlayParameterHintsExtension.INSTANCE.hasAnyExtensions();
        this.myParameterHintsSettingsPanel.setVisible(isInlayProvidersAvailable);
        if (!isInlayProvidersAvailable) {
            return;
        }
        this.myConfigureParameterHintsButton.addActionListener(e -> {
            ParameterNameHintsConfigurable configurable = new ParameterNameHintsConfigurable();
            configurable.show();
        });
    }

    private void applyNameHintsSettings() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        settings.setShowParameterNameHints(this.myShowParameterNameHints.isSelected());
    }

    private void updateWhitespaceCheckboxesState() {
        boolean enabled = this.myCbShowWhitespaces.isSelected();
        this.myLeadingWhitespacesCheckBox.setEnabled(enabled);
        this.myInnerWhitespacesCheckBox.setEnabled(enabled);
        this.myTrailingWhitespacesCheckBox.setEnabled(enabled);
    }

    @Override
    public void reset() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        this.myCbShowMethodSeparators.setSelected(DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS);
        this.myCbBlinkCaret.setSelected(editorSettings.isBlinkCaret());
        this.myBlinkIntervalField.setText(Integer.toString(editorSettings.getBlinkPeriod()));
        this.myBlinkIntervalField.setEnabled(editorSettings.isBlinkCaret());
        this.myCbRightMargin.setSelected(editorSettings.isRightMarginShown());
        this.myCbShowLineNumbers.setSelected(editorSettings.isLineNumbersShown());
        this.myCbBlockCursor.setSelected(editorSettings.isBlockCursor());
        this.myCbShowWhitespaces.setSelected(editorSettings.isWhitespacesShown());
        this.myLeadingWhitespacesCheckBox.setSelected(editorSettings.isLeadingWhitespacesShown());
        this.myInnerWhitespacesCheckBox.setSelected(editorSettings.isInnerWhitespacesShown());
        this.myTrailingWhitespacesCheckBox.setSelected(editorSettings.isTrailingWhitespacesShown());
        this.myShowVerticalIndentGuidesCheckBox.setSelected(editorSettings.isIndentGuidesShown());
        this.myShowBreadcrumbsCheckBox.setSelected(editorSettings.isBreadcrumbsShown());
        this.myShowCodeLensInEditorCheckBox.setSelected(UISettings.getInstance().getShowToolWindowsNumbers());
        this.updateWhitespaceCheckboxesState();
        this.myShowParameterNameHints.setSelected(editorSettings.isShowParameterNameHints());
        super.reset();
    }

    @Override
    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        editorSettings.setBlinkCaret(this.myCbBlinkCaret.isSelected());
        try {
            editorSettings.setBlinkPeriod(Integer.parseInt(this.myBlinkIntervalField.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        editorSettings.setBlockCursor(this.myCbBlockCursor.isSelected());
        editorSettings.setRightMarginShown(this.myCbRightMargin.isSelected());
        editorSettings.setLineNumbersShown(this.myCbShowLineNumbers.isSelected());
        editorSettings.setWhitespacesShown(this.myCbShowWhitespaces.isSelected());
        editorSettings.setLeadingWhitespacesShown(this.myLeadingWhitespacesCheckBox.isSelected());
        editorSettings.setInnerWhitespacesShown(this.myInnerWhitespacesCheckBox.isSelected());
        editorSettings.setTrailingWhitespacesShown(this.myTrailingWhitespacesCheckBox.isSelected());
        editorSettings.setIndentGuidesShown(this.myShowVerticalIndentGuidesCheckBox.isSelected());
        EditorOptionsPanel.reinitAllEditors();
        DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS = this.myCbShowMethodSeparators.isSelected();
        UISettings uiSettings = UISettings.getInstance();
        boolean uiSettingsModified = false;
        boolean lafSettingsModified = false;
        if (uiSettings.getShowEditorToolTip() != this.myShowCodeLensInEditorCheckBox.isSelected()) {
            uiSettings.setShowToolWindowsNumbers(this.myShowCodeLensInEditorCheckBox.isSelected());
            uiSettingsModified = true;
            lafSettingsModified = true;
        }
        if (editorSettings.isBreadcrumbsShown() != this.myShowBreadcrumbsCheckBox.isSelected()) {
            editorSettings.setBreadcrumbsShown(this.myShowBreadcrumbsCheckBox.isSelected());
            uiSettingsModified = true;
        }
        if (lafSettingsModified) {
            LafManager.getInstance().repaintUI();
        }
        if (uiSettingsModified) {
            uiSettings.fireUISettingsChanged();
        }
        EditorOptionsPanel.restartDaemons();
        this.applyNameHintsSettings();
        super.apply();
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        boolean isModified = this.isModified(this.myCbBlinkCaret, editorSettings.isBlinkCaret());
        isModified |= this.isModified(this.myBlinkIntervalField, editorSettings.getBlinkPeriod(), EditorSettingsExternalizable.BLINKING_RANGE);
        isModified |= this.isModified(this.myCbBlockCursor, editorSettings.isBlockCursor());
        isModified |= this.isModified(this.myCbRightMargin, editorSettings.isRightMarginShown());
        isModified |= this.isModified(this.myCbShowLineNumbers, editorSettings.isLineNumbersShown());
        isModified |= this.isModified(this.myCbShowWhitespaces, editorSettings.isWhitespacesShown());
        isModified |= this.isModified(this.myLeadingWhitespacesCheckBox, editorSettings.isLeadingWhitespacesShown());
        isModified |= this.isModified(this.myInnerWhitespacesCheckBox, editorSettings.isInnerWhitespacesShown());
        isModified |= this.isModified(this.myTrailingWhitespacesCheckBox, editorSettings.isTrailingWhitespacesShown());
        isModified |= this.isModified(this.myShowVerticalIndentGuidesCheckBox, editorSettings.isIndentGuidesShown());
        isModified |= this.isModified(this.myCbShowMethodSeparators, DaemonCodeAnalyzerSettings.getInstance().SHOW_METHOD_SEPARATORS);
        isModified |= this.myShowCodeLensInEditorCheckBox.isSelected() != UISettings.getInstance().getShowEditorToolTip();
        isModified |= this.myShowBreadcrumbsCheckBox.isSelected() != editorSettings.isBreadcrumbsShown();
        return isModified |= this.myShowParameterNameHints.isSelected() != editorSettings.isShowParameterNameHints();
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"tab.editor.settings.appearance", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.editor.appearance";
    }

    public JComponent createComponent() {
        for (UnnamedConfigurable provider : this.getConfigurables()) {
            JComponent component = provider.createComponent();
            if (component == null) continue;
            this.myAddonPanel.add((Component)component, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 15, 0), 0, 0));
        }
        return this.myRootPanel;
    }

    @Override
    public void disposeUIResources() {
        this.myAddonPanel.removeAll();
        super.disposeUIResources();
    }

    @Override
    protected List<UnnamedConfigurable> createConfigurables() {
        return ConfigurableWrapper.createConfigurables(EP_NAME);
    }

    @NotNull
    public String getId() {
        if ("editor.preferences.appearance" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/editor/EditorAppearanceConfigurable", "getId"));
        }
        return "editor.preferences.appearance";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JPanel jPanel2;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JCheckBox jCheckBox12;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(15, 21, new Insets(0, 0, 0, 0), -1, 0, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(14, 0, 1, 21, 0, 2, 1, 6, null, null, null));
        this.myCbBlockCursor = jCheckBox12 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox12, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.use.block.caret"));
        jPanel3.add((Component)jCheckBox12, new GridConstraints(1, 0, 1, 21, 8, 0, 3, 0, null, null, null));
        this.myCbRightMargin = jCheckBox11 = new JCheckBox();
        jCheckBox11.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox11, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.right.margin"));
        jPanel3.add((Component)jCheckBox11, new GridConstraints(2, 0, 1, 21, 8, 0, 3, 0, null, null, null));
        this.myCbShowLineNumbers = jCheckBox10 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox10, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.line.numbers"));
        jPanel3.add((Component)jCheckBox10, new GridConstraints(3, 0, 1, 21, 8, 0, 3, 0, null, null, null));
        this.myCbShowWhitespaces = jCheckBox9 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.whitespaces"));
        jPanel3.add((Component)jCheckBox9, new GridConstraints(5, 0, 1, 21, 8, 0, 3, 0, null, null, null));
        this.myLeadingWhitespacesCheckBox = jCheckBox8 = new JCheckBox();
        ((Component)jCheckBox8).setEnabled(false);
        jCheckBox8.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.leading.whitespaces"));
        jPanel3.add((Component)jCheckBox8, new GridConstraints(6, 0, 1, 21, 8, 0, 3, 0, null, null, null, 2));
        this.myInnerWhitespacesCheckBox = jCheckBox7 = new JCheckBox();
        ((Component)jCheckBox7).setEnabled(false);
        jCheckBox7.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.inner.whitespaces"));
        jPanel3.add((Component)jCheckBox7, new GridConstraints(7, 0, 1, 21, 8, 0, 3, 0, null, null, null, 2));
        this.myTrailingWhitespacesCheckBox = jCheckBox6 = new JCheckBox();
        ((Component)jCheckBox6).setEnabled(false);
        jCheckBox6.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.trailing.whitespaces"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(8, 0, 1, 21, 8, 0, 3, 0, null, null, null, 2));
        this.myShowVerticalIndentGuidesCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Show vertical indent guides");
        jPanel3.add((Component)jCheckBox5, new GridConstraints(9, 0, 1, 21, 8, 0, 3, 0, null, null, null));
        this.myAddonPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.add((Component)jPanel2, new GridConstraints(13, 0, 1, 15, 8, 2, 3, 3, null, null, null));
        this.myCbShowMethodSeparators = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.method.separators"));
        jPanel3.add((Component)jCheckBox4, new GridConstraints(4, 0, 1, 21, 8, 0, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 21, 0, 3, 3, 3, null, null, null));
        this.myCbBlinkCaret = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(true);
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.caret.blinking.ms"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBlinkIntervalField = jTextField = new JTextField();
        jTextField.setText("500");
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(50, -1), new Dimension(50, -1)));
        this.myShowCodeLensInEditorCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("checkbox.show.editor.preview.popup"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(10, 0, 1, 21, 8, 0, 3, 0, null, new Dimension(251, 19), null));
        this.myShowBreadcrumbsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.breadcrumbs"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(11, 0, 1, 21, 8, 0, 3, 0, null, null, null));
        this.myParameterHintsSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(12, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShowParameterNameHints = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.parameter.name.hints"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConfigureParameterHintsButton = jButton = new JButton();
        jButton.setText("Configure...");
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 8, 0, 5, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

