/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.pathMacros;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.application.options.pathMacros.PathMacroEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.Table;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class PathMacroTable
extends Table {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.pathMacros.PathMacroTable");
    private final PathMacros myPathMacros = PathMacros.getInstance();
    private final MyTableModel myTableModel = new MyTableModel();
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private final List<Couple<String>> myMacros = new ArrayList<Couple<String>>();
    private static final Comparator<Couple<String>> MACRO_COMPARATOR = Comparator.comparing(pair -> (String)pair.getFirst());
    private final Collection<String> myUndefinedMacroNames;

    public PathMacroTable() {
        this(null);
    }

    public PathMacroTable(Collection<String> undefinedMacroNames) {
        this.myUndefinedMacroNames = undefinedMacroNames;
        this.setModel(this.myTableModel);
        TableColumn column = this.getColumnModel().getColumn(0);
        column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String macroValue = PathMacroTable.this.getMacroValueAt(row);
                component.setForeground((Color)(macroValue.length() == 0 ? JBColor.RED : (isSelected ? table.getSelectionForeground() : table.getForeground())));
                return component;
            }
        });
        this.setSelectionMode(2);
        this.getEmptyText().setText(ApplicationBundle.message((String)"text.no.path.variables", (Object[])new Object[0]));
    }

    public String getMacroValueAt(int row) {
        return (String)this.getValueAt(row, 1);
    }

    public void addMacro() {
        String title = ApplicationBundle.message((String)"title.add.variable", (Object[])new Object[0]);
        PathMacroEditor macroEditor = new PathMacroEditor(title, "", "", new AddValidator(title));
        if (macroEditor.showAndGet()) {
            String name = macroEditor.getName();
            this.myMacros.add((Couple<String>)Couple.of((Object)name, (Object)macroEditor.getValue()));
            Collections.sort(this.myMacros, MACRO_COMPARATOR);
            int index = this.indexOfMacroWithName(name);
            LOG.assertTrue(index >= 0);
            this.myTableModel.fireTableDataChanged();
            this.setRowSelectionInterval(index, index);
        }
    }

    private boolean isValidRow(int selectedRow) {
        return selectedRow >= 0 && selectedRow < this.myMacros.size();
    }

    public void removeSelectedMacros() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            return;
        }
        Arrays.sort(selectedRows);
        int originalRow = selectedRows[0];
        for (int i2 = selectedRows.length - 1; i2 >= 0; --i2) {
            int selectedRow = selectedRows[i2];
            if (!this.isValidRow(selectedRow)) continue;
            this.myMacros.remove(selectedRow);
        }
        this.myTableModel.fireTableDataChanged();
        if (originalRow < this.getRowCount()) {
            this.setRowSelectionInterval(originalRow, originalRow);
        } else if (this.getRowCount() > 0) {
            int index = this.getRowCount() - 1;
            this.setRowSelectionInterval(index, index);
        }
    }

    public void commit() {
        this.myPathMacros.removeAllMacros();
        for (Couple<String> pair : this.myMacros) {
            String value = (String)pair.getSecond();
            if (value == null || value.trim().length() <= 0) continue;
            String path = value.replace(File.separatorChar, '/');
            path = StringUtil.trimEnd((String)path, (String)"/");
            this.myPathMacros.setMacro((String)pair.getFirst(), path);
        }
    }

    public void reset() {
        this.obtainData();
    }

    private boolean hasMacroWithName(String name) {
        if (PathMacros.getInstance().getSystemMacroNames().contains(name)) {
            return true;
        }
        for (Couple<String> macro : this.myMacros) {
            if (!name.equals(macro.getFirst())) continue;
            return true;
        }
        return false;
    }

    private int indexOfMacroWithName(String name) {
        for (int i2 = 0; i2 < this.myMacros.size(); ++i2) {
            Couple<String> pair = this.myMacros.get(i2);
            if (!name.equals(pair.getFirst())) continue;
            return i2;
        }
        return -1;
    }

    private void obtainData() {
        this.obtainMacroPairs(this.myMacros);
        this.myTableModel.fireTableDataChanged();
    }

    private void obtainMacroPairs(List<Couple<String>> macros) {
        macros.clear();
        Set macroNames = this.myPathMacros.getUserMacroNames();
        for (String name : macroNames) {
            macros.add((Couple<String>)Couple.of((Object)name, (Object)this.myPathMacros.getValue(name).replace('/', File.separatorChar)));
        }
        if (this.myUndefinedMacroNames != null) {
            for (String undefinedMacroName : this.myUndefinedMacroNames) {
                macros.add((Couple<String>)Couple.of((Object)undefinedMacroName, (Object)""));
            }
        }
        Collections.sort(macros, MACRO_COMPARATOR);
    }

    public void editMacro() {
        String macroName;
        if (this.getSelectedRowCount() != 1) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        Couple<String> pair = this.myMacros.get(selectedRow);
        String title = ApplicationBundle.message((String)"title.edit.variable", (Object[])new Object[0]);
        PathMacroEditor macroEditor = new PathMacroEditor(title, macroName = (String)pair.getFirst(), (String)pair.getSecond(), new EditValidator());
        if (macroEditor.showAndGet()) {
            this.myMacros.remove(selectedRow);
            this.myMacros.add((Couple<String>)Couple.of((Object)macroEditor.getName(), (Object)macroEditor.getValue()));
            Collections.sort(this.myMacros, MACRO_COMPARATOR);
            this.myTableModel.fireTableDataChanged();
        }
    }

    public boolean isModified() {
        ArrayList<Couple<String>> macros = new ArrayList<Couple<String>>();
        this.obtainMacroPairs(macros);
        return !macros.equals(this.myMacros);
    }

    private static class EditValidator
    implements PathMacroEditor.Validator {
        private EditValidator() {
        }

        @Override
        public boolean checkName(String name) {
            if (name.isEmpty() || PathMacros.getInstance().getSystemMacroNames().contains(name)) {
                return false;
            }
            return PathMacrosCollector.MACRO_PATTERN.matcher("$" + name + "$").matches();
        }

        @Override
        public boolean isOK(String name, String value) {
            return this.checkName(name);
        }
    }

    private class AddValidator
    implements PathMacroEditor.Validator {
        private final String myTitle;

        public AddValidator(String title) {
            this.myTitle = title;
        }

        @Override
        public boolean checkName(String name) {
            if (name.length() == 0) {
                return false;
            }
            return PathMacrosCollector.MACRO_PATTERN.matcher("$" + name + "$").matches();
        }

        @Override
        public boolean isOK(String name, String value) {
            if (name.length() == 0) {
                return false;
            }
            if (PathMacroTable.this.hasMacroWithName(name)) {
                Messages.showErrorDialog((Component)((Object)PathMacroTable.this), (String)ApplicationBundle.message((String)"error.variable.already.exists", (Object[])new Object[]{name}), (String)this.myTitle);
                return false;
            }
            return true;
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PathMacroTable.this.myMacros.size();
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Couple pair = (Couple)PathMacroTable.this.myMacros.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return pair.getFirst();
                }
                case 1: {
                    return pair.getSecond();
                }
            }
            LOG.error("Wrong indices");
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ApplicationBundle.message((String)"column.name", (Object[])new Object[0]);
                }
                case 1: {
                    return ApplicationBundle.message((String)"column.value", (Object[])new Object[0]);
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

