/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.schemes;

import com.intellij.openapi.options.Scheme;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemeNameGenerator {
    private static final String COPY_NAME_SUFFIX = "copy";

    private SchemeNameGenerator() {
    }

    public static String getUniqueName(@NotNull String preferredName, @NotNull Predicate<String> nameExistsPredicate) {
        if (preferredName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferredName", "com/intellij/application/options/schemes/SchemeNameGenerator", "getUniqueName"));
        }
        if (nameExistsPredicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExistsPredicate", "com/intellij/application/options/schemes/SchemeNameGenerator", "getUniqueName"));
        }
        if (nameExistsPredicate.test(preferredName)) {
            String baseName;
            int numberPos;
            for (numberPos = preferredName.length() - 1; numberPos >= 0 && Character.isDigit(preferredName.charAt(numberPos)); --numberPos) {
            }
            String string = baseName = numberPos >= 0 ? preferredName.substring(0, numberPos + 1) : preferredName;
            if (!baseName.endsWith(COPY_NAME_SUFFIX)) {
                baseName = preferredName + " " + COPY_NAME_SUFFIX;
            }
            if (!nameExistsPredicate.test(baseName)) {
                return baseName;
            }
            int i2 = 1;
            while (true) {
                String newName;
                if (!nameExistsPredicate.test(newName = baseName + i2)) {
                    return newName;
                }
                ++i2;
            }
        }
        return preferredName;
    }

    public static String getUniqueName(@Nullable String preferredName, @Nullable Scheme parentScheme, @NotNull Predicate<String> nameExistsPredicate) {
        if (nameExistsPredicate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExistsPredicate", "com/intellij/application/options/schemes/SchemeNameGenerator", "getUniqueName"));
        }
        assert (preferredName != null || parentScheme != null) : "Either preferredName or parentScheme must be non-null";
        String baseName = preferredName != null ? preferredName : parentScheme.getName();
        return SchemeNameGenerator.getUniqueName(baseName, nameExistsPredicate);
    }
}

