/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.CodeEditorBundle;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HyperlinksToClassesOption
extends PrintOption {
    private JCheckBox myCbGenerateHyperlinksToClasses;
    private boolean isGenerateHyperlinksToClasses;

    @Override
    @Nullable
    public TreeMap<Integer, PsiReference> collectReferences(PsiFile psiFile, Map<PsiFile, PsiFile> filesMap) {
        FileType fileType;
        if (this.isGenerateHyperlinksToClasses && (StdFileTypes.JAVA == (fileType = psiFile.getFileType()) || StdFileTypes.JSP == fileType)) {
            TreeMap<Integer, PsiReference> refMap = new TreeMap<Integer, PsiReference>();
            HyperlinksToClassesOption.findClassReferences((PsiElement)psiFile, refMap, filesMap, psiFile);
            return refMap;
        }
        return null;
    }

    @Override
    @NotNull
    public UnnamedConfigurable createConfigurable() {
        HyperlinksToClassesConfigurable hyperlinksToClassesConfigurable = new HyperlinksToClassesConfigurable();
        if (hyperlinksToClassesConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeEditor/printing/HyperlinksToClassesOption", "createConfigurable"));
        }
        return hyperlinksToClassesConfigurable;
    }

    private static void findClassReferences(PsiElement psiElement, TreeMap<Integer, PsiReference> refMap, Map<PsiFile, PsiFile> filesMap, PsiFile psiFile) {
        PsiElement[] children2;
        PsiElement refElement;
        PsiReference ref = psiElement.getReference();
        if (ref instanceof PsiJavaCodeReferenceElement && (refElement = ref.resolve()) instanceof PsiClass) {
            PsiFile containingFile = refElement.getContainingFile();
            if (!containingFile.equals(psiFile) && filesMap.get(containingFile) != null) {
                refMap.put(psiElement.getTextRange().getStartOffset(), ref);
            }
            return;
        }
        for (PsiElement aChildren : children2 = psiElement.getChildren()) {
            HyperlinksToClassesOption.findClassReferences(aChildren, refMap, filesMap, psiFile);
        }
    }

    private class HyperlinksToClassesConfigurable
    implements UnnamedConfigurable {
        private HyperlinksToClassesConfigurable() {
        }

        public JComponent createComponent() {
            HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses = new JCheckBox(CodeEditorBundle.message("export.to.html.generate.hyperlinks.checkbox", new Object[0]), HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses);
            return HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses;
        }

        public boolean isModified() {
            return HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses.isSelected() != HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses;
        }

        public void apply() throws ConfigurationException {
            HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses = HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses.isSelected();
        }

        public void reset() {
            HyperlinksToClassesOption.this.myCbGenerateHyperlinksToClasses.setSelected(HyperlinksToClassesOption.this.isGenerateHyperlinksToClasses);
        }

        public void disposeUIResources() {
        }
    }
}

